/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a successfully created item in a batch operation for workload estimate usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateWorkloadEstimateUsageItem implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchCreateWorkloadEstimateUsageItem.Builder, BatchCreateWorkloadEstimateUsageItem> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceCode").getter(getter(BatchCreateWorkloadEstimateUsageItem::serviceCode))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageType").getter(getter(BatchCreateWorkloadEstimateUsageItem::usageType))
            .setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operation").getter(getter(BatchCreateWorkloadEstimateUsageItem::operation))
            .setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(BatchCreateWorkloadEstimateUsageItem::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(BatchCreateWorkloadEstimateUsageItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> USAGE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageAccountId").getter(getter(BatchCreateWorkloadEstimateUsageItem::usageAccountId))
            .setter(setter(Builder::usageAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageAccountId").build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("group")
            .getter(getter(BatchCreateWorkloadEstimateUsageItem::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final SdkField<WorkloadEstimateUsageQuantity> QUANTITY_FIELD = SdkField
            .<WorkloadEstimateUsageQuantity> builder(MarshallingType.SDK_POJO).memberName("quantity")
            .getter(getter(BatchCreateWorkloadEstimateUsageItem::quantity)).setter(setter(Builder::quantity))
            .constructor(WorkloadEstimateUsageQuantity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantity").build()).build();

    private static final SdkField<Double> COST_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("cost")
            .getter(getter(BatchCreateWorkloadEstimateUsageItem::cost)).setter(setter(Builder::cost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cost").build()).build();

    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currency").getter(getter(BatchCreateWorkloadEstimateUsageItem::currencyAsString))
            .setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BatchCreateWorkloadEstimateUsageItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<HistoricalUsageEntity> HISTORICAL_USAGE_FIELD = SdkField
            .<HistoricalUsageEntity> builder(MarshallingType.SDK_POJO).memberName("historicalUsage")
            .getter(getter(BatchCreateWorkloadEstimateUsageItem::historicalUsage)).setter(setter(Builder::historicalUsage))
            .constructor(HistoricalUsageEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("historicalUsage").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(BatchCreateWorkloadEstimateUsageItem::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            USAGE_TYPE_FIELD, OPERATION_FIELD, LOCATION_FIELD, ID_FIELD, USAGE_ACCOUNT_ID_FIELD, GROUP_FIELD, QUANTITY_FIELD,
            COST_FIELD, CURRENCY_FIELD, STATUS_FIELD, HISTORICAL_USAGE_FIELD, KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceCode;

    private final String usageType;

    private final String operation;

    private final String location;

    private final String id;

    private final String usageAccountId;

    private final String group;

    private final WorkloadEstimateUsageQuantity quantity;

    private final Double cost;

    private final String currency;

    private final String status;

    private final HistoricalUsageEntity historicalUsage;

    private final String key;

    private BatchCreateWorkloadEstimateUsageItem(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
        this.location = builder.location;
        this.id = builder.id;
        this.usageAccountId = builder.usageAccountId;
        this.group = builder.group;
        this.quantity = builder.quantity;
        this.cost = builder.cost;
        this.currency = builder.currency;
        this.status = builder.status;
        this.historicalUsage = builder.historicalUsage;
        this.key = builder.key;
    }

    /**
     * <p>
     * The Amazon Web Services service code for this usage estimate.
     * </p>
     * 
     * @return The Amazon Web Services service code for this usage estimate.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The type of usage that was estimated.
     * </p>
     * 
     * @return The type of usage that was estimated.
     */
    public final String usageType() {
        return usageType;
    }

    /**
     * <p>
     * The specific operation associated with this usage estimate.
     * </p>
     * 
     * @return The specific operation associated with this usage estimate.
     */
    public final String operation() {
        return operation;
    }

    /**
     * <p>
     * The location associated with this usage estimate.
     * </p>
     * 
     * @return The location associated with this usage estimate.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The unique identifier assigned to the created usage estimate.
     * </p>
     * 
     * @return The unique identifier assigned to the created usage estimate.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the created usage estimate.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the created usage estimate.
     */
    public final String usageAccountId() {
        return usageAccountId;
    }

    /**
     * <p>
     * The group identifier for the created usage estimate.
     * </p>
     * 
     * @return The group identifier for the created usage estimate.
     */
    public final String group() {
        return group;
    }

    /**
     * <p>
     * The estimated usage quantity.
     * </p>
     * 
     * @return The estimated usage quantity.
     */
    public final WorkloadEstimateUsageQuantity quantity() {
        return quantity;
    }

    /**
     * <p>
     * The estimated cost associated with this usage.
     * </p>
     * 
     * @return The estimated cost associated with this usage.
     */
    public final Double cost() {
        return cost;
    }

    /**
     * <p>
     * The currency of the estimated cost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency of the estimated cost.
     * @see CurrencyCode
     */
    public final CurrencyCode currency() {
        return CurrencyCode.fromValue(currency);
    }

    /**
     * <p>
     * The currency of the estimated cost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency of the estimated cost.
     * @see CurrencyCode
     */
    public final String currencyAsString() {
        return currency;
    }

    /**
     * <p>
     * The current status of the created usage estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkloadEstimateCostStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the created usage estimate.
     * @see WorkloadEstimateCostStatus
     */
    public final WorkloadEstimateCostStatus status() {
        return WorkloadEstimateCostStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the created usage estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkloadEstimateCostStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the created usage estimate.
     * @see WorkloadEstimateCostStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Historical usage data associated with this estimate, if available.
     * </p>
     * 
     * @return Historical usage data associated with this estimate, if available.
     */
    public final HistoricalUsageEntity historicalUsage() {
        return historicalUsage;
    }

    /**
     * <p>
     * The key of the successfully created entry.
     * </p>
     * 
     * @return The key of the successfully created entry.
     */
    public final String key() {
        return key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(usageType());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(usageAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(cost());
        hashCode = 31 * hashCode + Objects.hashCode(currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(historicalUsage());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateWorkloadEstimateUsageItem)) {
            return false;
        }
        BatchCreateWorkloadEstimateUsageItem other = (BatchCreateWorkloadEstimateUsageItem) obj;
        return Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(usageType(), other.usageType())
                && Objects.equals(operation(), other.operation()) && Objects.equals(location(), other.location())
                && Objects.equals(id(), other.id()) && Objects.equals(usageAccountId(), other.usageAccountId())
                && Objects.equals(group(), other.group()) && Objects.equals(quantity(), other.quantity())
                && Objects.equals(cost(), other.cost()) && Objects.equals(currencyAsString(), other.currencyAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(historicalUsage(), other.historicalUsage()) && Objects.equals(key(), other.key());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateWorkloadEstimateUsageItem").add("ServiceCode", serviceCode())
                .add("UsageType", usageType()).add("Operation", operation()).add("Location", location()).add("Id", id())
                .add("UsageAccountId", usageAccountId()).add("Group", group()).add("Quantity", quantity()).add("Cost", cost())
                .add("Currency", currencyAsString()).add("Status", statusAsString()).add("HistoricalUsage", historicalUsage())
                .add("Key", key()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "usageType":
            return Optional.ofNullable(clazz.cast(usageType()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "usageAccountId":
            return Optional.ofNullable(clazz.cast(usageAccountId()));
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        case "quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "cost":
            return Optional.ofNullable(clazz.cast(cost()));
        case "currency":
            return Optional.ofNullable(clazz.cast(currencyAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "historicalUsage":
            return Optional.ofNullable(clazz.cast(historicalUsage()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceCode", SERVICE_CODE_FIELD);
        map.put("usageType", USAGE_TYPE_FIELD);
        map.put("operation", OPERATION_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("id", ID_FIELD);
        map.put("usageAccountId", USAGE_ACCOUNT_ID_FIELD);
        map.put("group", GROUP_FIELD);
        map.put("quantity", QUANTITY_FIELD);
        map.put("cost", COST_FIELD);
        map.put("currency", CURRENCY_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("historicalUsage", HISTORICAL_USAGE_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateWorkloadEstimateUsageItem, T> g) {
        return obj -> g.apply((BatchCreateWorkloadEstimateUsageItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchCreateWorkloadEstimateUsageItem> {
        /**
         * <p>
         * The Amazon Web Services service code for this usage estimate.
         * </p>
         * 
         * @param serviceCode
         *        The Amazon Web Services service code for this usage estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The type of usage that was estimated.
         * </p>
         * 
         * @param usageType
         *        The type of usage that was estimated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageType(String usageType);

        /**
         * <p>
         * The specific operation associated with this usage estimate.
         * </p>
         * 
         * @param operation
         *        The specific operation associated with this usage estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * The location associated with this usage estimate.
         * </p>
         * 
         * @param location
         *        The location associated with this usage estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The unique identifier assigned to the created usage estimate.
         * </p>
         * 
         * @param id
         *        The unique identifier assigned to the created usage estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Web Services account ID associated with the created usage estimate.
         * </p>
         * 
         * @param usageAccountId
         *        The Amazon Web Services account ID associated with the created usage estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageAccountId(String usageAccountId);

        /**
         * <p>
         * The group identifier for the created usage estimate.
         * </p>
         * 
         * @param group
         *        The group identifier for the created usage estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The estimated usage quantity.
         * </p>
         * 
         * @param quantity
         *        The estimated usage quantity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(WorkloadEstimateUsageQuantity quantity);

        /**
         * <p>
         * The estimated usage quantity.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkloadEstimateUsageQuantity.Builder}
         * avoiding the need to create one manually via {@link WorkloadEstimateUsageQuantity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkloadEstimateUsageQuantity.Builder#build()} is called
         * immediately and its result is passed to {@link #quantity(WorkloadEstimateUsageQuantity)}.
         * 
         * @param quantity
         *        a consumer that will call methods on {@link WorkloadEstimateUsageQuantity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quantity(WorkloadEstimateUsageQuantity)
         */
        default Builder quantity(Consumer<WorkloadEstimateUsageQuantity.Builder> quantity) {
            return quantity(WorkloadEstimateUsageQuantity.builder().applyMutation(quantity).build());
        }

        /**
         * <p>
         * The estimated cost associated with this usage.
         * </p>
         * 
         * @param cost
         *        The estimated cost associated with this usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cost(Double cost);

        /**
         * <p>
         * The currency of the estimated cost.
         * </p>
         * 
         * @param currency
         *        The currency of the estimated cost.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currency(String currency);

        /**
         * <p>
         * The currency of the estimated cost.
         * </p>
         * 
         * @param currency
         *        The currency of the estimated cost.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currency(CurrencyCode currency);

        /**
         * <p>
         * The current status of the created usage estimate.
         * </p>
         * 
         * @param status
         *        The current status of the created usage estimate.
         * @see WorkloadEstimateCostStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadEstimateCostStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the created usage estimate.
         * </p>
         * 
         * @param status
         *        The current status of the created usage estimate.
         * @see WorkloadEstimateCostStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadEstimateCostStatus
         */
        Builder status(WorkloadEstimateCostStatus status);

        /**
         * <p>
         * Historical usage data associated with this estimate, if available.
         * </p>
         * 
         * @param historicalUsage
         *        Historical usage data associated with this estimate, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalUsage(HistoricalUsageEntity historicalUsage);

        /**
         * <p>
         * Historical usage data associated with this estimate, if available.
         * </p>
         * This is a convenience method that creates an instance of the {@link HistoricalUsageEntity.Builder} avoiding
         * the need to create one manually via {@link HistoricalUsageEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HistoricalUsageEntity.Builder#build()} is called immediately and
         * its result is passed to {@link #historicalUsage(HistoricalUsageEntity)}.
         * 
         * @param historicalUsage
         *        a consumer that will call methods on {@link HistoricalUsageEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #historicalUsage(HistoricalUsageEntity)
         */
        default Builder historicalUsage(Consumer<HistoricalUsageEntity.Builder> historicalUsage) {
            return historicalUsage(HistoricalUsageEntity.builder().applyMutation(historicalUsage).build());
        }

        /**
         * <p>
         * The key of the successfully created entry.
         * </p>
         * 
         * @param key
         *        The key of the successfully created entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);
    }

    static final class BuilderImpl implements Builder {
        private String serviceCode;

        private String usageType;

        private String operation;

        private String location;

        private String id;

        private String usageAccountId;

        private String group;

        private WorkloadEstimateUsageQuantity quantity;

        private Double cost;

        private String currency;

        private String status;

        private HistoricalUsageEntity historicalUsage;

        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateWorkloadEstimateUsageItem model) {
            serviceCode(model.serviceCode);
            usageType(model.usageType);
            operation(model.operation);
            location(model.location);
            id(model.id);
            usageAccountId(model.usageAccountId);
            group(model.group);
            quantity(model.quantity);
            cost(model.cost);
            currency(model.currency);
            status(model.status);
            historicalUsage(model.historicalUsage);
            key(model.key);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getUsageAccountId() {
            return usageAccountId;
        }

        public final void setUsageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
        }

        @Override
        public final Builder usageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
            return this;
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final WorkloadEstimateUsageQuantity.Builder getQuantity() {
            return quantity != null ? quantity.toBuilder() : null;
        }

        public final void setQuantity(WorkloadEstimateUsageQuantity.BuilderImpl quantity) {
            this.quantity = quantity != null ? quantity.build() : null;
        }

        @Override
        public final Builder quantity(WorkloadEstimateUsageQuantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public final Double getCost() {
            return cost;
        }

        public final void setCost(Double cost) {
            this.cost = cost;
        }

        @Override
        public final Builder cost(Double cost) {
            this.cost = cost;
            return this;
        }

        public final String getCurrency() {
            return currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(CurrencyCode currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkloadEstimateCostStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final HistoricalUsageEntity.Builder getHistoricalUsage() {
            return historicalUsage != null ? historicalUsage.toBuilder() : null;
        }

        public final void setHistoricalUsage(HistoricalUsageEntity.BuilderImpl historicalUsage) {
            this.historicalUsage = historicalUsage != null ? historicalUsage.build() : null;
        }

        @Override
        public final Builder historicalUsage(HistoricalUsageEntity historicalUsage) {
            this.historicalUsage = historicalUsage;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public BatchCreateWorkloadEstimateUsageItem build() {
            return new BatchCreateWorkloadEstimateUsageItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
