/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an error that occurred when updating a commitment in a Bill Scenario.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateBillScenarioCommitmentModificationError
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<BatchUpdateBillScenarioCommitmentModificationError.Builder, BatchUpdateBillScenarioCommitmentModificationError> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(BatchUpdateBillScenarioCommitmentModificationError::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(BatchUpdateBillScenarioCommitmentModificationError::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(BatchUpdateBillScenarioCommitmentModificationError::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ERROR_CODE_FIELD,
            ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String errorCode;

    private final String errorMessage;

    private BatchUpdateBillScenarioCommitmentModificationError(BuilderImpl builder) {
        this.id = builder.id;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The ID of the error.
     * </p>
     * 
     * @return The ID of the error.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The code associated with the error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchUpdateBillScenarioCommitmentModificationErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The code associated with the error.
     * @see BatchUpdateBillScenarioCommitmentModificationErrorCode
     */
    public final BatchUpdateBillScenarioCommitmentModificationErrorCode errorCode() {
        return BatchUpdateBillScenarioCommitmentModificationErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The code associated with the error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchUpdateBillScenarioCommitmentModificationErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The code associated with the error.
     * @see BatchUpdateBillScenarioCommitmentModificationErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The message that describes the error.
     * </p>
     * 
     * @return The message that describes the error.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateBillScenarioCommitmentModificationError)) {
            return false;
        }
        BatchUpdateBillScenarioCommitmentModificationError other = (BatchUpdateBillScenarioCommitmentModificationError) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateBillScenarioCommitmentModificationError").add("Id", id())
                .add("ErrorCode", errorCodeAsString()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateBillScenarioCommitmentModificationError, T> g) {
        return obj -> g.apply((BatchUpdateBillScenarioCommitmentModificationError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchUpdateBillScenarioCommitmentModificationError> {
        /**
         * <p>
         * The ID of the error.
         * </p>
         * 
         * @param id
         *        The ID of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The code associated with the error.
         * </p>
         * 
         * @param errorCode
         *        The code associated with the error.
         * @see BatchUpdateBillScenarioCommitmentModificationErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchUpdateBillScenarioCommitmentModificationErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The code associated with the error.
         * </p>
         * 
         * @param errorCode
         *        The code associated with the error.
         * @see BatchUpdateBillScenarioCommitmentModificationErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchUpdateBillScenarioCommitmentModificationErrorCode
         */
        Builder errorCode(BatchUpdateBillScenarioCommitmentModificationErrorCode errorCode);

        /**
         * <p>
         * The message that describes the error.
         * </p>
         * 
         * @param errorMessage
         *        The message that describes the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateBillScenarioCommitmentModificationError model) {
            id(model.id);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(BatchUpdateBillScenarioCommitmentModificationErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public BatchUpdateBillScenarioCommitmentModificationError build() {
            return new BatchUpdateBillScenarioCommitmentModificationError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
