/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a commitment modification item in a bill scenario.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillScenarioCommitmentModificationItem implements SdkPojo, Serializable,
        ToCopyableBuilder<BillScenarioCommitmentModificationItem.Builder, BillScenarioCommitmentModificationItem> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(BillScenarioCommitmentModificationItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> USAGE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageAccountId").getter(getter(BillScenarioCommitmentModificationItem::usageAccountId))
            .setter(setter(Builder::usageAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageAccountId").build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("group")
            .getter(getter(BillScenarioCommitmentModificationItem::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final SdkField<BillScenarioCommitmentModificationAction> COMMITMENT_ACTION_FIELD = SdkField
            .<BillScenarioCommitmentModificationAction> builder(MarshallingType.SDK_POJO).memberName("commitmentAction")
            .getter(getter(BillScenarioCommitmentModificationItem::commitmentAction)).setter(setter(Builder::commitmentAction))
            .constructor(BillScenarioCommitmentModificationAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            USAGE_ACCOUNT_ID_FIELD, GROUP_FIELD, COMMITMENT_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String usageAccountId;

    private final String group;

    private final BillScenarioCommitmentModificationAction commitmentAction;

    private BillScenarioCommitmentModificationItem(BuilderImpl builder) {
        this.id = builder.id;
        this.usageAccountId = builder.usageAccountId;
        this.group = builder.group;
        this.commitmentAction = builder.commitmentAction;
    }

    /**
     * <p>
     * The unique identifier of the commitment modification.
     * </p>
     * 
     * @return The unique identifier of the commitment modification.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with this commitment modification.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with this commitment modification.
     */
    public final String usageAccountId() {
        return usageAccountId;
    }

    /**
     * <p>
     * The group identifier for the commitment modification.
     * </p>
     * 
     * @return The group identifier for the commitment modification.
     */
    public final String group() {
        return group;
    }

    /**
     * <p>
     * The specific commitment action taken in this modification.
     * </p>
     * 
     * @return The specific commitment action taken in this modification.
     */
    public final BillScenarioCommitmentModificationAction commitmentAction() {
        return commitmentAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(usageAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(commitmentAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillScenarioCommitmentModificationItem)) {
            return false;
        }
        BillScenarioCommitmentModificationItem other = (BillScenarioCommitmentModificationItem) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(usageAccountId(), other.usageAccountId())
                && Objects.equals(group(), other.group()) && Objects.equals(commitmentAction(), other.commitmentAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillScenarioCommitmentModificationItem").add("Id", id()).add("UsageAccountId", usageAccountId())
                .add("Group", group()).add("CommitmentAction", commitmentAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "usageAccountId":
            return Optional.ofNullable(clazz.cast(usageAccountId()));
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        case "commitmentAction":
            return Optional.ofNullable(clazz.cast(commitmentAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("usageAccountId", USAGE_ACCOUNT_ID_FIELD);
        map.put("group", GROUP_FIELD);
        map.put("commitmentAction", COMMITMENT_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillScenarioCommitmentModificationItem, T> g) {
        return obj -> g.apply((BillScenarioCommitmentModificationItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillScenarioCommitmentModificationItem> {
        /**
         * <p>
         * The unique identifier of the commitment modification.
         * </p>
         * 
         * @param id
         *        The unique identifier of the commitment modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Web Services account ID associated with this commitment modification.
         * </p>
         * 
         * @param usageAccountId
         *        The Amazon Web Services account ID associated with this commitment modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageAccountId(String usageAccountId);

        /**
         * <p>
         * The group identifier for the commitment modification.
         * </p>
         * 
         * @param group
         *        The group identifier for the commitment modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The specific commitment action taken in this modification.
         * </p>
         * 
         * @param commitmentAction
         *        The specific commitment action taken in this modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitmentAction(BillScenarioCommitmentModificationAction commitmentAction);

        /**
         * <p>
         * The specific commitment action taken in this modification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BillScenarioCommitmentModificationAction.Builder} avoiding the need to create one manually via
         * {@link BillScenarioCommitmentModificationAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BillScenarioCommitmentModificationAction.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #commitmentAction(BillScenarioCommitmentModificationAction)}.
         * 
         * @param commitmentAction
         *        a consumer that will call methods on {@link BillScenarioCommitmentModificationAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commitmentAction(BillScenarioCommitmentModificationAction)
         */
        default Builder commitmentAction(Consumer<BillScenarioCommitmentModificationAction.Builder> commitmentAction) {
            return commitmentAction(BillScenarioCommitmentModificationAction.builder().applyMutation(commitmentAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String usageAccountId;

        private String group;

        private BillScenarioCommitmentModificationAction commitmentAction;

        private BuilderImpl() {
        }

        private BuilderImpl(BillScenarioCommitmentModificationItem model) {
            id(model.id);
            usageAccountId(model.usageAccountId);
            group(model.group);
            commitmentAction(model.commitmentAction);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getUsageAccountId() {
            return usageAccountId;
        }

        public final void setUsageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
        }

        @Override
        public final Builder usageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
            return this;
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final BillScenarioCommitmentModificationAction.Builder getCommitmentAction() {
            return commitmentAction != null ? commitmentAction.toBuilder() : null;
        }

        public final void setCommitmentAction(BillScenarioCommitmentModificationAction.BuilderImpl commitmentAction) {
            this.commitmentAction = commitmentAction != null ? commitmentAction.build() : null;
        }

        @Override
        public final Builder commitmentAction(BillScenarioCommitmentModificationAction commitmentAction) {
            this.commitmentAction = commitmentAction;
            return this;
        }

        @Override
        public BillScenarioCommitmentModificationItem build() {
            return new BillScenarioCommitmentModificationItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
