/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a time-based filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterTimestamp implements SdkPojo, Serializable, ToCopyableBuilder<FilterTimestamp.Builder, FilterTimestamp> {
    private static final SdkField<Instant> AFTER_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("afterTimestamp").getter(getter(FilterTimestamp::afterTimestamp)).setter(setter(Builder::afterTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterTimestamp").build()).build();

    private static final SdkField<Instant> BEFORE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("beforeTimestamp").getter(getter(FilterTimestamp::beforeTimestamp))
            .setter(setter(Builder::beforeTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFTER_TIMESTAMP_FIELD,
            BEFORE_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant afterTimestamp;

    private final Instant beforeTimestamp;

    private FilterTimestamp(BuilderImpl builder) {
        this.afterTimestamp = builder.afterTimestamp;
        this.beforeTimestamp = builder.beforeTimestamp;
    }

    /**
     * <p>
     * Include results after this timestamp.
     * </p>
     * 
     * @return Include results after this timestamp.
     */
    public final Instant afterTimestamp() {
        return afterTimestamp;
    }

    /**
     * <p>
     * Include results before this timestamp.
     * </p>
     * 
     * @return Include results before this timestamp.
     */
    public final Instant beforeTimestamp() {
        return beforeTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(afterTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(beforeTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterTimestamp)) {
            return false;
        }
        FilterTimestamp other = (FilterTimestamp) obj;
        return Objects.equals(afterTimestamp(), other.afterTimestamp())
                && Objects.equals(beforeTimestamp(), other.beforeTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterTimestamp").add("AfterTimestamp", afterTimestamp())
                .add("BeforeTimestamp", beforeTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "afterTimestamp":
            return Optional.ofNullable(clazz.cast(afterTimestamp()));
        case "beforeTimestamp":
            return Optional.ofNullable(clazz.cast(beforeTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("afterTimestamp", AFTER_TIMESTAMP_FIELD);
        map.put("beforeTimestamp", BEFORE_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterTimestamp, T> g) {
        return obj -> g.apply((FilterTimestamp) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterTimestamp> {
        /**
         * <p>
         * Include results after this timestamp.
         * </p>
         * 
         * @param afterTimestamp
         *        Include results after this timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterTimestamp(Instant afterTimestamp);

        /**
         * <p>
         * Include results before this timestamp.
         * </p>
         * 
         * @param beforeTimestamp
         *        Include results before this timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeTimestamp(Instant beforeTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private Instant afterTimestamp;

        private Instant beforeTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterTimestamp model) {
            afterTimestamp(model.afterTimestamp);
            beforeTimestamp(model.beforeTimestamp);
        }

        public final Instant getAfterTimestamp() {
            return afterTimestamp;
        }

        public final void setAfterTimestamp(Instant afterTimestamp) {
            this.afterTimestamp = afterTimestamp;
        }

        @Override
        public final Builder afterTimestamp(Instant afterTimestamp) {
            this.afterTimestamp = afterTimestamp;
            return this;
        }

        public final Instant getBeforeTimestamp() {
            return beforeTimestamp;
        }

        public final void setBeforeTimestamp(Instant beforeTimestamp) {
            this.beforeTimestamp = beforeTimestamp;
        }

        @Override
        public final Builder beforeTimestamp(Instant beforeTimestamp) {
            this.beforeTimestamp = beforeTimestamp;
            return this;
        }

        @Override
        public FilterTimestamp build() {
            return new FilterTimestamp(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
