/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an action to remove a Reserved Instance from a bill scenario.
 * </p>
 * <p>
 * This is the ID of an existing Reserved Instance in your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NegateReservedInstanceAction implements SdkPojo, Serializable,
        ToCopyableBuilder<NegateReservedInstanceAction.Builder, NegateReservedInstanceAction> {
    private static final SdkField<String> RESERVED_INSTANCES_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reservedInstancesId").getter(getter(NegateReservedInstanceAction::reservedInstancesId))
            .setter(setter(Builder::reservedInstancesId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedInstancesId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCES_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reservedInstancesId;

    private NegateReservedInstanceAction(BuilderImpl builder) {
        this.reservedInstancesId = builder.reservedInstancesId;
    }

    /**
     * <p>
     * The ID of the Reserved Instance to remove.
     * </p>
     * 
     * @return The ID of the Reserved Instance to remove.
     */
    public final String reservedInstancesId() {
        return reservedInstancesId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NegateReservedInstanceAction)) {
            return false;
        }
        NegateReservedInstanceAction other = (NegateReservedInstanceAction) obj;
        return Objects.equals(reservedInstancesId(), other.reservedInstancesId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NegateReservedInstanceAction").add("ReservedInstancesId", reservedInstancesId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reservedInstancesId":
            return Optional.ofNullable(clazz.cast(reservedInstancesId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reservedInstancesId", RESERVED_INSTANCES_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NegateReservedInstanceAction, T> g) {
        return obj -> g.apply((NegateReservedInstanceAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NegateReservedInstanceAction> {
        /**
         * <p>
         * The ID of the Reserved Instance to remove.
         * </p>
         * 
         * @param reservedInstancesId
         *        The ID of the Reserved Instance to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);
    }

    static final class BuilderImpl implements Builder {
        private String reservedInstancesId;

        private BuilderImpl() {
        }

        private BuilderImpl(NegateReservedInstanceAction model) {
            reservedInstancesId(model.reservedInstancesId);
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        @Override
        public NegateReservedInstanceAction build() {
            return new NegateReservedInstanceAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
