/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an entry in a batch operation to create bill scenario usage modifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateBillScenarioUsageModificationEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchCreateBillScenarioUsageModificationEntry.Builder, BatchCreateBillScenarioUsageModificationEntry> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceCode").getter(getter(BatchCreateBillScenarioUsageModificationEntry::serviceCode))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageType").getter(getter(BatchCreateBillScenarioUsageModificationEntry::usageType))
            .setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operation").getter(getter(BatchCreateBillScenarioUsageModificationEntry::operation))
            .setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(BatchCreateBillScenarioUsageModificationEntry::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(BatchCreateBillScenarioUsageModificationEntry::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("group")
            .getter(getter(BatchCreateBillScenarioUsageModificationEntry::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final SdkField<String> USAGE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageAccountId").getter(getter(BatchCreateBillScenarioUsageModificationEntry::usageAccountId))
            .setter(setter(Builder::usageAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageAccountId").build()).build();

    private static final SdkField<List<UsageAmount>> AMOUNTS_FIELD = SdkField
            .<List<UsageAmount>> builder(MarshallingType.LIST)
            .memberName("amounts")
            .getter(getter(BatchCreateBillScenarioUsageModificationEntry::amounts))
            .setter(setter(Builder::amounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageAmount> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageAmount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<HistoricalUsageEntity> HISTORICAL_USAGE_FIELD = SdkField
            .<HistoricalUsageEntity> builder(MarshallingType.SDK_POJO).memberName("historicalUsage")
            .getter(getter(BatchCreateBillScenarioUsageModificationEntry::historicalUsage))
            .setter(setter(Builder::historicalUsage)).constructor(HistoricalUsageEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("historicalUsage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            USAGE_TYPE_FIELD, OPERATION_FIELD, AVAILABILITY_ZONE_FIELD, KEY_FIELD, GROUP_FIELD, USAGE_ACCOUNT_ID_FIELD,
            AMOUNTS_FIELD, HISTORICAL_USAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceCode;

    private final String usageType;

    private final String operation;

    private final String availabilityZone;

    private final String key;

    private final String group;

    private final String usageAccountId;

    private final List<UsageAmount> amounts;

    private final HistoricalUsageEntity historicalUsage;

    private BatchCreateBillScenarioUsageModificationEntry(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
        this.availabilityZone = builder.availabilityZone;
        this.key = builder.key;
        this.group = builder.group;
        this.usageAccountId = builder.usageAccountId;
        this.amounts = builder.amounts;
        this.historicalUsage = builder.historicalUsage;
    }

    /**
     * <p>
     * The Amazon Web Services service code for this usage modification. This identifies the specific Amazon Web
     * Services service to the customer as a unique short abbreviation. For example, <code>AmazonEC2</code> and
     * <code>AWSKMS</code>.
     * </p>
     * 
     * @return The Amazon Web Services service code for this usage modification. This identifies the specific Amazon Web
     *         Services service to the customer as a unique short abbreviation. For example, <code>AmazonEC2</code> and
     *         <code>AWSKMS</code>.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * Describes the usage details of the usage line item.
     * </p>
     * 
     * @return Describes the usage details of the usage line item.
     */
    public final String usageType() {
        return usageType;
    }

    /**
     * <p>
     * The specific operation associated with this usage modification. Describes the specific Amazon Web Services
     * operation that this usage line models. For example, <code>RunInstances</code> indicates the operation of an
     * Amazon EC2 instance.
     * </p>
     * 
     * @return The specific operation associated with this usage modification. Describes the specific Amazon Web
     *         Services operation that this usage line models. For example, <code>RunInstances</code> indicates the
     *         operation of an Amazon EC2 instance.
     */
    public final String operation() {
        return operation;
    }

    /**
     * <p>
     * The Availability Zone that this usage line uses.
     * </p>
     * 
     * @return The Availability Zone that this usage line uses.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * A unique identifier for this entry in the batch operation. This can be any valid string. This key is useful to
     * identify errors associated with any usage entry as any error is returned with this key.
     * </p>
     * 
     * @return A unique identifier for this entry in the batch operation. This can be any valid string. This key is
     *         useful to identify errors associated with any usage entry as any error is returned with this key.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * An optional group identifier for the usage modification.
     * </p>
     * 
     * @return An optional group identifier for the usage modification.
     */
    public final String group() {
        return group;
    }

    /**
     * <p>
     * The Amazon Web Services account ID to which this usage will be applied to.
     * </p>
     * 
     * @return The Amazon Web Services account ID to which this usage will be applied to.
     */
    public final String usageAccountId() {
        return usageAccountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Amounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAmounts() {
        return amounts != null && !(amounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The amount of usage you want to create for the service use you are modeling.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAmounts} method.
     * </p>
     * 
     * @return The amount of usage you want to create for the service use you are modeling.
     */
    public final List<UsageAmount> amounts() {
        return amounts;
    }

    /**
     * <p>
     * Historical usage data associated with this modification, if available.
     * </p>
     * 
     * @return Historical usage data associated with this modification, if available.
     */
    public final HistoricalUsageEntity historicalUsage() {
        return historicalUsage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(usageType());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(usageAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAmounts() ? amounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(historicalUsage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateBillScenarioUsageModificationEntry)) {
            return false;
        }
        BatchCreateBillScenarioUsageModificationEntry other = (BatchCreateBillScenarioUsageModificationEntry) obj;
        return Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(usageType(), other.usageType())
                && Objects.equals(operation(), other.operation()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(key(), other.key()) && Objects.equals(group(), other.group())
                && Objects.equals(usageAccountId(), other.usageAccountId()) && hasAmounts() == other.hasAmounts()
                && Objects.equals(amounts(), other.amounts()) && Objects.equals(historicalUsage(), other.historicalUsage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateBillScenarioUsageModificationEntry").add("ServiceCode", serviceCode())
                .add("UsageType", usageType()).add("Operation", operation()).add("AvailabilityZone", availabilityZone())
                .add("Key", key()).add("Group", group()).add("UsageAccountId", usageAccountId())
                .add("Amounts", hasAmounts() ? amounts() : null).add("HistoricalUsage", historicalUsage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "usageType":
            return Optional.ofNullable(clazz.cast(usageType()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        case "usageAccountId":
            return Optional.ofNullable(clazz.cast(usageAccountId()));
        case "amounts":
            return Optional.ofNullable(clazz.cast(amounts()));
        case "historicalUsage":
            return Optional.ofNullable(clazz.cast(historicalUsage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceCode", SERVICE_CODE_FIELD);
        map.put("usageType", USAGE_TYPE_FIELD);
        map.put("operation", OPERATION_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("key", KEY_FIELD);
        map.put("group", GROUP_FIELD);
        map.put("usageAccountId", USAGE_ACCOUNT_ID_FIELD);
        map.put("amounts", AMOUNTS_FIELD);
        map.put("historicalUsage", HISTORICAL_USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateBillScenarioUsageModificationEntry, T> g) {
        return obj -> g.apply((BatchCreateBillScenarioUsageModificationEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchCreateBillScenarioUsageModificationEntry> {
        /**
         * <p>
         * The Amazon Web Services service code for this usage modification. This identifies the specific Amazon Web
         * Services service to the customer as a unique short abbreviation. For example, <code>AmazonEC2</code> and
         * <code>AWSKMS</code>.
         * </p>
         * 
         * @param serviceCode
         *        The Amazon Web Services service code for this usage modification. This identifies the specific Amazon
         *        Web Services service to the customer as a unique short abbreviation. For example,
         *        <code>AmazonEC2</code> and <code>AWSKMS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * Describes the usage details of the usage line item.
         * </p>
         * 
         * @param usageType
         *        Describes the usage details of the usage line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageType(String usageType);

        /**
         * <p>
         * The specific operation associated with this usage modification. Describes the specific Amazon Web Services
         * operation that this usage line models. For example, <code>RunInstances</code> indicates the operation of an
         * Amazon EC2 instance.
         * </p>
         * 
         * @param operation
         *        The specific operation associated with this usage modification. Describes the specific Amazon Web
         *        Services operation that this usage line models. For example, <code>RunInstances</code> indicates the
         *        operation of an Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * The Availability Zone that this usage line uses.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone that this usage line uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * A unique identifier for this entry in the batch operation. This can be any valid string. This key is useful
         * to identify errors associated with any usage entry as any error is returned with this key.
         * </p>
         * 
         * @param key
         *        A unique identifier for this entry in the batch operation. This can be any valid string. This key is
         *        useful to identify errors associated with any usage entry as any error is returned with this key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * An optional group identifier for the usage modification.
         * </p>
         * 
         * @param group
         *        An optional group identifier for the usage modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The Amazon Web Services account ID to which this usage will be applied to.
         * </p>
         * 
         * @param usageAccountId
         *        The Amazon Web Services account ID to which this usage will be applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageAccountId(String usageAccountId);

        /**
         * <p>
         * The amount of usage you want to create for the service use you are modeling.
         * </p>
         * 
         * @param amounts
         *        The amount of usage you want to create for the service use you are modeling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amounts(Collection<UsageAmount> amounts);

        /**
         * <p>
         * The amount of usage you want to create for the service use you are modeling.
         * </p>
         * 
         * @param amounts
         *        The amount of usage you want to create for the service use you are modeling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amounts(UsageAmount... amounts);

        /**
         * <p>
         * The amount of usage you want to create for the service use you are modeling.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UsageAmount.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UsageAmount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UsageAmount.Builder#build()} is called
         * immediately and its result is passed to {@link #amounts(List<UsageAmount>)}.
         * 
         * @param amounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UsageAmount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amounts(java.util.Collection<UsageAmount>)
         */
        Builder amounts(Consumer<UsageAmount.Builder>... amounts);

        /**
         * <p>
         * Historical usage data associated with this modification, if available.
         * </p>
         * 
         * @param historicalUsage
         *        Historical usage data associated with this modification, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalUsage(HistoricalUsageEntity historicalUsage);

        /**
         * <p>
         * Historical usage data associated with this modification, if available.
         * </p>
         * This is a convenience method that creates an instance of the {@link HistoricalUsageEntity.Builder} avoiding
         * the need to create one manually via {@link HistoricalUsageEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HistoricalUsageEntity.Builder#build()} is called immediately and
         * its result is passed to {@link #historicalUsage(HistoricalUsageEntity)}.
         * 
         * @param historicalUsage
         *        a consumer that will call methods on {@link HistoricalUsageEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #historicalUsage(HistoricalUsageEntity)
         */
        default Builder historicalUsage(Consumer<HistoricalUsageEntity.Builder> historicalUsage) {
            return historicalUsage(HistoricalUsageEntity.builder().applyMutation(historicalUsage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String serviceCode;

        private String usageType;

        private String operation;

        private String availabilityZone;

        private String key;

        private String group;

        private String usageAccountId;

        private List<UsageAmount> amounts = DefaultSdkAutoConstructList.getInstance();

        private HistoricalUsageEntity historicalUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateBillScenarioUsageModificationEntry model) {
            serviceCode(model.serviceCode);
            usageType(model.usageType);
            operation(model.operation);
            availabilityZone(model.availabilityZone);
            key(model.key);
            group(model.group);
            usageAccountId(model.usageAccountId);
            amounts(model.amounts);
            historicalUsage(model.historicalUsage);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final String getUsageAccountId() {
            return usageAccountId;
        }

        public final void setUsageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
        }

        @Override
        public final Builder usageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
            return this;
        }

        public final List<UsageAmount.Builder> getAmounts() {
            List<UsageAmount.Builder> result = UsageAmountsCopier.copyToBuilder(this.amounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmounts(Collection<UsageAmount.BuilderImpl> amounts) {
            this.amounts = UsageAmountsCopier.copyFromBuilder(amounts);
        }

        @Override
        public final Builder amounts(Collection<UsageAmount> amounts) {
            this.amounts = UsageAmountsCopier.copy(amounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(UsageAmount... amounts) {
            amounts(Arrays.asList(amounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(Consumer<UsageAmount.Builder>... amounts) {
            amounts(Stream.of(amounts).map(c -> UsageAmount.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final HistoricalUsageEntity.Builder getHistoricalUsage() {
            return historicalUsage != null ? historicalUsage.toBuilder() : null;
        }

        public final void setHistoricalUsage(HistoricalUsageEntity.BuilderImpl historicalUsage) {
            this.historicalUsage = historicalUsage != null ? historicalUsage.build() : null;
        }

        @Override
        public final Builder historicalUsage(HistoricalUsageEntity historicalUsage) {
            this.historicalUsage = historicalUsage;
            return this;
        }

        @Override
        public BatchCreateBillScenarioUsageModificationEntry build() {
            return new BatchCreateBillScenarioUsageModificationEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
