/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateBillScenarioCommitmentModificationRequest extends BcmPricingCalculatorRequest
        implements
        ToCopyableBuilder<BatchUpdateBillScenarioCommitmentModificationRequest.Builder, BatchUpdateBillScenarioCommitmentModificationRequest> {
    private static final SdkField<String> BILL_SCENARIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billScenarioId").getter(getter(BatchUpdateBillScenarioCommitmentModificationRequest::billScenarioId))
            .setter(setter(Builder::billScenarioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billScenarioId").build()).build();

    private static final SdkField<List<BatchUpdateBillScenarioCommitmentModificationEntry>> COMMITMENT_MODIFICATIONS_FIELD = SdkField
            .<List<BatchUpdateBillScenarioCommitmentModificationEntry>> builder(MarshallingType.LIST)
            .memberName("commitmentModifications")
            .getter(getter(BatchUpdateBillScenarioCommitmentModificationRequest::commitmentModifications))
            .setter(setter(Builder::commitmentModifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentModifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateBillScenarioCommitmentModificationEntry> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateBillScenarioCommitmentModificationEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILL_SCENARIO_ID_FIELD,
            COMMITMENT_MODIFICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String billScenarioId;

    private final List<BatchUpdateBillScenarioCommitmentModificationEntry> commitmentModifications;

    private BatchUpdateBillScenarioCommitmentModificationRequest(BuilderImpl builder) {
        super(builder);
        this.billScenarioId = builder.billScenarioId;
        this.commitmentModifications = builder.commitmentModifications;
    }

    /**
     * <p>
     * The ID of the Bill Scenario for which you want to modify the commitment group of a modeled commitment.
     * </p>
     * 
     * @return The ID of the Bill Scenario for which you want to modify the commitment group of a modeled commitment.
     */
    public final String billScenarioId() {
        return billScenarioId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CommitmentModifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCommitmentModifications() {
        return commitmentModifications != null && !(commitmentModifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of commitments that you want to update in a Bill Scenario.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommitmentModifications} method.
     * </p>
     * 
     * @return List of commitments that you want to update in a Bill Scenario.
     */
    public final List<BatchUpdateBillScenarioCommitmentModificationEntry> commitmentModifications() {
        return commitmentModifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(billScenarioId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCommitmentModifications() ? commitmentModifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateBillScenarioCommitmentModificationRequest)) {
            return false;
        }
        BatchUpdateBillScenarioCommitmentModificationRequest other = (BatchUpdateBillScenarioCommitmentModificationRequest) obj;
        return Objects.equals(billScenarioId(), other.billScenarioId())
                && hasCommitmentModifications() == other.hasCommitmentModifications()
                && Objects.equals(commitmentModifications(), other.commitmentModifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateBillScenarioCommitmentModificationRequest").add("BillScenarioId", billScenarioId())
                .add("CommitmentModifications", hasCommitmentModifications() ? commitmentModifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "billScenarioId":
            return Optional.ofNullable(clazz.cast(billScenarioId()));
        case "commitmentModifications":
            return Optional.ofNullable(clazz.cast(commitmentModifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("billScenarioId", BILL_SCENARIO_ID_FIELD);
        map.put("commitmentModifications", COMMITMENT_MODIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateBillScenarioCommitmentModificationRequest, T> g) {
        return obj -> g.apply((BatchUpdateBillScenarioCommitmentModificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BcmPricingCalculatorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateBillScenarioCommitmentModificationRequest> {
        /**
         * <p>
         * The ID of the Bill Scenario for which you want to modify the commitment group of a modeled commitment.
         * </p>
         * 
         * @param billScenarioId
         *        The ID of the Bill Scenario for which you want to modify the commitment group of a modeled commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billScenarioId(String billScenarioId);

        /**
         * <p>
         * List of commitments that you want to update in a Bill Scenario.
         * </p>
         * 
         * @param commitmentModifications
         *        List of commitments that you want to update in a Bill Scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitmentModifications(Collection<BatchUpdateBillScenarioCommitmentModificationEntry> commitmentModifications);

        /**
         * <p>
         * List of commitments that you want to update in a Bill Scenario.
         * </p>
         * 
         * @param commitmentModifications
         *        List of commitments that you want to update in a Bill Scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitmentModifications(BatchUpdateBillScenarioCommitmentModificationEntry... commitmentModifications);

        /**
         * <p>
         * List of commitments that you want to update in a Bill Scenario.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationEntry#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #commitmentModifications(List<BatchUpdateBillScenarioCommitmentModificationEntry>)}.
         * 
         * @param commitmentModifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commitmentModifications(java.util.Collection<BatchUpdateBillScenarioCommitmentModificationEntry>)
         */
        Builder commitmentModifications(
                Consumer<BatchUpdateBillScenarioCommitmentModificationEntry.Builder>... commitmentModifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BcmPricingCalculatorRequest.BuilderImpl implements Builder {
        private String billScenarioId;

        private List<BatchUpdateBillScenarioCommitmentModificationEntry> commitmentModifications = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateBillScenarioCommitmentModificationRequest model) {
            super(model);
            billScenarioId(model.billScenarioId);
            commitmentModifications(model.commitmentModifications);
        }

        public final String getBillScenarioId() {
            return billScenarioId;
        }

        public final void setBillScenarioId(String billScenarioId) {
            this.billScenarioId = billScenarioId;
        }

        @Override
        public final Builder billScenarioId(String billScenarioId) {
            this.billScenarioId = billScenarioId;
            return this;
        }

        public final List<BatchUpdateBillScenarioCommitmentModificationEntry.Builder> getCommitmentModifications() {
            List<BatchUpdateBillScenarioCommitmentModificationEntry.Builder> result = BatchUpdateBillScenarioCommitmentModificationEntriesCopier
                    .copyToBuilder(this.commitmentModifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommitmentModifications(
                Collection<BatchUpdateBillScenarioCommitmentModificationEntry.BuilderImpl> commitmentModifications) {
            this.commitmentModifications = BatchUpdateBillScenarioCommitmentModificationEntriesCopier
                    .copyFromBuilder(commitmentModifications);
        }

        @Override
        public final Builder commitmentModifications(
                Collection<BatchUpdateBillScenarioCommitmentModificationEntry> commitmentModifications) {
            this.commitmentModifications = BatchUpdateBillScenarioCommitmentModificationEntriesCopier
                    .copy(commitmentModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commitmentModifications(
                BatchUpdateBillScenarioCommitmentModificationEntry... commitmentModifications) {
            commitmentModifications(Arrays.asList(commitmentModifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commitmentModifications(
                Consumer<BatchUpdateBillScenarioCommitmentModificationEntry.Builder>... commitmentModifications) {
            commitmentModifications(Stream.of(commitmentModifications)
                    .map(c -> BatchUpdateBillScenarioCommitmentModificationEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateBillScenarioCommitmentModificationRequest build() {
            return new BatchUpdateBillScenarioCommitmentModificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
