/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of a bill scenario.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillScenarioSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BillScenarioSummary.Builder, BillScenarioSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(BillScenarioSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(BillScenarioSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<BillInterval> BILL_INTERVAL_FIELD = SdkField.<BillInterval> builder(MarshallingType.SDK_POJO)
            .memberName("billInterval").getter(getter(BillScenarioSummary::billInterval)).setter(setter(Builder::billInterval))
            .constructor(BillInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billInterval").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BillScenarioSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(BillScenarioSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiresAt").getter(getter(BillScenarioSummary::expiresAt)).setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(BillScenarioSummary::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            BILL_INTERVAL_FIELD, STATUS_FIELD, CREATED_AT_FIELD, EXPIRES_AT_FIELD, FAILURE_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final BillInterval billInterval;

    private final String status;

    private final Instant createdAt;

    private final Instant expiresAt;

    private final String failureMessage;

    private BillScenarioSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.billInterval = builder.billInterval;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.expiresAt = builder.expiresAt;
        this.failureMessage = builder.failureMessage;
    }

    /**
     * <p>
     * The unique identifier of the bill scenario.
     * </p>
     * 
     * @return The unique identifier of the bill scenario.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the bill scenario.
     * </p>
     * 
     * @return The name of the bill scenario.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time period covered by the bill scenario.
     * </p>
     * 
     * @return The time period covered by the bill scenario.
     */
    public final BillInterval billInterval() {
        return billInterval;
    }

    /**
     * <p>
     * The current status of the bill scenario.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BillScenarioStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the bill scenario.
     * @see BillScenarioStatus
     */
    public final BillScenarioStatus status() {
        return BillScenarioStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the bill scenario.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BillScenarioStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the bill scenario.
     * @see BillScenarioStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the bill scenario was created.
     * </p>
     * 
     * @return The timestamp when the bill scenario was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the bill scenario will expire.
     * </p>
     * 
     * @return The timestamp when the bill scenario will expire.
     */
    public final Instant expiresAt() {
        return expiresAt;
    }

    /**
     * <p>
     * An error message if the bill scenario creation or processing failed.
     * </p>
     * 
     * @return An error message if the bill scenario creation or processing failed.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(billInterval());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillScenarioSummary)) {
            return false;
        }
        BillScenarioSummary other = (BillScenarioSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(billInterval(), other.billInterval())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(expiresAt(), other.expiresAt()) && Objects.equals(failureMessage(), other.failureMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillScenarioSummary").add("Id", id()).add("Name", name()).add("BillInterval", billInterval())
                .add("Status", statusAsString()).add("CreatedAt", createdAt()).add("ExpiresAt", expiresAt())
                .add("FailureMessage", failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "billInterval":
            return Optional.ofNullable(clazz.cast(billInterval()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "expiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("billInterval", BILL_INTERVAL_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillScenarioSummary, T> g) {
        return obj -> g.apply((BillScenarioSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillScenarioSummary> {
        /**
         * <p>
         * The unique identifier of the bill scenario.
         * </p>
         * 
         * @param id
         *        The unique identifier of the bill scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the bill scenario.
         * </p>
         * 
         * @param name
         *        The name of the bill scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time period covered by the bill scenario.
         * </p>
         * 
         * @param billInterval
         *        The time period covered by the bill scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billInterval(BillInterval billInterval);

        /**
         * <p>
         * The time period covered by the bill scenario.
         * </p>
         * This is a convenience method that creates an instance of the {@link BillInterval.Builder} avoiding the need
         * to create one manually via {@link BillInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BillInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #billInterval(BillInterval)}.
         * 
         * @param billInterval
         *        a consumer that will call methods on {@link BillInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billInterval(BillInterval)
         */
        default Builder billInterval(Consumer<BillInterval.Builder> billInterval) {
            return billInterval(BillInterval.builder().applyMutation(billInterval).build());
        }

        /**
         * <p>
         * The current status of the bill scenario.
         * </p>
         * 
         * @param status
         *        The current status of the bill scenario.
         * @see BillScenarioStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillScenarioStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the bill scenario.
         * </p>
         * 
         * @param status
         *        The current status of the bill scenario.
         * @see BillScenarioStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillScenarioStatus
         */
        Builder status(BillScenarioStatus status);

        /**
         * <p>
         * The timestamp when the bill scenario was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the bill scenario was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the bill scenario will expire.
         * </p>
         * 
         * @param expiresAt
         *        The timestamp when the bill scenario will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);

        /**
         * <p>
         * An error message if the bill scenario creation or processing failed.
         * </p>
         * 
         * @param failureMessage
         *        An error message if the bill scenario creation or processing failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private BillInterval billInterval;

        private String status;

        private Instant createdAt;

        private Instant expiresAt;

        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BillScenarioSummary model) {
            id(model.id);
            name(model.name);
            billInterval(model.billInterval);
            status(model.status);
            createdAt(model.createdAt);
            expiresAt(model.expiresAt);
            failureMessage(model.failureMessage);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final BillInterval.Builder getBillInterval() {
            return billInterval != null ? billInterval.toBuilder() : null;
        }

        public final void setBillInterval(BillInterval.BuilderImpl billInterval) {
            this.billInterval = billInterval != null ? billInterval.build() : null;
        }

        @Override
        public final Builder billInterval(BillInterval billInterval) {
            this.billInterval = billInterval;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BillScenarioStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        @Override
        public BillScenarioSummary build() {
            return new BillScenarioSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
