/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of a line item in a bill estimate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillEstimateLineItemSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BillEstimateLineItemSummary.Builder, BillEstimateLineItemSummary> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceCode").getter(getter(BillEstimateLineItemSummary::serviceCode))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageType").getter(getter(BillEstimateLineItemSummary::usageType)).setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operation").getter(getter(BillEstimateLineItemSummary::operation)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(BillEstimateLineItemSummary::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(BillEstimateLineItemSummary::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(BillEstimateLineItemSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> LINE_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lineItemId").getter(getter(BillEstimateLineItemSummary::lineItemId)).setter(setter(Builder::lineItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineItemId").build()).build();

    private static final SdkField<String> LINE_ITEM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lineItemType").getter(getter(BillEstimateLineItemSummary::lineItemType))
            .setter(setter(Builder::lineItemType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineItemType").build()).build();

    private static final SdkField<String> PAYER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("payerAccountId").getter(getter(BillEstimateLineItemSummary::payerAccountId))
            .setter(setter(Builder::payerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payerAccountId").build()).build();

    private static final SdkField<String> USAGE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageAccountId").getter(getter(BillEstimateLineItemSummary::usageAccountId))
            .setter(setter(Builder::usageAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageAccountId").build()).build();

    private static final SdkField<UsageQuantityResult> ESTIMATED_USAGE_QUANTITY_FIELD = SdkField
            .<UsageQuantityResult> builder(MarshallingType.SDK_POJO).memberName("estimatedUsageQuantity")
            .getter(getter(BillEstimateLineItemSummary::estimatedUsageQuantity)).setter(setter(Builder::estimatedUsageQuantity))
            .constructor(UsageQuantityResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedUsageQuantity").build())
            .build();

    private static final SdkField<CostAmount> ESTIMATED_COST_FIELD = SdkField.<CostAmount> builder(MarshallingType.SDK_POJO)
            .memberName("estimatedCost").getter(getter(BillEstimateLineItemSummary::estimatedCost))
            .setter(setter(Builder::estimatedCost)).constructor(CostAmount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedCost").build()).build();

    private static final SdkField<UsageQuantityResult> HISTORICAL_USAGE_QUANTITY_FIELD = SdkField
            .<UsageQuantityResult> builder(MarshallingType.SDK_POJO).memberName("historicalUsageQuantity")
            .getter(getter(BillEstimateLineItemSummary::historicalUsageQuantity))
            .setter(setter(Builder::historicalUsageQuantity)).constructor(UsageQuantityResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("historicalUsageQuantity").build())
            .build();

    private static final SdkField<CostAmount> HISTORICAL_COST_FIELD = SdkField.<CostAmount> builder(MarshallingType.SDK_POJO)
            .memberName("historicalCost").getter(getter(BillEstimateLineItemSummary::historicalCost))
            .setter(setter(Builder::historicalCost)).constructor(CostAmount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("historicalCost").build()).build();

    private static final SdkField<List<String>> SAVINGS_PLAN_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("savingsPlanArns")
            .getter(getter(BillEstimateLineItemSummary::savingsPlanArns))
            .setter(setter(Builder::savingsPlanArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            USAGE_TYPE_FIELD, OPERATION_FIELD, LOCATION_FIELD, AVAILABILITY_ZONE_FIELD, ID_FIELD, LINE_ITEM_ID_FIELD,
            LINE_ITEM_TYPE_FIELD, PAYER_ACCOUNT_ID_FIELD, USAGE_ACCOUNT_ID_FIELD, ESTIMATED_USAGE_QUANTITY_FIELD,
            ESTIMATED_COST_FIELD, HISTORICAL_USAGE_QUANTITY_FIELD, HISTORICAL_COST_FIELD, SAVINGS_PLAN_ARNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceCode;

    private final String usageType;

    private final String operation;

    private final String location;

    private final String availabilityZone;

    private final String id;

    private final String lineItemId;

    private final String lineItemType;

    private final String payerAccountId;

    private final String usageAccountId;

    private final UsageQuantityResult estimatedUsageQuantity;

    private final CostAmount estimatedCost;

    private final UsageQuantityResult historicalUsageQuantity;

    private final CostAmount historicalCost;

    private final List<String> savingsPlanArns;

    private BillEstimateLineItemSummary(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
        this.location = builder.location;
        this.availabilityZone = builder.availabilityZone;
        this.id = builder.id;
        this.lineItemId = builder.lineItemId;
        this.lineItemType = builder.lineItemType;
        this.payerAccountId = builder.payerAccountId;
        this.usageAccountId = builder.usageAccountId;
        this.estimatedUsageQuantity = builder.estimatedUsageQuantity;
        this.estimatedCost = builder.estimatedCost;
        this.historicalUsageQuantity = builder.historicalUsageQuantity;
        this.historicalCost = builder.historicalCost;
        this.savingsPlanArns = builder.savingsPlanArns;
    }

    /**
     * <p>
     * The Amazon Web Services service code associated with this line item.
     * </p>
     * 
     * @return The Amazon Web Services service code associated with this line item.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The type of usage for this line item.
     * </p>
     * 
     * @return The type of usage for this line item.
     */
    public final String usageType() {
        return usageType;
    }

    /**
     * <p>
     * The specific operation associated with this line item.
     * </p>
     * 
     * @return The specific operation associated with this line item.
     */
    public final String operation() {
        return operation;
    }

    /**
     * <p>
     * The location associated with this line item.
     * </p>
     * 
     * @return The location associated with this line item.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The availability zone associated with this line item, if applicable.
     * </p>
     * 
     * @return The availability zone associated with this line item, if applicable.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The unique identifier of this line item.
     * </p>
     * 
     * @return The unique identifier of this line item.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The line item identifier from the original bill.
     * </p>
     * 
     * @return The line item identifier from the original bill.
     */
    public final String lineItemId() {
        return lineItemId;
    }

    /**
     * <p>
     * The type of this line item (e.g., Usage, Tax, Credit).
     * </p>
     * 
     * @return The type of this line item (e.g., Usage, Tax, Credit).
     */
    public final String lineItemType() {
        return lineItemType;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the payer for this line item.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the payer for this line item.
     */
    public final String payerAccountId() {
        return payerAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the usage for this line item.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the usage for this line item.
     */
    public final String usageAccountId() {
        return usageAccountId;
    }

    /**
     * <p>
     * The estimated usage quantity for this line item.
     * </p>
     * 
     * @return The estimated usage quantity for this line item.
     */
    public final UsageQuantityResult estimatedUsageQuantity() {
        return estimatedUsageQuantity;
    }

    /**
     * <p>
     * The estimated cost for this line item.
     * </p>
     * 
     * @return The estimated cost for this line item.
     */
    public final CostAmount estimatedCost() {
        return estimatedCost;
    }

    /**
     * <p>
     * The historical usage quantity for this line item.
     * </p>
     * 
     * @return The historical usage quantity for this line item.
     */
    public final UsageQuantityResult historicalUsageQuantity() {
        return historicalUsageQuantity;
    }

    /**
     * <p>
     * The historical cost for this line item.
     * </p>
     * 
     * @return The historical cost for this line item.
     */
    public final CostAmount historicalCost() {
        return historicalCost;
    }

    /**
     * For responses, this returns true if the service returned a value for the SavingsPlanArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSavingsPlanArns() {
        return savingsPlanArns != null && !(savingsPlanArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of any Savings Plans applied to this line item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSavingsPlanArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of any Savings Plans applied to this line item.
     */
    public final List<String> savingsPlanArns() {
        return savingsPlanArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(usageType());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lineItemId());
        hashCode = 31 * hashCode + Objects.hashCode(lineItemType());
        hashCode = 31 * hashCode + Objects.hashCode(payerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(usageAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedUsageQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedCost());
        hashCode = 31 * hashCode + Objects.hashCode(historicalUsageQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(historicalCost());
        hashCode = 31 * hashCode + Objects.hashCode(hasSavingsPlanArns() ? savingsPlanArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillEstimateLineItemSummary)) {
            return false;
        }
        BillEstimateLineItemSummary other = (BillEstimateLineItemSummary) obj;
        return Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(usageType(), other.usageType())
                && Objects.equals(operation(), other.operation()) && Objects.equals(location(), other.location())
                && Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(id(), other.id())
                && Objects.equals(lineItemId(), other.lineItemId()) && Objects.equals(lineItemType(), other.lineItemType())
                && Objects.equals(payerAccountId(), other.payerAccountId())
                && Objects.equals(usageAccountId(), other.usageAccountId())
                && Objects.equals(estimatedUsageQuantity(), other.estimatedUsageQuantity())
                && Objects.equals(estimatedCost(), other.estimatedCost())
                && Objects.equals(historicalUsageQuantity(), other.historicalUsageQuantity())
                && Objects.equals(historicalCost(), other.historicalCost()) && hasSavingsPlanArns() == other.hasSavingsPlanArns()
                && Objects.equals(savingsPlanArns(), other.savingsPlanArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillEstimateLineItemSummary").add("ServiceCode", serviceCode()).add("UsageType", usageType())
                .add("Operation", operation()).add("Location", location()).add("AvailabilityZone", availabilityZone())
                .add("Id", id()).add("LineItemId", lineItemId()).add("LineItemType", lineItemType())
                .add("PayerAccountId", payerAccountId()).add("UsageAccountId", usageAccountId())
                .add("EstimatedUsageQuantity", estimatedUsageQuantity()).add("EstimatedCost", estimatedCost())
                .add("HistoricalUsageQuantity", historicalUsageQuantity()).add("HistoricalCost", historicalCost())
                .add("SavingsPlanArns", hasSavingsPlanArns() ? savingsPlanArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "usageType":
            return Optional.ofNullable(clazz.cast(usageType()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lineItemId":
            return Optional.ofNullable(clazz.cast(lineItemId()));
        case "lineItemType":
            return Optional.ofNullable(clazz.cast(lineItemType()));
        case "payerAccountId":
            return Optional.ofNullable(clazz.cast(payerAccountId()));
        case "usageAccountId":
            return Optional.ofNullable(clazz.cast(usageAccountId()));
        case "estimatedUsageQuantity":
            return Optional.ofNullable(clazz.cast(estimatedUsageQuantity()));
        case "estimatedCost":
            return Optional.ofNullable(clazz.cast(estimatedCost()));
        case "historicalUsageQuantity":
            return Optional.ofNullable(clazz.cast(historicalUsageQuantity()));
        case "historicalCost":
            return Optional.ofNullable(clazz.cast(historicalCost()));
        case "savingsPlanArns":
            return Optional.ofNullable(clazz.cast(savingsPlanArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceCode", SERVICE_CODE_FIELD);
        map.put("usageType", USAGE_TYPE_FIELD);
        map.put("operation", OPERATION_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("id", ID_FIELD);
        map.put("lineItemId", LINE_ITEM_ID_FIELD);
        map.put("lineItemType", LINE_ITEM_TYPE_FIELD);
        map.put("payerAccountId", PAYER_ACCOUNT_ID_FIELD);
        map.put("usageAccountId", USAGE_ACCOUNT_ID_FIELD);
        map.put("estimatedUsageQuantity", ESTIMATED_USAGE_QUANTITY_FIELD);
        map.put("estimatedCost", ESTIMATED_COST_FIELD);
        map.put("historicalUsageQuantity", HISTORICAL_USAGE_QUANTITY_FIELD);
        map.put("historicalCost", HISTORICAL_COST_FIELD);
        map.put("savingsPlanArns", SAVINGS_PLAN_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillEstimateLineItemSummary, T> g) {
        return obj -> g.apply((BillEstimateLineItemSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillEstimateLineItemSummary> {
        /**
         * <p>
         * The Amazon Web Services service code associated with this line item.
         * </p>
         * 
         * @param serviceCode
         *        The Amazon Web Services service code associated with this line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The type of usage for this line item.
         * </p>
         * 
         * @param usageType
         *        The type of usage for this line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageType(String usageType);

        /**
         * <p>
         * The specific operation associated with this line item.
         * </p>
         * 
         * @param operation
         *        The specific operation associated with this line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * The location associated with this line item.
         * </p>
         * 
         * @param location
         *        The location associated with this line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The availability zone associated with this line item, if applicable.
         * </p>
         * 
         * @param availabilityZone
         *        The availability zone associated with this line item, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The unique identifier of this line item.
         * </p>
         * 
         * @param id
         *        The unique identifier of this line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The line item identifier from the original bill.
         * </p>
         * 
         * @param lineItemId
         *        The line item identifier from the original bill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItemId(String lineItemId);

        /**
         * <p>
         * The type of this line item (e.g., Usage, Tax, Credit).
         * </p>
         * 
         * @param lineItemType
         *        The type of this line item (e.g., Usage, Tax, Credit).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItemType(String lineItemType);

        /**
         * <p>
         * The Amazon Web Services account ID of the payer for this line item.
         * </p>
         * 
         * @param payerAccountId
         *        The Amazon Web Services account ID of the payer for this line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payerAccountId(String payerAccountId);

        /**
         * <p>
         * The Amazon Web Services account ID associated with the usage for this line item.
         * </p>
         * 
         * @param usageAccountId
         *        The Amazon Web Services account ID associated with the usage for this line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageAccountId(String usageAccountId);

        /**
         * <p>
         * The estimated usage quantity for this line item.
         * </p>
         * 
         * @param estimatedUsageQuantity
         *        The estimated usage quantity for this line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedUsageQuantity(UsageQuantityResult estimatedUsageQuantity);

        /**
         * <p>
         * The estimated usage quantity for this line item.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsageQuantityResult.Builder} avoiding the
         * need to create one manually via {@link UsageQuantityResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsageQuantityResult.Builder#build()} is called immediately and
         * its result is passed to {@link #estimatedUsageQuantity(UsageQuantityResult)}.
         * 
         * @param estimatedUsageQuantity
         *        a consumer that will call methods on {@link UsageQuantityResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #estimatedUsageQuantity(UsageQuantityResult)
         */
        default Builder estimatedUsageQuantity(Consumer<UsageQuantityResult.Builder> estimatedUsageQuantity) {
            return estimatedUsageQuantity(UsageQuantityResult.builder().applyMutation(estimatedUsageQuantity).build());
        }

        /**
         * <p>
         * The estimated cost for this line item.
         * </p>
         * 
         * @param estimatedCost
         *        The estimated cost for this line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedCost(CostAmount estimatedCost);

        /**
         * <p>
         * The estimated cost for this line item.
         * </p>
         * This is a convenience method that creates an instance of the {@link CostAmount.Builder} avoiding the need to
         * create one manually via {@link CostAmount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CostAmount.Builder#build()} is called immediately and its result
         * is passed to {@link #estimatedCost(CostAmount)}.
         * 
         * @param estimatedCost
         *        a consumer that will call methods on {@link CostAmount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #estimatedCost(CostAmount)
         */
        default Builder estimatedCost(Consumer<CostAmount.Builder> estimatedCost) {
            return estimatedCost(CostAmount.builder().applyMutation(estimatedCost).build());
        }

        /**
         * <p>
         * The historical usage quantity for this line item.
         * </p>
         * 
         * @param historicalUsageQuantity
         *        The historical usage quantity for this line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalUsageQuantity(UsageQuantityResult historicalUsageQuantity);

        /**
         * <p>
         * The historical usage quantity for this line item.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsageQuantityResult.Builder} avoiding the
         * need to create one manually via {@link UsageQuantityResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsageQuantityResult.Builder#build()} is called immediately and
         * its result is passed to {@link #historicalUsageQuantity(UsageQuantityResult)}.
         * 
         * @param historicalUsageQuantity
         *        a consumer that will call methods on {@link UsageQuantityResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #historicalUsageQuantity(UsageQuantityResult)
         */
        default Builder historicalUsageQuantity(Consumer<UsageQuantityResult.Builder> historicalUsageQuantity) {
            return historicalUsageQuantity(UsageQuantityResult.builder().applyMutation(historicalUsageQuantity).build());
        }

        /**
         * <p>
         * The historical cost for this line item.
         * </p>
         * 
         * @param historicalCost
         *        The historical cost for this line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalCost(CostAmount historicalCost);

        /**
         * <p>
         * The historical cost for this line item.
         * </p>
         * This is a convenience method that creates an instance of the {@link CostAmount.Builder} avoiding the need to
         * create one manually via {@link CostAmount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CostAmount.Builder#build()} is called immediately and its result
         * is passed to {@link #historicalCost(CostAmount)}.
         * 
         * @param historicalCost
         *        a consumer that will call methods on {@link CostAmount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #historicalCost(CostAmount)
         */
        default Builder historicalCost(Consumer<CostAmount.Builder> historicalCost) {
            return historicalCost(CostAmount.builder().applyMutation(historicalCost).build());
        }

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of any Savings Plans applied to this line item.
         * </p>
         * 
         * @param savingsPlanArns
         *        The Amazon Resource Names (ARNs) of any Savings Plans applied to this line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanArns(Collection<String> savingsPlanArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of any Savings Plans applied to this line item.
         * </p>
         * 
         * @param savingsPlanArns
         *        The Amazon Resource Names (ARNs) of any Savings Plans applied to this line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanArns(String... savingsPlanArns);
    }

    static final class BuilderImpl implements Builder {
        private String serviceCode;

        private String usageType;

        private String operation;

        private String location;

        private String availabilityZone;

        private String id;

        private String lineItemId;

        private String lineItemType;

        private String payerAccountId;

        private String usageAccountId;

        private UsageQuantityResult estimatedUsageQuantity;

        private CostAmount estimatedCost;

        private UsageQuantityResult historicalUsageQuantity;

        private CostAmount historicalCost;

        private List<String> savingsPlanArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BillEstimateLineItemSummary model) {
            serviceCode(model.serviceCode);
            usageType(model.usageType);
            operation(model.operation);
            location(model.location);
            availabilityZone(model.availabilityZone);
            id(model.id);
            lineItemId(model.lineItemId);
            lineItemType(model.lineItemType);
            payerAccountId(model.payerAccountId);
            usageAccountId(model.usageAccountId);
            estimatedUsageQuantity(model.estimatedUsageQuantity);
            estimatedCost(model.estimatedCost);
            historicalUsageQuantity(model.historicalUsageQuantity);
            historicalCost(model.historicalCost);
            savingsPlanArns(model.savingsPlanArns);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLineItemId() {
            return lineItemId;
        }

        public final void setLineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
        }

        @Override
        public final Builder lineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
            return this;
        }

        public final String getLineItemType() {
            return lineItemType;
        }

        public final void setLineItemType(String lineItemType) {
            this.lineItemType = lineItemType;
        }

        @Override
        public final Builder lineItemType(String lineItemType) {
            this.lineItemType = lineItemType;
            return this;
        }

        public final String getPayerAccountId() {
            return payerAccountId;
        }

        public final void setPayerAccountId(String payerAccountId) {
            this.payerAccountId = payerAccountId;
        }

        @Override
        public final Builder payerAccountId(String payerAccountId) {
            this.payerAccountId = payerAccountId;
            return this;
        }

        public final String getUsageAccountId() {
            return usageAccountId;
        }

        public final void setUsageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
        }

        @Override
        public final Builder usageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
            return this;
        }

        public final UsageQuantityResult.Builder getEstimatedUsageQuantity() {
            return estimatedUsageQuantity != null ? estimatedUsageQuantity.toBuilder() : null;
        }

        public final void setEstimatedUsageQuantity(UsageQuantityResult.BuilderImpl estimatedUsageQuantity) {
            this.estimatedUsageQuantity = estimatedUsageQuantity != null ? estimatedUsageQuantity.build() : null;
        }

        @Override
        public final Builder estimatedUsageQuantity(UsageQuantityResult estimatedUsageQuantity) {
            this.estimatedUsageQuantity = estimatedUsageQuantity;
            return this;
        }

        public final CostAmount.Builder getEstimatedCost() {
            return estimatedCost != null ? estimatedCost.toBuilder() : null;
        }

        public final void setEstimatedCost(CostAmount.BuilderImpl estimatedCost) {
            this.estimatedCost = estimatedCost != null ? estimatedCost.build() : null;
        }

        @Override
        public final Builder estimatedCost(CostAmount estimatedCost) {
            this.estimatedCost = estimatedCost;
            return this;
        }

        public final UsageQuantityResult.Builder getHistoricalUsageQuantity() {
            return historicalUsageQuantity != null ? historicalUsageQuantity.toBuilder() : null;
        }

        public final void setHistoricalUsageQuantity(UsageQuantityResult.BuilderImpl historicalUsageQuantity) {
            this.historicalUsageQuantity = historicalUsageQuantity != null ? historicalUsageQuantity.build() : null;
        }

        @Override
        public final Builder historicalUsageQuantity(UsageQuantityResult historicalUsageQuantity) {
            this.historicalUsageQuantity = historicalUsageQuantity;
            return this;
        }

        public final CostAmount.Builder getHistoricalCost() {
            return historicalCost != null ? historicalCost.toBuilder() : null;
        }

        public final void setHistoricalCost(CostAmount.BuilderImpl historicalCost) {
            this.historicalCost = historicalCost != null ? historicalCost.build() : null;
        }

        @Override
        public final Builder historicalCost(CostAmount historicalCost) {
            this.historicalCost = historicalCost;
            return this;
        }

        public final Collection<String> getSavingsPlanArns() {
            if (savingsPlanArns instanceof SdkAutoConstructList) {
                return null;
            }
            return savingsPlanArns;
        }

        public final void setSavingsPlanArns(Collection<String> savingsPlanArns) {
            this.savingsPlanArns = SavingsPlanArnsCopier.copy(savingsPlanArns);
        }

        @Override
        public final Builder savingsPlanArns(Collection<String> savingsPlanArns) {
            this.savingsPlanArns = SavingsPlanArnsCopier.copy(savingsPlanArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanArns(String... savingsPlanArns) {
            savingsPlanArns(Arrays.asList(savingsPlanArns));
            return this;
        }

        @Override
        public BillEstimateLineItemSummary build() {
            return new BillEstimateLineItemSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
