/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.BcmPricingCalculatorServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.bcmpricingcalculator.model.AccessDeniedException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioUsageModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioUsageModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioCommitmentModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioCommitmentModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioUsageModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioUsageModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ConflictException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DataUnavailableException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetPreferencesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetPreferencesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.InternalServerException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ResourceNotFoundException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.TagResourceRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.TagResourceResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ThrottlingException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UntagResourceRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UntagResourceResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdatePreferencesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdatePreferencesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ValidationException;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchCreateBillScenarioCommitmentModificationRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchCreateBillScenarioUsageModificationRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchCreateWorkloadEstimateUsageRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchDeleteBillScenarioCommitmentModificationRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchDeleteBillScenarioUsageModificationRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchDeleteWorkloadEstimateUsageRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchUpdateBillScenarioCommitmentModificationRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchUpdateBillScenarioUsageModificationRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchUpdateWorkloadEstimateUsageRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.CreateBillEstimateRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.CreateBillScenarioRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.CreateWorkloadEstimateRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.DeleteBillEstimateRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.DeleteBillScenarioRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.DeleteWorkloadEstimateRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.GetBillEstimateRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.GetBillScenarioRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.GetPreferencesRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.GetWorkloadEstimateRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillEstimateCommitmentsRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillEstimateInputCommitmentModificationsRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillEstimateInputUsageModificationsRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillEstimateLineItemsRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillEstimatesRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillScenarioCommitmentModificationsRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillScenarioUsageModificationsRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillScenariosRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListWorkloadEstimateUsageRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListWorkloadEstimatesRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.UpdateBillEstimateRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.UpdateBillScenarioRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.UpdatePreferencesRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.UpdateWorkloadEstimateRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link BcmPricingCalculatorAsyncClient}.
 *
 * @see BcmPricingCalculatorAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultBcmPricingCalculatorAsyncClient implements BcmPricingCalculatorAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultBcmPricingCalculatorAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultBcmPricingCalculatorAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Create Compute Savings Plans, EC2 Instance Savings Plans, or EC2 Reserved Instances commitments that you want to
     * model in a Bill Scenario.
     * </p>
     * <note>
     * <p>
     * The <code>BatchCreateBillScenarioCommitmentModification</code> operation doesn't have its own IAM permission. To
     * authorize this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:CreateBillScenarioCommitmentModification</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchCreateBillScenarioCommitmentModificationRequest
     * @return A Java Future containing the result of the BatchCreateBillScenarioCommitmentModification operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchCreateBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchCreateBillScenarioCommitmentModificationResponse> batchCreateBillScenarioCommitmentModification(
            BatchCreateBillScenarioCommitmentModificationRequest batchCreateBillScenarioCommitmentModificationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchCreateBillScenarioCommitmentModificationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchCreateBillScenarioCommitmentModificationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateBillScenarioCommitmentModification");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchCreateBillScenarioCommitmentModificationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchCreateBillScenarioCommitmentModificationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchCreateBillScenarioCommitmentModificationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchCreateBillScenarioCommitmentModificationRequest, BatchCreateBillScenarioCommitmentModificationResponse>()
                            .withOperationName("BatchCreateBillScenarioCommitmentModification")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchCreateBillScenarioCommitmentModificationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchCreateBillScenarioCommitmentModificationRequest));
            CompletableFuture<BatchCreateBillScenarioCommitmentModificationResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create Amazon Web Services service usage that you want to model in a Bill Scenario.
     * </p>
     * <note>
     * <p>
     * The <code>BatchCreateBillScenarioUsageModification</code> operation doesn't have its own IAM permission. To
     * authorize this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:CreateBillScenarioUsageModification</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchCreateBillScenarioUsageModificationRequest
     * @return A Java Future containing the result of the BatchCreateBillScenarioUsageModification operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchCreateBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchCreateBillScenarioUsageModificationResponse> batchCreateBillScenarioUsageModification(
            BatchCreateBillScenarioUsageModificationRequest batchCreateBillScenarioUsageModificationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchCreateBillScenarioUsageModificationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchCreateBillScenarioUsageModificationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateBillScenarioUsageModification");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchCreateBillScenarioUsageModificationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchCreateBillScenarioUsageModificationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchCreateBillScenarioUsageModificationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchCreateBillScenarioUsageModificationRequest, BatchCreateBillScenarioUsageModificationResponse>()
                            .withOperationName("BatchCreateBillScenarioUsageModification").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchCreateBillScenarioUsageModificationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchCreateBillScenarioUsageModificationRequest));
            CompletableFuture<BatchCreateBillScenarioUsageModificationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create Amazon Web Services service usage that you want to model in a Workload Estimate.
     * </p>
     * <note>
     * <p>
     * The <code>BatchCreateWorkloadEstimateUsage</code> operation doesn't have its own IAM permission. To authorize
     * this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:CreateWorkloadEstimateUsage</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchCreateWorkloadEstimateUsageRequest
     * @return A Java Future containing the result of the BatchCreateWorkloadEstimateUsage operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchCreateWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchCreateWorkloadEstimateUsageResponse> batchCreateWorkloadEstimateUsage(
            BatchCreateWorkloadEstimateUsageRequest batchCreateWorkloadEstimateUsageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchCreateWorkloadEstimateUsageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchCreateWorkloadEstimateUsageRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateWorkloadEstimateUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchCreateWorkloadEstimateUsageResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchCreateWorkloadEstimateUsageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchCreateWorkloadEstimateUsageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchCreateWorkloadEstimateUsageRequest, BatchCreateWorkloadEstimateUsageResponse>()
                            .withOperationName("BatchCreateWorkloadEstimateUsage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchCreateWorkloadEstimateUsageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchCreateWorkloadEstimateUsageRequest));
            CompletableFuture<BatchCreateWorkloadEstimateUsageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete commitment that you have created in a Bill Scenario. You can only delete a commitment that you had added
     * and cannot model deletion (or removal) of a existing commitment. If you want model deletion of an existing
     * commitment, see the negate <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BillScenarioCommitmentModificationAction.html"
     * > BillScenarioCommitmentModificationAction</a> of <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchCreateBillScenarioUsageModification.html"
     * > BatchCreateBillScenarioCommitmentModification</a> operation.
     * </p>
     * <note>
     * <p>
     * The <code>BatchDeleteBillScenarioCommitmentModification</code> operation doesn't have its own IAM permission. To
     * authorize this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:DeleteBillScenarioCommitmentModification</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchDeleteBillScenarioCommitmentModificationRequest
     * @return A Java Future containing the result of the BatchDeleteBillScenarioCommitmentModification operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchDeleteBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteBillScenarioCommitmentModificationResponse> batchDeleteBillScenarioCommitmentModification(
            BatchDeleteBillScenarioCommitmentModificationRequest batchDeleteBillScenarioCommitmentModificationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchDeleteBillScenarioCommitmentModificationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDeleteBillScenarioCommitmentModificationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteBillScenarioCommitmentModification");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeleteBillScenarioCommitmentModificationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchDeleteBillScenarioCommitmentModificationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDeleteBillScenarioCommitmentModificationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteBillScenarioCommitmentModificationRequest, BatchDeleteBillScenarioCommitmentModificationResponse>()
                            .withOperationName("BatchDeleteBillScenarioCommitmentModification")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDeleteBillScenarioCommitmentModificationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDeleteBillScenarioCommitmentModificationRequest));
            CompletableFuture<BatchDeleteBillScenarioCommitmentModificationResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete usage that you have created in a Bill Scenario. You can only delete usage that you had added and cannot
     * model deletion (or removal) of a existing usage. If you want model removal of an existing usage, see <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateBillScenarioUsageModification.html"
     * > BatchUpdateBillScenarioUsageModification</a>.
     * </p>
     * <note>
     * <p>
     * The <code>BatchDeleteBillScenarioUsageModification</code> operation doesn't have its own IAM permission. To
     * authorize this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:DeleteBillScenarioUsageModification</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchDeleteBillScenarioUsageModificationRequest
     * @return A Java Future containing the result of the BatchDeleteBillScenarioUsageModification operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchDeleteBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteBillScenarioUsageModificationResponse> batchDeleteBillScenarioUsageModification(
            BatchDeleteBillScenarioUsageModificationRequest batchDeleteBillScenarioUsageModificationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchDeleteBillScenarioUsageModificationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDeleteBillScenarioUsageModificationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteBillScenarioUsageModification");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeleteBillScenarioUsageModificationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchDeleteBillScenarioUsageModificationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDeleteBillScenarioUsageModificationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteBillScenarioUsageModificationRequest, BatchDeleteBillScenarioUsageModificationResponse>()
                            .withOperationName("BatchDeleteBillScenarioUsageModification").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDeleteBillScenarioUsageModificationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDeleteBillScenarioUsageModificationRequest));
            CompletableFuture<BatchDeleteBillScenarioUsageModificationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete usage that you have created in a Workload estimate. You can only delete usage that you had added and
     * cannot model deletion (or removal) of a existing usage. If you want model removal of an existing usage, see <a
     * href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateWorkloadEstimateUsage.html"
     * > BatchUpdateWorkloadEstimateUsage</a>.
     * </p>
     * <note>
     * <p>
     * The <code>BatchDeleteWorkloadEstimateUsage</code> operation doesn't have its own IAM permission. To authorize
     * this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:DeleteWorkloadEstimateUsage</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchDeleteWorkloadEstimateUsageRequest
     * @return A Java Future containing the result of the BatchDeleteWorkloadEstimateUsage operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchDeleteWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteWorkloadEstimateUsageResponse> batchDeleteWorkloadEstimateUsage(
            BatchDeleteWorkloadEstimateUsageRequest batchDeleteWorkloadEstimateUsageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteWorkloadEstimateUsageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDeleteWorkloadEstimateUsageRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteWorkloadEstimateUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeleteWorkloadEstimateUsageResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchDeleteWorkloadEstimateUsageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDeleteWorkloadEstimateUsageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteWorkloadEstimateUsageRequest, BatchDeleteWorkloadEstimateUsageResponse>()
                            .withOperationName("BatchDeleteWorkloadEstimateUsage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDeleteWorkloadEstimateUsageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDeleteWorkloadEstimateUsageRequest));
            CompletableFuture<BatchDeleteWorkloadEstimateUsageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a newly added or existing commitment. You can update the commitment group based on a commitment ID and a
     * Bill scenario ID.
     * </p>
     * <note>
     * <p>
     * The <code>BatchUpdateBillScenarioCommitmentModification</code> operation doesn't have its own IAM permission. To
     * authorize this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:UpdateBillScenarioCommitmentModification</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchUpdateBillScenarioCommitmentModificationRequest
     * @return A Java Future containing the result of the BatchUpdateBillScenarioCommitmentModification operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchUpdateBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchUpdateBillScenarioCommitmentModificationResponse> batchUpdateBillScenarioCommitmentModification(
            BatchUpdateBillScenarioCommitmentModificationRequest batchUpdateBillScenarioCommitmentModificationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchUpdateBillScenarioCommitmentModificationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchUpdateBillScenarioCommitmentModificationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateBillScenarioCommitmentModification");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchUpdateBillScenarioCommitmentModificationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchUpdateBillScenarioCommitmentModificationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchUpdateBillScenarioCommitmentModificationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchUpdateBillScenarioCommitmentModificationRequest, BatchUpdateBillScenarioCommitmentModificationResponse>()
                            .withOperationName("BatchUpdateBillScenarioCommitmentModification")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchUpdateBillScenarioCommitmentModificationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchUpdateBillScenarioCommitmentModificationRequest));
            CompletableFuture<BatchUpdateBillScenarioCommitmentModificationResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a newly added or existing usage lines. You can update the usage amounts, usage hour, and usage group based
     * on a usage ID and a Bill scenario ID.
     * </p>
     * <note>
     * <p>
     * The <code>BatchUpdateBillScenarioUsageModification</code> operation doesn't have its own IAM permission. To
     * authorize this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:UpdateBillScenarioUsageModification</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchUpdateBillScenarioUsageModificationRequest
     * @return A Java Future containing the result of the BatchUpdateBillScenarioUsageModification operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchUpdateBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchUpdateBillScenarioUsageModificationResponse> batchUpdateBillScenarioUsageModification(
            BatchUpdateBillScenarioUsageModificationRequest batchUpdateBillScenarioUsageModificationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchUpdateBillScenarioUsageModificationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchUpdateBillScenarioUsageModificationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateBillScenarioUsageModification");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchUpdateBillScenarioUsageModificationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchUpdateBillScenarioUsageModificationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchUpdateBillScenarioUsageModificationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchUpdateBillScenarioUsageModificationRequest, BatchUpdateBillScenarioUsageModificationResponse>()
                            .withOperationName("BatchUpdateBillScenarioUsageModification").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchUpdateBillScenarioUsageModificationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchUpdateBillScenarioUsageModificationRequest));
            CompletableFuture<BatchUpdateBillScenarioUsageModificationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a newly added or existing usage lines. You can update the usage amounts and usage group based on a usage
     * ID and a Workload estimate ID.
     * </p>
     * <note>
     * <p>
     * The <code>BatchUpdateWorkloadEstimateUsage</code> operation doesn't have its own IAM permission. To authorize
     * this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:UpdateWorkloadEstimateUsage</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchUpdateWorkloadEstimateUsageRequest
     * @return A Java Future containing the result of the BatchUpdateWorkloadEstimateUsage operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchUpdateWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchUpdateWorkloadEstimateUsageResponse> batchUpdateWorkloadEstimateUsage(
            BatchUpdateWorkloadEstimateUsageRequest batchUpdateWorkloadEstimateUsageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchUpdateWorkloadEstimateUsageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchUpdateWorkloadEstimateUsageRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateWorkloadEstimateUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchUpdateWorkloadEstimateUsageResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchUpdateWorkloadEstimateUsageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchUpdateWorkloadEstimateUsageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchUpdateWorkloadEstimateUsageRequest, BatchUpdateWorkloadEstimateUsageResponse>()
                            .withOperationName("BatchUpdateWorkloadEstimateUsage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchUpdateWorkloadEstimateUsageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchUpdateWorkloadEstimateUsageRequest));
            CompletableFuture<BatchUpdateWorkloadEstimateUsageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a Bill estimate from a Bill scenario. In the Bill scenario you can model usage addition, usage changes,
     * and usage removal. You can also model commitment addition and commitment removal. After all changes in a Bill
     * scenario is made satisfactorily, you can call this API with a Bill scenario ID to generate the Bill estimate.
     * Bill estimate calculates the pre-tax cost for your consolidated billing family, incorporating all modeled usage
     * and commitments alongside existing usage and commitments from your most recent completed anniversary bill, with
     * any applicable discounts applied.
     * </p>
     *
     * @param createBillEstimateRequest
     * @return A Java Future containing the result of the CreateBillEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.CreateBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBillEstimateResponse> createBillEstimate(CreateBillEstimateRequest createBillEstimateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBillEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBillEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBillEstimate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBillEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBillEstimateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBillEstimateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBillEstimateRequest, CreateBillEstimateResponse>()
                            .withOperationName("CreateBillEstimate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBillEstimateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createBillEstimateRequest));
            CompletableFuture<CreateBillEstimateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new bill scenario to model potential changes to Amazon Web Services usage and costs.
     * </p>
     *
     * @param createBillScenarioRequest
     * @return A Java Future containing the result of the CreateBillScenario operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.CreateBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBillScenarioResponse> createBillScenario(CreateBillScenarioRequest createBillScenarioRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBillScenarioRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBillScenarioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBillScenario");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBillScenarioResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBillScenarioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBillScenarioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBillScenarioRequest, CreateBillScenarioResponse>()
                            .withOperationName("CreateBillScenario").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBillScenarioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createBillScenarioRequest));
            CompletableFuture<CreateBillScenarioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new workload estimate to model costs for a specific workload.
     * </p>
     *
     * @param createWorkloadEstimateRequest
     * @return A Java Future containing the result of the CreateWorkloadEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.CreateWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWorkloadEstimateResponse> createWorkloadEstimate(
            CreateWorkloadEstimateRequest createWorkloadEstimateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkloadEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkloadEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkloadEstimate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWorkloadEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWorkloadEstimateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWorkloadEstimateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWorkloadEstimateRequest, CreateWorkloadEstimateResponse>()
                            .withOperationName("CreateWorkloadEstimate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateWorkloadEstimateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createWorkloadEstimateRequest));
            CompletableFuture<CreateWorkloadEstimateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing bill estimate.
     * </p>
     *
     * @param deleteBillEstimateRequest
     * @return A Java Future containing the result of the DeleteBillEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.DeleteBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBillEstimateResponse> deleteBillEstimate(DeleteBillEstimateRequest deleteBillEstimateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBillEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBillEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBillEstimate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBillEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBillEstimateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBillEstimateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBillEstimateRequest, DeleteBillEstimateResponse>()
                            .withOperationName("DeleteBillEstimate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBillEstimateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBillEstimateRequest));
            CompletableFuture<DeleteBillEstimateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing bill scenario.
     * </p>
     *
     * @param deleteBillScenarioRequest
     * @return A Java Future containing the result of the DeleteBillScenario operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.DeleteBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBillScenarioResponse> deleteBillScenario(DeleteBillScenarioRequest deleteBillScenarioRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBillScenarioRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBillScenarioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBillScenario");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBillScenarioResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBillScenarioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBillScenarioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBillScenarioRequest, DeleteBillScenarioResponse>()
                            .withOperationName("DeleteBillScenario").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBillScenarioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBillScenarioRequest));
            CompletableFuture<DeleteBillScenarioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing workload estimate.
     * </p>
     *
     * @param deleteWorkloadEstimateRequest
     * @return A Java Future containing the result of the DeleteWorkloadEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.DeleteWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWorkloadEstimateResponse> deleteWorkloadEstimate(
            DeleteWorkloadEstimateRequest deleteWorkloadEstimateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkloadEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkloadEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkloadEstimate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWorkloadEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWorkloadEstimateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWorkloadEstimateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWorkloadEstimateRequest, DeleteWorkloadEstimateResponse>()
                            .withOperationName("DeleteWorkloadEstimate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteWorkloadEstimateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteWorkloadEstimateRequest));
            CompletableFuture<DeleteWorkloadEstimateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves details of a specific bill estimate.
     * </p>
     *
     * @param getBillEstimateRequest
     * @return A Java Future containing the result of the GetBillEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.GetBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBillEstimateResponse> getBillEstimate(GetBillEstimateRequest getBillEstimateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBillEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBillEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBillEstimate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBillEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBillEstimateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBillEstimateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBillEstimateRequest, GetBillEstimateResponse>()
                            .withOperationName("GetBillEstimate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBillEstimateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBillEstimateRequest));
            CompletableFuture<GetBillEstimateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves details of a specific bill scenario.
     * </p>
     *
     * @param getBillScenarioRequest
     * @return A Java Future containing the result of the GetBillScenario operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.GetBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBillScenarioResponse> getBillScenario(GetBillScenarioRequest getBillScenarioRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBillScenarioRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBillScenarioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBillScenario");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBillScenarioResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBillScenarioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBillScenarioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBillScenarioRequest, GetBillScenarioResponse>()
                            .withOperationName("GetBillScenario").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBillScenarioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBillScenarioRequest));
            CompletableFuture<GetBillScenarioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the current preferences for the Amazon Web Services Cost Explorer service.
     * </p>
     *
     * @param getPreferencesRequest
     * @return A Java Future containing the result of the GetPreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.GetPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPreferencesResponse> getPreferences(GetPreferencesRequest getPreferencesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPreferencesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPreferencesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPreferences");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPreferencesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPreferencesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPreferencesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPreferencesRequest, GetPreferencesResponse>()
                            .withOperationName("GetPreferences").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPreferencesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPreferencesRequest));
            CompletableFuture<GetPreferencesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves details of a specific workload estimate.
     * </p>
     *
     * @param getWorkloadEstimateRequest
     * @return A Java Future containing the result of the GetWorkloadEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.GetWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWorkloadEstimateResponse> getWorkloadEstimate(
            GetWorkloadEstimateRequest getWorkloadEstimateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkloadEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkloadEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkloadEstimate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWorkloadEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWorkloadEstimateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWorkloadEstimateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWorkloadEstimateRequest, GetWorkloadEstimateResponse>()
                            .withOperationName("GetWorkloadEstimate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetWorkloadEstimateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWorkloadEstimateRequest));
            CompletableFuture<GetWorkloadEstimateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the commitments associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateCommitmentsRequest
     * @return A Java Future containing the result of the ListBillEstimateCommitments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateCommitments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateCommitments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBillEstimateCommitmentsResponse> listBillEstimateCommitments(
            ListBillEstimateCommitmentsRequest listBillEstimateCommitmentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBillEstimateCommitmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBillEstimateCommitmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillEstimateCommitments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBillEstimateCommitmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBillEstimateCommitmentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBillEstimateCommitmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBillEstimateCommitmentsRequest, ListBillEstimateCommitmentsResponse>()
                            .withOperationName("ListBillEstimateCommitments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBillEstimateCommitmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBillEstimateCommitmentsRequest));
            CompletableFuture<ListBillEstimateCommitmentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the input commitment modifications associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateInputCommitmentModificationsRequest
     * @return A Java Future containing the result of the ListBillEstimateInputCommitmentModifications operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateInputCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBillEstimateInputCommitmentModificationsResponse> listBillEstimateInputCommitmentModifications(
            ListBillEstimateInputCommitmentModificationsRequest listBillEstimateInputCommitmentModificationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listBillEstimateInputCommitmentModificationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listBillEstimateInputCommitmentModificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillEstimateInputCommitmentModifications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBillEstimateInputCommitmentModificationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListBillEstimateInputCommitmentModificationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBillEstimateInputCommitmentModificationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBillEstimateInputCommitmentModificationsRequest, ListBillEstimateInputCommitmentModificationsResponse>()
                            .withOperationName("ListBillEstimateInputCommitmentModifications")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBillEstimateInputCommitmentModificationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBillEstimateInputCommitmentModificationsRequest));
            CompletableFuture<ListBillEstimateInputCommitmentModificationsResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the input usage modifications associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateInputUsageModificationsRequest
     * @return A Java Future containing the result of the ListBillEstimateInputUsageModifications operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateInputUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBillEstimateInputUsageModificationsResponse> listBillEstimateInputUsageModifications(
            ListBillEstimateInputUsageModificationsRequest listBillEstimateInputUsageModificationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBillEstimateInputUsageModificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listBillEstimateInputUsageModificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillEstimateInputUsageModifications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBillEstimateInputUsageModificationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListBillEstimateInputUsageModificationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBillEstimateInputUsageModificationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBillEstimateInputUsageModificationsRequest, ListBillEstimateInputUsageModificationsResponse>()
                            .withOperationName("ListBillEstimateInputUsageModifications").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBillEstimateInputUsageModificationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBillEstimateInputUsageModificationsRequest));
            CompletableFuture<ListBillEstimateInputUsageModificationsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the line items associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateLineItemsRequest
     * @return A Java Future containing the result of the ListBillEstimateLineItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateLineItems
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBillEstimateLineItemsResponse> listBillEstimateLineItems(
            ListBillEstimateLineItemsRequest listBillEstimateLineItemsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBillEstimateLineItemsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBillEstimateLineItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillEstimateLineItems");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBillEstimateLineItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBillEstimateLineItemsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBillEstimateLineItemsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBillEstimateLineItemsRequest, ListBillEstimateLineItemsResponse>()
                            .withOperationName("ListBillEstimateLineItems").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBillEstimateLineItemsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBillEstimateLineItemsRequest));
            CompletableFuture<ListBillEstimateLineItemsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all bill estimates for the account.
     * </p>
     *
     * @param listBillEstimatesRequest
     * @return A Java Future containing the result of the ListBillEstimates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBillEstimatesResponse> listBillEstimates(ListBillEstimatesRequest listBillEstimatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBillEstimatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBillEstimatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillEstimates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBillEstimatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBillEstimatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBillEstimatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBillEstimatesRequest, ListBillEstimatesResponse>()
                            .withOperationName("ListBillEstimates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBillEstimatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBillEstimatesRequest));
            CompletableFuture<ListBillEstimatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the commitment modifications associated with a bill scenario.
     * </p>
     *
     * @param listBillScenarioCommitmentModificationsRequest
     * @return A Java Future containing the result of the ListBillScenarioCommitmentModifications operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillScenarioCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBillScenarioCommitmentModificationsResponse> listBillScenarioCommitmentModifications(
            ListBillScenarioCommitmentModificationsRequest listBillScenarioCommitmentModificationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBillScenarioCommitmentModificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listBillScenarioCommitmentModificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillScenarioCommitmentModifications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBillScenarioCommitmentModificationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListBillScenarioCommitmentModificationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBillScenarioCommitmentModificationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBillScenarioCommitmentModificationsRequest, ListBillScenarioCommitmentModificationsResponse>()
                            .withOperationName("ListBillScenarioCommitmentModifications").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBillScenarioCommitmentModificationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBillScenarioCommitmentModificationsRequest));
            CompletableFuture<ListBillScenarioCommitmentModificationsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the usage modifications associated with a bill scenario.
     * </p>
     *
     * @param listBillScenarioUsageModificationsRequest
     * @return A Java Future containing the result of the ListBillScenarioUsageModifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillScenarioUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBillScenarioUsageModificationsResponse> listBillScenarioUsageModifications(
            ListBillScenarioUsageModificationsRequest listBillScenarioUsageModificationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBillScenarioUsageModificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listBillScenarioUsageModificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillScenarioUsageModifications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBillScenarioUsageModificationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListBillScenarioUsageModificationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBillScenarioUsageModificationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBillScenarioUsageModificationsRequest, ListBillScenarioUsageModificationsResponse>()
                            .withOperationName("ListBillScenarioUsageModifications").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBillScenarioUsageModificationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBillScenarioUsageModificationsRequest));
            CompletableFuture<ListBillScenarioUsageModificationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all bill scenarios for the account.
     * </p>
     *
     * @param listBillScenariosRequest
     * @return A Java Future containing the result of the ListBillScenarios operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillScenarios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarios"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBillScenariosResponse> listBillScenarios(ListBillScenariosRequest listBillScenariosRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBillScenariosRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBillScenariosRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillScenarios");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBillScenariosResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBillScenariosResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBillScenariosResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBillScenariosRequest, ListBillScenariosResponse>()
                            .withOperationName("ListBillScenarios").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBillScenariosRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBillScenariosRequest));
            CompletableFuture<ListBillScenariosResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all tags associated with a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the usage associated with a workload estimate.
     * </p>
     *
     * @param listWorkloadEstimateUsageRequest
     * @return A Java Future containing the result of the ListWorkloadEstimateUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWorkloadEstimateUsageResponse> listWorkloadEstimateUsage(
            ListWorkloadEstimateUsageRequest listWorkloadEstimateUsageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkloadEstimateUsageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkloadEstimateUsageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkloadEstimateUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWorkloadEstimateUsageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWorkloadEstimateUsageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWorkloadEstimateUsageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWorkloadEstimateUsageRequest, ListWorkloadEstimateUsageResponse>()
                            .withOperationName("ListWorkloadEstimateUsage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListWorkloadEstimateUsageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWorkloadEstimateUsageRequest));
            CompletableFuture<ListWorkloadEstimateUsageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all workload estimates for the account.
     * </p>
     *
     * @param listWorkloadEstimatesRequest
     * @return A Java Future containing the result of the ListWorkloadEstimates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListWorkloadEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWorkloadEstimatesResponse> listWorkloadEstimates(
            ListWorkloadEstimatesRequest listWorkloadEstimatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkloadEstimatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkloadEstimatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkloadEstimates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWorkloadEstimatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWorkloadEstimatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWorkloadEstimatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWorkloadEstimatesRequest, ListWorkloadEstimatesResponse>()
                            .withOperationName("ListWorkloadEstimates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListWorkloadEstimatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWorkloadEstimatesRequest));
            CompletableFuture<ListWorkloadEstimatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing bill estimate.
     * </p>
     *
     * @param updateBillEstimateRequest
     * @return A Java Future containing the result of the UpdateBillEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.UpdateBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBillEstimateResponse> updateBillEstimate(UpdateBillEstimateRequest updateBillEstimateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBillEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBillEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBillEstimate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBillEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBillEstimateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBillEstimateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBillEstimateRequest, UpdateBillEstimateResponse>()
                            .withOperationName("UpdateBillEstimate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateBillEstimateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateBillEstimateRequest));
            CompletableFuture<UpdateBillEstimateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing bill scenario.
     * </p>
     *
     * @param updateBillScenarioRequest
     * @return A Java Future containing the result of the UpdateBillScenario operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.UpdateBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBillScenarioResponse> updateBillScenario(UpdateBillScenarioRequest updateBillScenarioRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBillScenarioRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBillScenarioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBillScenario");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBillScenarioResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBillScenarioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBillScenarioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBillScenarioRequest, UpdateBillScenarioResponse>()
                            .withOperationName("UpdateBillScenario").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateBillScenarioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateBillScenarioRequest));
            CompletableFuture<UpdateBillScenarioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the preferences for the Amazon Web Services Cost Explorer service.
     * </p>
     *
     * @param updatePreferencesRequest
     * @return A Java Future containing the result of the UpdatePreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.UpdatePreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdatePreferences"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePreferencesResponse> updatePreferences(UpdatePreferencesRequest updatePreferencesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePreferencesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePreferencesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePreferences");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePreferencesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePreferencesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePreferencesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePreferencesRequest, UpdatePreferencesResponse>()
                            .withOperationName("UpdatePreferences").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdatePreferencesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updatePreferencesRequest));
            CompletableFuture<UpdatePreferencesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing workload estimate.
     * </p>
     *
     * @param updateWorkloadEstimateRequest
     * @return A Java Future containing the result of the UpdateWorkloadEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.UpdateWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWorkloadEstimateResponse> updateWorkloadEstimate(
            UpdateWorkloadEstimateRequest updateWorkloadEstimateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkloadEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkloadEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkloadEstimate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWorkloadEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateWorkloadEstimateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateWorkloadEstimateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWorkloadEstimateRequest, UpdateWorkloadEstimateResponse>()
                            .withOperationName("UpdateWorkloadEstimate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateWorkloadEstimateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateWorkloadEstimateRequest));
            CompletableFuture<UpdateWorkloadEstimateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final BcmPricingCalculatorServiceClientConfiguration serviceClientConfiguration() {
        return new BcmPricingCalculatorServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(BcmPricingCalculatorException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.0")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DataUnavailableException")
                                .exceptionBuilderSupplier(DataUnavailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        BcmPricingCalculatorServiceClientConfigurationBuilder serviceConfigBuilder = new BcmPricingCalculatorServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
