/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateBillScenarioCommitmentModificationResponse extends BcmPricingCalculatorResponse
        implements
        ToCopyableBuilder<BatchCreateBillScenarioCommitmentModificationResponse.Builder, BatchCreateBillScenarioCommitmentModificationResponse> {
    private static final SdkField<List<BatchCreateBillScenarioCommitmentModificationItem>> ITEMS_FIELD = SdkField
            .<List<BatchCreateBillScenarioCommitmentModificationItem>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(BatchCreateBillScenarioCommitmentModificationResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchCreateBillScenarioCommitmentModificationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchCreateBillScenarioCommitmentModificationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchCreateBillScenarioCommitmentModificationError>> ERRORS_FIELD = SdkField
            .<List<BatchCreateBillScenarioCommitmentModificationError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchCreateBillScenarioCommitmentModificationResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchCreateBillScenarioCommitmentModificationError> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(BatchCreateBillScenarioCommitmentModificationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchCreateBillScenarioCommitmentModificationItem> items;

    private final List<BatchCreateBillScenarioCommitmentModificationError> errors;

    private BatchCreateBillScenarioCommitmentModificationResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the list of successful commitment line items that were created for the Bill Scenario.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return Returns the list of successful commitment line items that were created for the Bill Scenario.
     */
    public final List<BatchCreateBillScenarioCommitmentModificationItem> items() {
        return items;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the list of errors reason and the commitment item keys that cannot be created in the Bill Scenario.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Returns the list of errors reason and the commitment item keys that cannot be created in the Bill
     *         Scenario.
     */
    public final List<BatchCreateBillScenarioCommitmentModificationError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateBillScenarioCommitmentModificationResponse)) {
            return false;
        }
        BatchCreateBillScenarioCommitmentModificationResponse other = (BatchCreateBillScenarioCommitmentModificationResponse) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateBillScenarioCommitmentModificationResponse")
                .add("Items", hasItems() ? items() : null).add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("items", ITEMS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateBillScenarioCommitmentModificationResponse, T> g) {
        return obj -> g.apply((BatchCreateBillScenarioCommitmentModificationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BcmPricingCalculatorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchCreateBillScenarioCommitmentModificationResponse> {
        /**
         * <p>
         * Returns the list of successful commitment line items that were created for the Bill Scenario.
         * </p>
         * 
         * @param items
         *        Returns the list of successful commitment line items that were created for the Bill Scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<BatchCreateBillScenarioCommitmentModificationItem> items);

        /**
         * <p>
         * Returns the list of successful commitment line items that were created for the Bill Scenario.
         * </p>
         * 
         * @param items
         *        Returns the list of successful commitment line items that were created for the Bill Scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(BatchCreateBillScenarioCommitmentModificationItem... items);

        /**
         * <p>
         * Returns the list of successful commitment line items that were created for the Bill Scenario.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationItem#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationItem.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #items(List<BatchCreateBillScenarioCommitmentModificationItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<BatchCreateBillScenarioCommitmentModificationItem>)
         */
        Builder items(Consumer<BatchCreateBillScenarioCommitmentModificationItem.Builder>... items);

        /**
         * <p>
         * Returns the list of errors reason and the commitment item keys that cannot be created in the Bill Scenario.
         * </p>
         * 
         * @param errors
         *        Returns the list of errors reason and the commitment item keys that cannot be created in the Bill
         *        Scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchCreateBillScenarioCommitmentModificationError> errors);

        /**
         * <p>
         * Returns the list of errors reason and the commitment item keys that cannot be created in the Bill Scenario.
         * </p>
         * 
         * @param errors
         *        Returns the list of errors reason and the commitment item keys that cannot be created in the Bill
         *        Scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchCreateBillScenarioCommitmentModificationError... errors);

        /**
         * <p>
         * Returns the list of errors reason and the commitment item keys that cannot be created in the Bill Scenario.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationError.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationError#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationError.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #errors(List<BatchCreateBillScenarioCommitmentModificationError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchCreateBillScenarioCommitmentModificationError>)
         */
        Builder errors(Consumer<BatchCreateBillScenarioCommitmentModificationError.Builder>... errors);
    }

    static final class BuilderImpl extends BcmPricingCalculatorResponse.BuilderImpl implements Builder {
        private List<BatchCreateBillScenarioCommitmentModificationItem> items = DefaultSdkAutoConstructList.getInstance();

        private List<BatchCreateBillScenarioCommitmentModificationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateBillScenarioCommitmentModificationResponse model) {
            super(model);
            items(model.items);
            errors(model.errors);
        }

        public final List<BatchCreateBillScenarioCommitmentModificationItem.Builder> getItems() {
            List<BatchCreateBillScenarioCommitmentModificationItem.Builder> result = BatchCreateBillScenarioCommitmentModificationItemsCopier
                    .copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<BatchCreateBillScenarioCommitmentModificationItem.BuilderImpl> items) {
            this.items = BatchCreateBillScenarioCommitmentModificationItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<BatchCreateBillScenarioCommitmentModificationItem> items) {
            this.items = BatchCreateBillScenarioCommitmentModificationItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(BatchCreateBillScenarioCommitmentModificationItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<BatchCreateBillScenarioCommitmentModificationItem.Builder>... items) {
            items(Stream.of(items).map(c -> BatchCreateBillScenarioCommitmentModificationItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchCreateBillScenarioCommitmentModificationError.Builder> getErrors() {
            List<BatchCreateBillScenarioCommitmentModificationError.Builder> result = BatchCreateBillScenarioCommitmentModificationErrorsCopier
                    .copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchCreateBillScenarioCommitmentModificationError.BuilderImpl> errors) {
            this.errors = BatchCreateBillScenarioCommitmentModificationErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchCreateBillScenarioCommitmentModificationError> errors) {
            this.errors = BatchCreateBillScenarioCommitmentModificationErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchCreateBillScenarioCommitmentModificationError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchCreateBillScenarioCommitmentModificationError.Builder>... errors) {
            errors(Stream.of(errors)
                    .map(c -> BatchCreateBillScenarioCommitmentModificationError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchCreateBillScenarioCommitmentModificationResponse build() {
            return new BatchCreateBillScenarioCommitmentModificationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
