/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of a bill estimate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillEstimateSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BillEstimateSummary.Builder, BillEstimateSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(BillEstimateSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(BillEstimateSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BillEstimateSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<BillInterval> BILL_INTERVAL_FIELD = SdkField.<BillInterval> builder(MarshallingType.SDK_POJO)
            .memberName("billInterval").getter(getter(BillEstimateSummary::billInterval)).setter(setter(Builder::billInterval))
            .constructor(BillInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billInterval").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(BillEstimateSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiresAt").getter(getter(BillEstimateSummary::expiresAt)).setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            STATUS_FIELD, BILL_INTERVAL_FIELD, CREATED_AT_FIELD, EXPIRES_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String status;

    private final BillInterval billInterval;

    private final Instant createdAt;

    private final Instant expiresAt;

    private BillEstimateSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.billInterval = builder.billInterval;
        this.createdAt = builder.createdAt;
        this.expiresAt = builder.expiresAt;
    }

    /**
     * <p>
     * The unique identifier of the bill estimate.
     * </p>
     * 
     * @return The unique identifier of the bill estimate.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the bill estimate.
     * </p>
     * 
     * @return The name of the bill estimate.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the bill estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BillEstimateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the bill estimate.
     * @see BillEstimateStatus
     */
    public final BillEstimateStatus status() {
        return BillEstimateStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the bill estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BillEstimateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the bill estimate.
     * @see BillEstimateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time period covered by the bill estimate.
     * </p>
     * 
     * @return The time period covered by the bill estimate.
     */
    public final BillInterval billInterval() {
        return billInterval;
    }

    /**
     * <p>
     * The timestamp when the bill estimate was created.
     * </p>
     * 
     * @return The timestamp when the bill estimate was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the bill estimate will expire.
     * </p>
     * 
     * @return The timestamp when the bill estimate will expire.
     */
    public final Instant expiresAt() {
        return expiresAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(billInterval());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillEstimateSummary)) {
            return false;
        }
        BillEstimateSummary other = (BillEstimateSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(billInterval(), other.billInterval()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(expiresAt(), other.expiresAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillEstimateSummary").add("Id", id()).add("Name", name()).add("Status", statusAsString())
                .add("BillInterval", billInterval()).add("CreatedAt", createdAt()).add("ExpiresAt", expiresAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "billInterval":
            return Optional.ofNullable(clazz.cast(billInterval()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "expiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("billInterval", BILL_INTERVAL_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillEstimateSummary, T> g) {
        return obj -> g.apply((BillEstimateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillEstimateSummary> {
        /**
         * <p>
         * The unique identifier of the bill estimate.
         * </p>
         * 
         * @param id
         *        The unique identifier of the bill estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the bill estimate.
         * </p>
         * 
         * @param name
         *        The name of the bill estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the bill estimate.
         * </p>
         * 
         * @param status
         *        The current status of the bill estimate.
         * @see BillEstimateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillEstimateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the bill estimate.
         * </p>
         * 
         * @param status
         *        The current status of the bill estimate.
         * @see BillEstimateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillEstimateStatus
         */
        Builder status(BillEstimateStatus status);

        /**
         * <p>
         * The time period covered by the bill estimate.
         * </p>
         * 
         * @param billInterval
         *        The time period covered by the bill estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billInterval(BillInterval billInterval);

        /**
         * <p>
         * The time period covered by the bill estimate.
         * </p>
         * This is a convenience method that creates an instance of the {@link BillInterval.Builder} avoiding the need
         * to create one manually via {@link BillInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BillInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #billInterval(BillInterval)}.
         * 
         * @param billInterval
         *        a consumer that will call methods on {@link BillInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billInterval(BillInterval)
         */
        default Builder billInterval(Consumer<BillInterval.Builder> billInterval) {
            return billInterval(BillInterval.builder().applyMutation(billInterval).build());
        }

        /**
         * <p>
         * The timestamp when the bill estimate was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the bill estimate was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the bill estimate will expire.
         * </p>
         * 
         * @param expiresAt
         *        The timestamp when the bill estimate will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String status;

        private BillInterval billInterval;

        private Instant createdAt;

        private Instant expiresAt;

        private BuilderImpl() {
        }

        private BuilderImpl(BillEstimateSummary model) {
            id(model.id);
            name(model.name);
            status(model.status);
            billInterval(model.billInterval);
            createdAt(model.createdAt);
            expiresAt(model.expiresAt);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BillEstimateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final BillInterval.Builder getBillInterval() {
            return billInterval != null ? billInterval.toBuilder() : null;
        }

        public final void setBillInterval(BillInterval.BuilderImpl billInterval) {
            this.billInterval = billInterval != null ? billInterval.build() : null;
        }

        @Override
        public final Builder billInterval(BillInterval billInterval) {
            this.billInterval = billInterval;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public BillEstimateSummary build() {
            return new BillEstimateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
