/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an action to add a Reserved Instance to a bill scenario.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddReservedInstanceAction implements SdkPojo, Serializable,
        ToCopyableBuilder<AddReservedInstanceAction.Builder, AddReservedInstanceAction> {
    private static final SdkField<String> RESERVED_INSTANCES_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("reservedInstancesOfferingId")
            .getter(getter(AddReservedInstanceAction::reservedInstancesOfferingId))
            .setter(setter(Builder::reservedInstancesOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedInstancesOfferingId")
                    .build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("instanceCount").getter(getter(AddReservedInstanceAction::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_INSTANCES_OFFERING_ID_FIELD, INSTANCE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reservedInstancesOfferingId;

    private final Integer instanceCount;

    private AddReservedInstanceAction(BuilderImpl builder) {
        this.reservedInstancesOfferingId = builder.reservedInstancesOfferingId;
        this.instanceCount = builder.instanceCount;
    }

    /**
     * <p>
     * The ID of the Reserved Instance offering to add. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstancesOfferings.html">
     * DescribeReservedInstancesOfferings</a>.
     * </p>
     * 
     * @return The ID of the Reserved Instance offering to add. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstancesOfferings.html"
     *         > DescribeReservedInstancesOfferings</a>.
     */
    public final String reservedInstancesOfferingId() {
        return reservedInstancesOfferingId;
    }

    /**
     * <p>
     * The number of instances to add for this Reserved Instance offering.
     * </p>
     * 
     * @return The number of instances to add for this Reserved Instance offering.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddReservedInstanceAction)) {
            return false;
        }
        AddReservedInstanceAction other = (AddReservedInstanceAction) obj;
        return Objects.equals(reservedInstancesOfferingId(), other.reservedInstancesOfferingId())
                && Objects.equals(instanceCount(), other.instanceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddReservedInstanceAction").add("ReservedInstancesOfferingId", reservedInstancesOfferingId())
                .add("InstanceCount", instanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reservedInstancesOfferingId":
            return Optional.ofNullable(clazz.cast(reservedInstancesOfferingId()));
        case "instanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reservedInstancesOfferingId", RESERVED_INSTANCES_OFFERING_ID_FIELD);
        map.put("instanceCount", INSTANCE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddReservedInstanceAction, T> g) {
        return obj -> g.apply((AddReservedInstanceAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddReservedInstanceAction> {
        /**
         * <p>
         * The ID of the Reserved Instance offering to add. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstancesOfferings.html">
         * DescribeReservedInstancesOfferings</a>.
         * </p>
         * 
         * @param reservedInstancesOfferingId
         *        The ID of the Reserved Instance offering to add. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstancesOfferings.html">
         *        DescribeReservedInstancesOfferings</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesOfferingId(String reservedInstancesOfferingId);

        /**
         * <p>
         * The number of instances to add for this Reserved Instance offering.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances to add for this Reserved Instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);
    }

    static final class BuilderImpl implements Builder {
        private String reservedInstancesOfferingId;

        private Integer instanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AddReservedInstanceAction model) {
            reservedInstancesOfferingId(model.reservedInstancesOfferingId);
            instanceCount(model.instanceCount);
        }

        public final String getReservedInstancesOfferingId() {
            return reservedInstancesOfferingId;
        }

        public final void setReservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
        }

        @Override
        public final Builder reservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        @Override
        public AddReservedInstanceAction build() {
            return new AddReservedInstanceAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
