/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an entry in a batch operation to update workload estimate usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateWorkloadEstimateUsageEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchUpdateWorkloadEstimateUsageEntry.Builder, BatchUpdateWorkloadEstimateUsageEntry> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(BatchUpdateWorkloadEstimateUsageEntry::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("group")
            .getter(getter(BatchUpdateWorkloadEstimateUsageEntry::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final SdkField<Double> AMOUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("amount")
            .getter(getter(BatchUpdateWorkloadEstimateUsageEntry::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, GROUP_FIELD,
            AMOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String group;

    private final Double amount;

    private BatchUpdateWorkloadEstimateUsageEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.group = builder.group;
        this.amount = builder.amount;
    }

    /**
     * <p>
     * The unique identifier of the usage estimate to update.
     * </p>
     * 
     * @return The unique identifier of the usage estimate to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The updated group identifier for the usage estimate.
     * </p>
     * 
     * @return The updated group identifier for the usage estimate.
     */
    public final String group() {
        return group;
    }

    /**
     * <p>
     * The updated estimated usage amount.
     * </p>
     * 
     * @return The updated estimated usage amount.
     */
    public final Double amount() {
        return amount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateWorkloadEstimateUsageEntry)) {
            return false;
        }
        BatchUpdateWorkloadEstimateUsageEntry other = (BatchUpdateWorkloadEstimateUsageEntry) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(group(), other.group())
                && Objects.equals(amount(), other.amount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateWorkloadEstimateUsageEntry").add("Id", id()).add("Group", group())
                .add("Amount", amount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        case "amount":
            return Optional.ofNullable(clazz.cast(amount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("group", GROUP_FIELD);
        map.put("amount", AMOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateWorkloadEstimateUsageEntry, T> g) {
        return obj -> g.apply((BatchUpdateWorkloadEstimateUsageEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchUpdateWorkloadEstimateUsageEntry> {
        /**
         * <p>
         * The unique identifier of the usage estimate to update.
         * </p>
         * 
         * @param id
         *        The unique identifier of the usage estimate to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The updated group identifier for the usage estimate.
         * </p>
         * 
         * @param group
         *        The updated group identifier for the usage estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The updated estimated usage amount.
         * </p>
         * 
         * @param amount
         *        The updated estimated usage amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Double amount);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String group;

        private Double amount;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateWorkloadEstimateUsageEntry model) {
            id(model.id);
            group(model.group);
            amount(model.amount);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final Double getAmount() {
            return amount;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        @Override
        public BatchUpdateWorkloadEstimateUsageEntry build() {
            return new BatchUpdateWorkloadEstimateUsageEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
