/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an action to remove a Savings Plan from a bill scenario.
 * </p>
 * <p>
 * This is the ID of an existing Savings Plan in your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NegateSavingsPlanAction implements SdkPojo, Serializable,
        ToCopyableBuilder<NegateSavingsPlanAction.Builder, NegateSavingsPlanAction> {
    private static final SdkField<String> SAVINGS_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("savingsPlanId").getter(getter(NegateSavingsPlanAction::savingsPlanId))
            .setter(setter(Builder::savingsPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLAN_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String savingsPlanId;

    private NegateSavingsPlanAction(BuilderImpl builder) {
        this.savingsPlanId = builder.savingsPlanId;
    }

    /**
     * <p>
     * The ID of the Savings Plan to remove.
     * </p>
     * 
     * @return The ID of the Savings Plan to remove.
     */
    public final String savingsPlanId() {
        return savingsPlanId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NegateSavingsPlanAction)) {
            return false;
        }
        NegateSavingsPlanAction other = (NegateSavingsPlanAction) obj;
        return Objects.equals(savingsPlanId(), other.savingsPlanId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NegateSavingsPlanAction").add("SavingsPlanId", savingsPlanId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsPlanId":
            return Optional.ofNullable(clazz.cast(savingsPlanId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("savingsPlanId", SAVINGS_PLAN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NegateSavingsPlanAction, T> g) {
        return obj -> g.apply((NegateSavingsPlanAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NegateSavingsPlanAction> {
        /**
         * <p>
         * The ID of the Savings Plan to remove.
         * </p>
         * 
         * @param savingsPlanId
         *        The ID of the Savings Plan to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanId(String savingsPlanId);
    }

    static final class BuilderImpl implements Builder {
        private String savingsPlanId;

        private BuilderImpl() {
        }

        private BuilderImpl(NegateSavingsPlanAction model) {
            savingsPlanId(model.savingsPlanId);
        }

        public final String getSavingsPlanId() {
            return savingsPlanId;
        }

        public final void setSavingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
        }

        @Override
        public final Builder savingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
            return this;
        }

        @Override
        public NegateSavingsPlanAction build() {
            return new NegateSavingsPlanAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
