/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.RateType;
import software.amazon.awssdk.services.bcmpricingcalculator.model.RateTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePreferencesRequest
extends BcmPricingCalculatorRequest
implements ToCopyableBuilder<Builder, UpdatePreferencesRequest> {
    private static final SdkField<List<String>> MANAGEMENT_ACCOUNT_RATE_TYPE_SELECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managementAccountRateTypeSelections").getter(UpdatePreferencesRequest.getter(UpdatePreferencesRequest::managementAccountRateTypeSelectionsAsStrings)).setter(UpdatePreferencesRequest.setter(Builder::managementAccountRateTypeSelectionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managementAccountRateTypeSelections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MEMBER_ACCOUNT_RATE_TYPE_SELECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("memberAccountRateTypeSelections").getter(UpdatePreferencesRequest.getter(UpdatePreferencesRequest::memberAccountRateTypeSelectionsAsStrings)).setter(UpdatePreferencesRequest.setter(Builder::memberAccountRateTypeSelectionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountRateTypeSelections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGEMENT_ACCOUNT_RATE_TYPE_SELECTIONS_FIELD, MEMBER_ACCOUNT_RATE_TYPE_SELECTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePreferencesRequest.memberNameToFieldInitializer();
    private final List<String> managementAccountRateTypeSelections;
    private final List<String> memberAccountRateTypeSelections;

    private UpdatePreferencesRequest(BuilderImpl builder) {
        super(builder);
        this.managementAccountRateTypeSelections = builder.managementAccountRateTypeSelections;
        this.memberAccountRateTypeSelections = builder.memberAccountRateTypeSelections;
    }

    public final List<RateType> managementAccountRateTypeSelections() {
        return RateTypesCopier.copyStringToEnum(this.managementAccountRateTypeSelections);
    }

    public final boolean hasManagementAccountRateTypeSelections() {
        return this.managementAccountRateTypeSelections != null && !(this.managementAccountRateTypeSelections instanceof SdkAutoConstructList);
    }

    public final List<String> managementAccountRateTypeSelectionsAsStrings() {
        return this.managementAccountRateTypeSelections;
    }

    public final List<RateType> memberAccountRateTypeSelections() {
        return RateTypesCopier.copyStringToEnum(this.memberAccountRateTypeSelections);
    }

    public final boolean hasMemberAccountRateTypeSelections() {
        return this.memberAccountRateTypeSelections != null && !(this.memberAccountRateTypeSelections instanceof SdkAutoConstructList);
    }

    public final List<String> memberAccountRateTypeSelectionsAsStrings() {
        return this.memberAccountRateTypeSelections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagementAccountRateTypeSelections() ? this.managementAccountRateTypeSelectionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberAccountRateTypeSelections() ? this.memberAccountRateTypeSelectionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePreferencesRequest)) {
            return false;
        }
        UpdatePreferencesRequest other = (UpdatePreferencesRequest)((Object)obj);
        return this.hasManagementAccountRateTypeSelections() == other.hasManagementAccountRateTypeSelections() && Objects.equals(this.managementAccountRateTypeSelectionsAsStrings(), other.managementAccountRateTypeSelectionsAsStrings()) && this.hasMemberAccountRateTypeSelections() == other.hasMemberAccountRateTypeSelections() && Objects.equals(this.memberAccountRateTypeSelectionsAsStrings(), other.memberAccountRateTypeSelectionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePreferencesRequest").add("ManagementAccountRateTypeSelections", this.hasManagementAccountRateTypeSelections() ? this.managementAccountRateTypeSelectionsAsStrings() : null).add("MemberAccountRateTypeSelections", this.hasMemberAccountRateTypeSelections() ? this.memberAccountRateTypeSelectionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "managementAccountRateTypeSelections": {
                return Optional.ofNullable(clazz.cast(this.managementAccountRateTypeSelectionsAsStrings()));
            }
            case "memberAccountRateTypeSelections": {
                return Optional.ofNullable(clazz.cast(this.memberAccountRateTypeSelectionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("managementAccountRateTypeSelections", MANAGEMENT_ACCOUNT_RATE_TYPE_SELECTIONS_FIELD);
        map.put("memberAccountRateTypeSelections", MEMBER_ACCOUNT_RATE_TYPE_SELECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePreferencesRequest, T> g) {
        return obj -> g.apply((UpdatePreferencesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorRequest.BuilderImpl
    implements Builder {
        private List<String> managementAccountRateTypeSelections = DefaultSdkAutoConstructList.getInstance();
        private List<String> memberAccountRateTypeSelections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePreferencesRequest model) {
            super(model);
            this.managementAccountRateTypeSelectionsWithStrings(model.managementAccountRateTypeSelections);
            this.memberAccountRateTypeSelectionsWithStrings(model.memberAccountRateTypeSelections);
        }

        public final Collection<String> getManagementAccountRateTypeSelections() {
            if (this.managementAccountRateTypeSelections instanceof SdkAutoConstructList) {
                return null;
            }
            return this.managementAccountRateTypeSelections;
        }

        public final void setManagementAccountRateTypeSelections(Collection<String> managementAccountRateTypeSelections) {
            this.managementAccountRateTypeSelections = RateTypesCopier.copy(managementAccountRateTypeSelections);
        }

        @Override
        public final Builder managementAccountRateTypeSelectionsWithStrings(Collection<String> managementAccountRateTypeSelections) {
            this.managementAccountRateTypeSelections = RateTypesCopier.copy(managementAccountRateTypeSelections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managementAccountRateTypeSelectionsWithStrings(String ... managementAccountRateTypeSelections) {
            this.managementAccountRateTypeSelectionsWithStrings(Arrays.asList(managementAccountRateTypeSelections));
            return this;
        }

        @Override
        public final Builder managementAccountRateTypeSelections(Collection<RateType> managementAccountRateTypeSelections) {
            this.managementAccountRateTypeSelections = RateTypesCopier.copyEnumToString(managementAccountRateTypeSelections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managementAccountRateTypeSelections(RateType ... managementAccountRateTypeSelections) {
            this.managementAccountRateTypeSelections(Arrays.asList(managementAccountRateTypeSelections));
            return this;
        }

        public final Collection<String> getMemberAccountRateTypeSelections() {
            if (this.memberAccountRateTypeSelections instanceof SdkAutoConstructList) {
                return null;
            }
            return this.memberAccountRateTypeSelections;
        }

        public final void setMemberAccountRateTypeSelections(Collection<String> memberAccountRateTypeSelections) {
            this.memberAccountRateTypeSelections = RateTypesCopier.copy(memberAccountRateTypeSelections);
        }

        @Override
        public final Builder memberAccountRateTypeSelectionsWithStrings(Collection<String> memberAccountRateTypeSelections) {
            this.memberAccountRateTypeSelections = RateTypesCopier.copy(memberAccountRateTypeSelections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAccountRateTypeSelectionsWithStrings(String ... memberAccountRateTypeSelections) {
            this.memberAccountRateTypeSelectionsWithStrings(Arrays.asList(memberAccountRateTypeSelections));
            return this;
        }

        @Override
        public final Builder memberAccountRateTypeSelections(Collection<RateType> memberAccountRateTypeSelections) {
            this.memberAccountRateTypeSelections = RateTypesCopier.copyEnumToString(memberAccountRateTypeSelections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAccountRateTypeSelections(RateType ... memberAccountRateTypeSelections) {
            this.memberAccountRateTypeSelections(Arrays.asList(memberAccountRateTypeSelections));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePreferencesRequest build() {
            return new UpdatePreferencesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BcmPricingCalculatorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePreferencesRequest> {
        public Builder managementAccountRateTypeSelectionsWithStrings(Collection<String> var1);

        public Builder managementAccountRateTypeSelectionsWithStrings(String ... var1);

        public Builder managementAccountRateTypeSelections(Collection<RateType> var1);

        public Builder managementAccountRateTypeSelections(RateType ... var1);

        public Builder memberAccountRateTypeSelectionsWithStrings(Collection<String> var1);

        public Builder memberAccountRateTypeSelectionsWithStrings(String ... var1);

        public Builder memberAccountRateTypeSelections(Collection<RateType> var1);

        public Builder memberAccountRateTypeSelections(RateType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

