/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CurrencyCode;
import software.amazon.awssdk.services.bcmpricingcalculator.model.HistoricalUsageEntity;
import software.amazon.awssdk.services.bcmpricingcalculator.model.WorkloadEstimateCostStatus;
import software.amazon.awssdk.services.bcmpricingcalculator.model.WorkloadEstimateUsageQuantity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkloadEstimateUsageItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkloadEstimateUsageItem> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceCode").getter(WorkloadEstimateUsageItem.getter(WorkloadEstimateUsageItem::serviceCode)).setter(WorkloadEstimateUsageItem.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()}).build();
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageType").getter(WorkloadEstimateUsageItem.getter(WorkloadEstimateUsageItem::usageType)).setter(WorkloadEstimateUsageItem.setter(Builder::usageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operation").getter(WorkloadEstimateUsageItem.getter(WorkloadEstimateUsageItem::operation)).setter(WorkloadEstimateUsageItem.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(WorkloadEstimateUsageItem.getter(WorkloadEstimateUsageItem::location)).setter(WorkloadEstimateUsageItem.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(WorkloadEstimateUsageItem.getter(WorkloadEstimateUsageItem::id)).setter(WorkloadEstimateUsageItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> USAGE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageAccountId").getter(WorkloadEstimateUsageItem.getter(WorkloadEstimateUsageItem::usageAccountId)).setter(WorkloadEstimateUsageItem.setter(Builder::usageAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageAccountId").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("group").getter(WorkloadEstimateUsageItem.getter(WorkloadEstimateUsageItem::group)).setter(WorkloadEstimateUsageItem.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final SdkField<WorkloadEstimateUsageQuantity> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("quantity").getter(WorkloadEstimateUsageItem.getter(WorkloadEstimateUsageItem::quantity)).setter(WorkloadEstimateUsageItem.setter(Builder::quantity)).constructor(WorkloadEstimateUsageQuantity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantity").build()}).build();
    private static final SdkField<Double> COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("cost").getter(WorkloadEstimateUsageItem.getter(WorkloadEstimateUsageItem::cost)).setter(WorkloadEstimateUsageItem.setter(Builder::cost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cost").build()}).build();
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currency").getter(WorkloadEstimateUsageItem.getter(WorkloadEstimateUsageItem::currencyAsString)).setter(WorkloadEstimateUsageItem.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(WorkloadEstimateUsageItem.getter(WorkloadEstimateUsageItem::statusAsString)).setter(WorkloadEstimateUsageItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<HistoricalUsageEntity> HISTORICAL_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("historicalUsage").getter(WorkloadEstimateUsageItem.getter(WorkloadEstimateUsageItem::historicalUsage)).setter(WorkloadEstimateUsageItem.setter(Builder::historicalUsage)).constructor(HistoricalUsageEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("historicalUsage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD, USAGE_TYPE_FIELD, OPERATION_FIELD, LOCATION_FIELD, ID_FIELD, USAGE_ACCOUNT_ID_FIELD, GROUP_FIELD, QUANTITY_FIELD, COST_FIELD, CURRENCY_FIELD, STATUS_FIELD, HISTORICAL_USAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkloadEstimateUsageItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceCode;
    private final String usageType;
    private final String operation;
    private final String location;
    private final String id;
    private final String usageAccountId;
    private final String group;
    private final WorkloadEstimateUsageQuantity quantity;
    private final Double cost;
    private final String currency;
    private final String status;
    private final HistoricalUsageEntity historicalUsage;

    private WorkloadEstimateUsageItem(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
        this.location = builder.location;
        this.id = builder.id;
        this.usageAccountId = builder.usageAccountId;
        this.group = builder.group;
        this.quantity = builder.quantity;
        this.cost = builder.cost;
        this.currency = builder.currency;
        this.status = builder.status;
        this.historicalUsage = builder.historicalUsage;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final String usageType() {
        return this.usageType;
    }

    public final String operation() {
        return this.operation;
    }

    public final String location() {
        return this.location;
    }

    public final String id() {
        return this.id;
    }

    public final String usageAccountId() {
        return this.usageAccountId;
    }

    public final String group() {
        return this.group;
    }

    public final WorkloadEstimateUsageQuantity quantity() {
        return this.quantity;
    }

    public final Double cost() {
        return this.cost;
    }

    public final CurrencyCode currency() {
        return CurrencyCode.fromValue(this.currency);
    }

    public final String currencyAsString() {
        return this.currency;
    }

    public final WorkloadEstimateCostStatus status() {
        return WorkloadEstimateCostStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final HistoricalUsageEntity historicalUsage() {
        return this.historicalUsage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.cost());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.historicalUsage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadEstimateUsageItem)) {
            return false;
        }
        WorkloadEstimateUsageItem other = (WorkloadEstimateUsageItem)obj;
        return Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.usageType(), other.usageType()) && Objects.equals(this.operation(), other.operation()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.usageAccountId(), other.usageAccountId()) && Objects.equals(this.group(), other.group()) && Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.cost(), other.cost()) && Objects.equals(this.currencyAsString(), other.currencyAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.historicalUsage(), other.historicalUsage());
    }

    public final String toString() {
        return ToString.builder((String)"WorkloadEstimateUsageItem").add("ServiceCode", (Object)this.serviceCode()).add("UsageType", (Object)this.usageType()).add("Operation", (Object)this.operation()).add("Location", (Object)this.location()).add("Id", (Object)this.id()).add("UsageAccountId", (Object)this.usageAccountId()).add("Group", (Object)this.group()).add("Quantity", (Object)this.quantity()).add("Cost", (Object)this.cost()).add("Currency", (Object)this.currencyAsString()).add("Status", (Object)this.statusAsString()).add("HistoricalUsage", (Object)this.historicalUsage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "usageType": {
                return Optional.ofNullable(clazz.cast(this.usageType()));
            }
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "usageAccountId": {
                return Optional.ofNullable(clazz.cast(this.usageAccountId()));
            }
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "cost": {
                return Optional.ofNullable(clazz.cast(this.cost()));
            }
            case "currency": {
                return Optional.ofNullable(clazz.cast(this.currencyAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "historicalUsage": {
                return Optional.ofNullable(clazz.cast(this.historicalUsage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceCode", SERVICE_CODE_FIELD);
        map.put("usageType", USAGE_TYPE_FIELD);
        map.put("operation", OPERATION_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("id", ID_FIELD);
        map.put("usageAccountId", USAGE_ACCOUNT_ID_FIELD);
        map.put("group", GROUP_FIELD);
        map.put("quantity", QUANTITY_FIELD);
        map.put("cost", COST_FIELD);
        map.put("currency", CURRENCY_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("historicalUsage", HISTORICAL_USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkloadEstimateUsageItem, T> g) {
        return obj -> g.apply((WorkloadEstimateUsageItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceCode;
        private String usageType;
        private String operation;
        private String location;
        private String id;
        private String usageAccountId;
        private String group;
        private WorkloadEstimateUsageQuantity quantity;
        private Double cost;
        private String currency;
        private String status;
        private HistoricalUsageEntity historicalUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadEstimateUsageItem model) {
            this.serviceCode(model.serviceCode);
            this.usageType(model.usageType);
            this.operation(model.operation);
            this.location(model.location);
            this.id(model.id);
            this.usageAccountId(model.usageAccountId);
            this.group(model.group);
            this.quantity(model.quantity);
            this.cost(model.cost);
            this.currency(model.currency);
            this.status(model.status);
            this.historicalUsage(model.historicalUsage);
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getUsageType() {
            return this.usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getUsageAccountId() {
            return this.usageAccountId;
        }

        public final void setUsageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
        }

        @Override
        public final Builder usageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
            return this;
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final WorkloadEstimateUsageQuantity.Builder getQuantity() {
            return this.quantity != null ? this.quantity.toBuilder() : null;
        }

        public final void setQuantity(WorkloadEstimateUsageQuantity.BuilderImpl quantity) {
            this.quantity = quantity != null ? quantity.build() : null;
        }

        @Override
        public final Builder quantity(WorkloadEstimateUsageQuantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public final Double getCost() {
            return this.cost;
        }

        public final void setCost(Double cost) {
            this.cost = cost;
        }

        @Override
        public final Builder cost(Double cost) {
            this.cost = cost;
            return this;
        }

        public final String getCurrency() {
            return this.currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(CurrencyCode currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkloadEstimateCostStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final HistoricalUsageEntity.Builder getHistoricalUsage() {
            return this.historicalUsage != null ? this.historicalUsage.toBuilder() : null;
        }

        public final void setHistoricalUsage(HistoricalUsageEntity.BuilderImpl historicalUsage) {
            this.historicalUsage = historicalUsage != null ? historicalUsage.build() : null;
        }

        @Override
        public final Builder historicalUsage(HistoricalUsageEntity historicalUsage) {
            this.historicalUsage = historicalUsage;
            return this;
        }

        public WorkloadEstimateUsageItem build() {
            return new WorkloadEstimateUsageItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkloadEstimateUsageItem> {
        public Builder serviceCode(String var1);

        public Builder usageType(String var1);

        public Builder operation(String var1);

        public Builder location(String var1);

        public Builder id(String var1);

        public Builder usageAccountId(String var1);

        public Builder group(String var1);

        public Builder quantity(WorkloadEstimateUsageQuantity var1);

        default public Builder quantity(Consumer<WorkloadEstimateUsageQuantity.Builder> quantity) {
            return this.quantity((WorkloadEstimateUsageQuantity)((WorkloadEstimateUsageQuantity.Builder)WorkloadEstimateUsageQuantity.builder().applyMutation(quantity)).build());
        }

        public Builder cost(Double var1);

        public Builder currency(String var1);

        public Builder currency(CurrencyCode var1);

        public Builder status(String var1);

        public Builder status(WorkloadEstimateCostStatus var1);

        public Builder historicalUsage(HistoricalUsageEntity var1);

        default public Builder historicalUsage(Consumer<HistoricalUsageEntity.Builder> historicalUsage) {
            return this.historicalUsage((HistoricalUsageEntity)((HistoricalUsageEntity.Builder)HistoricalUsageEntity.builder().applyMutation(historicalUsage)).build());
        }
    }
}

