/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CostAmount;
import software.amazon.awssdk.services.bcmpricingcalculator.model.SavingsPlanArnsCopier;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UsageQuantityResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BillEstimateLineItemSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BillEstimateLineItemSummary> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceCode").getter(BillEstimateLineItemSummary.getter(BillEstimateLineItemSummary::serviceCode)).setter(BillEstimateLineItemSummary.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()}).build();
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageType").getter(BillEstimateLineItemSummary.getter(BillEstimateLineItemSummary::usageType)).setter(BillEstimateLineItemSummary.setter(Builder::usageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operation").getter(BillEstimateLineItemSummary.getter(BillEstimateLineItemSummary::operation)).setter(BillEstimateLineItemSummary.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(BillEstimateLineItemSummary.getter(BillEstimateLineItemSummary::location)).setter(BillEstimateLineItemSummary.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(BillEstimateLineItemSummary.getter(BillEstimateLineItemSummary::availabilityZone)).setter(BillEstimateLineItemSummary.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(BillEstimateLineItemSummary.getter(BillEstimateLineItemSummary::id)).setter(BillEstimateLineItemSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> LINE_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lineItemId").getter(BillEstimateLineItemSummary.getter(BillEstimateLineItemSummary::lineItemId)).setter(BillEstimateLineItemSummary.setter(Builder::lineItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineItemId").build()}).build();
    private static final SdkField<String> LINE_ITEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lineItemType").getter(BillEstimateLineItemSummary.getter(BillEstimateLineItemSummary::lineItemType)).setter(BillEstimateLineItemSummary.setter(Builder::lineItemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineItemType").build()}).build();
    private static final SdkField<String> PAYER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("payerAccountId").getter(BillEstimateLineItemSummary.getter(BillEstimateLineItemSummary::payerAccountId)).setter(BillEstimateLineItemSummary.setter(Builder::payerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payerAccountId").build()}).build();
    private static final SdkField<String> USAGE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageAccountId").getter(BillEstimateLineItemSummary.getter(BillEstimateLineItemSummary::usageAccountId)).setter(BillEstimateLineItemSummary.setter(Builder::usageAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageAccountId").build()}).build();
    private static final SdkField<UsageQuantityResult> ESTIMATED_USAGE_QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("estimatedUsageQuantity").getter(BillEstimateLineItemSummary.getter(BillEstimateLineItemSummary::estimatedUsageQuantity)).setter(BillEstimateLineItemSummary.setter(Builder::estimatedUsageQuantity)).constructor(UsageQuantityResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedUsageQuantity").build()}).build();
    private static final SdkField<CostAmount> ESTIMATED_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("estimatedCost").getter(BillEstimateLineItemSummary.getter(BillEstimateLineItemSummary::estimatedCost)).setter(BillEstimateLineItemSummary.setter(Builder::estimatedCost)).constructor(CostAmount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedCost").build()}).build();
    private static final SdkField<UsageQuantityResult> HISTORICAL_USAGE_QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("historicalUsageQuantity").getter(BillEstimateLineItemSummary.getter(BillEstimateLineItemSummary::historicalUsageQuantity)).setter(BillEstimateLineItemSummary.setter(Builder::historicalUsageQuantity)).constructor(UsageQuantityResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("historicalUsageQuantity").build()}).build();
    private static final SdkField<CostAmount> HISTORICAL_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("historicalCost").getter(BillEstimateLineItemSummary.getter(BillEstimateLineItemSummary::historicalCost)).setter(BillEstimateLineItemSummary.setter(Builder::historicalCost)).constructor(CostAmount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("historicalCost").build()}).build();
    private static final SdkField<List<String>> SAVINGS_PLAN_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("savingsPlanArns").getter(BillEstimateLineItemSummary.getter(BillEstimateLineItemSummary::savingsPlanArns)).setter(BillEstimateLineItemSummary.setter(Builder::savingsPlanArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD, USAGE_TYPE_FIELD, OPERATION_FIELD, LOCATION_FIELD, AVAILABILITY_ZONE_FIELD, ID_FIELD, LINE_ITEM_ID_FIELD, LINE_ITEM_TYPE_FIELD, PAYER_ACCOUNT_ID_FIELD, USAGE_ACCOUNT_ID_FIELD, ESTIMATED_USAGE_QUANTITY_FIELD, ESTIMATED_COST_FIELD, HISTORICAL_USAGE_QUANTITY_FIELD, HISTORICAL_COST_FIELD, SAVINGS_PLAN_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BillEstimateLineItemSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceCode;
    private final String usageType;
    private final String operation;
    private final String location;
    private final String availabilityZone;
    private final String id;
    private final String lineItemId;
    private final String lineItemType;
    private final String payerAccountId;
    private final String usageAccountId;
    private final UsageQuantityResult estimatedUsageQuantity;
    private final CostAmount estimatedCost;
    private final UsageQuantityResult historicalUsageQuantity;
    private final CostAmount historicalCost;
    private final List<String> savingsPlanArns;

    private BillEstimateLineItemSummary(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
        this.location = builder.location;
        this.availabilityZone = builder.availabilityZone;
        this.id = builder.id;
        this.lineItemId = builder.lineItemId;
        this.lineItemType = builder.lineItemType;
        this.payerAccountId = builder.payerAccountId;
        this.usageAccountId = builder.usageAccountId;
        this.estimatedUsageQuantity = builder.estimatedUsageQuantity;
        this.estimatedCost = builder.estimatedCost;
        this.historicalUsageQuantity = builder.historicalUsageQuantity;
        this.historicalCost = builder.historicalCost;
        this.savingsPlanArns = builder.savingsPlanArns;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final String usageType() {
        return this.usageType;
    }

    public final String operation() {
        return this.operation;
    }

    public final String location() {
        return this.location;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String id() {
        return this.id;
    }

    public final String lineItemId() {
        return this.lineItemId;
    }

    public final String lineItemType() {
        return this.lineItemType;
    }

    public final String payerAccountId() {
        return this.payerAccountId;
    }

    public final String usageAccountId() {
        return this.usageAccountId;
    }

    public final UsageQuantityResult estimatedUsageQuantity() {
        return this.estimatedUsageQuantity;
    }

    public final CostAmount estimatedCost() {
        return this.estimatedCost;
    }

    public final UsageQuantityResult historicalUsageQuantity() {
        return this.historicalUsageQuantity;
    }

    public final CostAmount historicalCost() {
        return this.historicalCost;
    }

    public final boolean hasSavingsPlanArns() {
        return this.savingsPlanArns != null && !(this.savingsPlanArns instanceof SdkAutoConstructList);
    }

    public final List<String> savingsPlanArns() {
        return this.savingsPlanArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineItemType());
        hashCode = 31 * hashCode + Objects.hashCode(this.payerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedUsageQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.historicalUsageQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.historicalCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSavingsPlanArns() ? this.savingsPlanArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillEstimateLineItemSummary)) {
            return false;
        }
        BillEstimateLineItemSummary other = (BillEstimateLineItemSummary)obj;
        return Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.usageType(), other.usageType()) && Objects.equals(this.operation(), other.operation()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lineItemId(), other.lineItemId()) && Objects.equals(this.lineItemType(), other.lineItemType()) && Objects.equals(this.payerAccountId(), other.payerAccountId()) && Objects.equals(this.usageAccountId(), other.usageAccountId()) && Objects.equals(this.estimatedUsageQuantity(), other.estimatedUsageQuantity()) && Objects.equals(this.estimatedCost(), other.estimatedCost()) && Objects.equals(this.historicalUsageQuantity(), other.historicalUsageQuantity()) && Objects.equals(this.historicalCost(), other.historicalCost()) && this.hasSavingsPlanArns() == other.hasSavingsPlanArns() && Objects.equals(this.savingsPlanArns(), other.savingsPlanArns());
    }

    public final String toString() {
        return ToString.builder((String)"BillEstimateLineItemSummary").add("ServiceCode", (Object)this.serviceCode()).add("UsageType", (Object)this.usageType()).add("Operation", (Object)this.operation()).add("Location", (Object)this.location()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Id", (Object)this.id()).add("LineItemId", (Object)this.lineItemId()).add("LineItemType", (Object)this.lineItemType()).add("PayerAccountId", (Object)this.payerAccountId()).add("UsageAccountId", (Object)this.usageAccountId()).add("EstimatedUsageQuantity", (Object)this.estimatedUsageQuantity()).add("EstimatedCost", (Object)this.estimatedCost()).add("HistoricalUsageQuantity", (Object)this.historicalUsageQuantity()).add("HistoricalCost", (Object)this.historicalCost()).add("SavingsPlanArns", this.hasSavingsPlanArns() ? this.savingsPlanArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "usageType": {
                return Optional.ofNullable(clazz.cast(this.usageType()));
            }
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lineItemId": {
                return Optional.ofNullable(clazz.cast(this.lineItemId()));
            }
            case "lineItemType": {
                return Optional.ofNullable(clazz.cast(this.lineItemType()));
            }
            case "payerAccountId": {
                return Optional.ofNullable(clazz.cast(this.payerAccountId()));
            }
            case "usageAccountId": {
                return Optional.ofNullable(clazz.cast(this.usageAccountId()));
            }
            case "estimatedUsageQuantity": {
                return Optional.ofNullable(clazz.cast(this.estimatedUsageQuantity()));
            }
            case "estimatedCost": {
                return Optional.ofNullable(clazz.cast(this.estimatedCost()));
            }
            case "historicalUsageQuantity": {
                return Optional.ofNullable(clazz.cast(this.historicalUsageQuantity()));
            }
            case "historicalCost": {
                return Optional.ofNullable(clazz.cast(this.historicalCost()));
            }
            case "savingsPlanArns": {
                return Optional.ofNullable(clazz.cast(this.savingsPlanArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceCode", SERVICE_CODE_FIELD);
        map.put("usageType", USAGE_TYPE_FIELD);
        map.put("operation", OPERATION_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("id", ID_FIELD);
        map.put("lineItemId", LINE_ITEM_ID_FIELD);
        map.put("lineItemType", LINE_ITEM_TYPE_FIELD);
        map.put("payerAccountId", PAYER_ACCOUNT_ID_FIELD);
        map.put("usageAccountId", USAGE_ACCOUNT_ID_FIELD);
        map.put("estimatedUsageQuantity", ESTIMATED_USAGE_QUANTITY_FIELD);
        map.put("estimatedCost", ESTIMATED_COST_FIELD);
        map.put("historicalUsageQuantity", HISTORICAL_USAGE_QUANTITY_FIELD);
        map.put("historicalCost", HISTORICAL_COST_FIELD);
        map.put("savingsPlanArns", SAVINGS_PLAN_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillEstimateLineItemSummary, T> g) {
        return obj -> g.apply((BillEstimateLineItemSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceCode;
        private String usageType;
        private String operation;
        private String location;
        private String availabilityZone;
        private String id;
        private String lineItemId;
        private String lineItemType;
        private String payerAccountId;
        private String usageAccountId;
        private UsageQuantityResult estimatedUsageQuantity;
        private CostAmount estimatedCost;
        private UsageQuantityResult historicalUsageQuantity;
        private CostAmount historicalCost;
        private List<String> savingsPlanArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BillEstimateLineItemSummary model) {
            this.serviceCode(model.serviceCode);
            this.usageType(model.usageType);
            this.operation(model.operation);
            this.location(model.location);
            this.availabilityZone(model.availabilityZone);
            this.id(model.id);
            this.lineItemId(model.lineItemId);
            this.lineItemType(model.lineItemType);
            this.payerAccountId(model.payerAccountId);
            this.usageAccountId(model.usageAccountId);
            this.estimatedUsageQuantity(model.estimatedUsageQuantity);
            this.estimatedCost(model.estimatedCost);
            this.historicalUsageQuantity(model.historicalUsageQuantity);
            this.historicalCost(model.historicalCost);
            this.savingsPlanArns(model.savingsPlanArns);
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getUsageType() {
            return this.usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLineItemId() {
            return this.lineItemId;
        }

        public final void setLineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
        }

        @Override
        public final Builder lineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
            return this;
        }

        public final String getLineItemType() {
            return this.lineItemType;
        }

        public final void setLineItemType(String lineItemType) {
            this.lineItemType = lineItemType;
        }

        @Override
        public final Builder lineItemType(String lineItemType) {
            this.lineItemType = lineItemType;
            return this;
        }

        public final String getPayerAccountId() {
            return this.payerAccountId;
        }

        public final void setPayerAccountId(String payerAccountId) {
            this.payerAccountId = payerAccountId;
        }

        @Override
        public final Builder payerAccountId(String payerAccountId) {
            this.payerAccountId = payerAccountId;
            return this;
        }

        public final String getUsageAccountId() {
            return this.usageAccountId;
        }

        public final void setUsageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
        }

        @Override
        public final Builder usageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
            return this;
        }

        public final UsageQuantityResult.Builder getEstimatedUsageQuantity() {
            return this.estimatedUsageQuantity != null ? this.estimatedUsageQuantity.toBuilder() : null;
        }

        public final void setEstimatedUsageQuantity(UsageQuantityResult.BuilderImpl estimatedUsageQuantity) {
            this.estimatedUsageQuantity = estimatedUsageQuantity != null ? estimatedUsageQuantity.build() : null;
        }

        @Override
        public final Builder estimatedUsageQuantity(UsageQuantityResult estimatedUsageQuantity) {
            this.estimatedUsageQuantity = estimatedUsageQuantity;
            return this;
        }

        public final CostAmount.Builder getEstimatedCost() {
            return this.estimatedCost != null ? this.estimatedCost.toBuilder() : null;
        }

        public final void setEstimatedCost(CostAmount.BuilderImpl estimatedCost) {
            this.estimatedCost = estimatedCost != null ? estimatedCost.build() : null;
        }

        @Override
        public final Builder estimatedCost(CostAmount estimatedCost) {
            this.estimatedCost = estimatedCost;
            return this;
        }

        public final UsageQuantityResult.Builder getHistoricalUsageQuantity() {
            return this.historicalUsageQuantity != null ? this.historicalUsageQuantity.toBuilder() : null;
        }

        public final void setHistoricalUsageQuantity(UsageQuantityResult.BuilderImpl historicalUsageQuantity) {
            this.historicalUsageQuantity = historicalUsageQuantity != null ? historicalUsageQuantity.build() : null;
        }

        @Override
        public final Builder historicalUsageQuantity(UsageQuantityResult historicalUsageQuantity) {
            this.historicalUsageQuantity = historicalUsageQuantity;
            return this;
        }

        public final CostAmount.Builder getHistoricalCost() {
            return this.historicalCost != null ? this.historicalCost.toBuilder() : null;
        }

        public final void setHistoricalCost(CostAmount.BuilderImpl historicalCost) {
            this.historicalCost = historicalCost != null ? historicalCost.build() : null;
        }

        @Override
        public final Builder historicalCost(CostAmount historicalCost) {
            this.historicalCost = historicalCost;
            return this;
        }

        public final Collection<String> getSavingsPlanArns() {
            if (this.savingsPlanArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.savingsPlanArns;
        }

        public final void setSavingsPlanArns(Collection<String> savingsPlanArns) {
            this.savingsPlanArns = SavingsPlanArnsCopier.copy(savingsPlanArns);
        }

        @Override
        public final Builder savingsPlanArns(Collection<String> savingsPlanArns) {
            this.savingsPlanArns = SavingsPlanArnsCopier.copy(savingsPlanArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanArns(String ... savingsPlanArns) {
            this.savingsPlanArns(Arrays.asList(savingsPlanArns));
            return this;
        }

        public BillEstimateLineItemSummary build() {
            return new BillEstimateLineItemSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BillEstimateLineItemSummary> {
        public Builder serviceCode(String var1);

        public Builder usageType(String var1);

        public Builder operation(String var1);

        public Builder location(String var1);

        public Builder availabilityZone(String var1);

        public Builder id(String var1);

        public Builder lineItemId(String var1);

        public Builder lineItemType(String var1);

        public Builder payerAccountId(String var1);

        public Builder usageAccountId(String var1);

        public Builder estimatedUsageQuantity(UsageQuantityResult var1);

        default public Builder estimatedUsageQuantity(Consumer<UsageQuantityResult.Builder> estimatedUsageQuantity) {
            return this.estimatedUsageQuantity((UsageQuantityResult)((UsageQuantityResult.Builder)UsageQuantityResult.builder().applyMutation(estimatedUsageQuantity)).build());
        }

        public Builder estimatedCost(CostAmount var1);

        default public Builder estimatedCost(Consumer<CostAmount.Builder> estimatedCost) {
            return this.estimatedCost((CostAmount)((CostAmount.Builder)CostAmount.builder().applyMutation(estimatedCost)).build());
        }

        public Builder historicalUsageQuantity(UsageQuantityResult var1);

        default public Builder historicalUsageQuantity(Consumer<UsageQuantityResult.Builder> historicalUsageQuantity) {
            return this.historicalUsageQuantity((UsageQuantityResult)((UsageQuantityResult.Builder)UsageQuantityResult.builder().applyMutation(historicalUsageQuantity)).build());
        }

        public Builder historicalCost(CostAmount var1);

        default public Builder historicalCost(Consumer<CostAmount.Builder> historicalCost) {
            return this.historicalCost((CostAmount)((CostAmount.Builder)CostAmount.builder().applyMutation(historicalCost)).build());
        }

        public Builder savingsPlanArns(Collection<String> var1);

        public Builder savingsPlanArns(String ... var1);
    }
}

