/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a usage quantity for a workload estimate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkloadEstimateUsageQuantity implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkloadEstimateUsageQuantity.Builder, WorkloadEstimateUsageQuantity> {
    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(WorkloadEstimateUsageQuantity::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<Double> AMOUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("amount")
            .getter(getter(WorkloadEstimateUsageQuantity::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIT_FIELD, AMOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String unit;

    private final Double amount;

    private WorkloadEstimateUsageQuantity(BuilderImpl builder) {
        this.unit = builder.unit;
        this.amount = builder.amount;
    }

    /**
     * <p>
     * The unit of measurement for the usage quantity.
     * </p>
     * 
     * @return The unit of measurement for the usage quantity.
     */
    public final String unit() {
        return unit;
    }

    /**
     * <p>
     * The numeric value of the usage quantity.
     * </p>
     * 
     * @return The numeric value of the usage quantity.
     */
    public final Double amount() {
        return amount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadEstimateUsageQuantity)) {
            return false;
        }
        WorkloadEstimateUsageQuantity other = (WorkloadEstimateUsageQuantity) obj;
        return Objects.equals(unit(), other.unit()) && Objects.equals(amount(), other.amount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkloadEstimateUsageQuantity").add("Unit", unit()).add("Amount", amount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "amount":
            return Optional.ofNullable(clazz.cast(amount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("unit", UNIT_FIELD);
        map.put("amount", AMOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkloadEstimateUsageQuantity, T> g) {
        return obj -> g.apply((WorkloadEstimateUsageQuantity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkloadEstimateUsageQuantity> {
        /**
         * <p>
         * The unit of measurement for the usage quantity.
         * </p>
         * 
         * @param unit
         *        The unit of measurement for the usage quantity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * The numeric value of the usage quantity.
         * </p>
         * 
         * @param amount
         *        The numeric value of the usage quantity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Double amount);
    }

    static final class BuilderImpl implements Builder {
        private String unit;

        private Double amount;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadEstimateUsageQuantity model) {
            unit(model.unit);
            amount(model.amount);
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final Double getAmount() {
            return amount;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        @Override
        public WorkloadEstimateUsageQuantity build() {
            return new WorkloadEstimateUsageQuantity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
