/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmrecommendedactions.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ActionType {
    ADD_ALTERNATE_BILLING_CONTACT("ADD_ALTERNATE_BILLING_CONTACT"),

    CREATE_ANOMALY_MONITOR("CREATE_ANOMALY_MONITOR"),

    CREATE_BUDGET("CREATE_BUDGET"),

    ENABLE_COST_OPTIMIZATION_HUB("ENABLE_COST_OPTIMIZATION_HUB"),

    MIGRATE_TO_GRANULAR_PERMISSIONS("MIGRATE_TO_GRANULAR_PERMISSIONS"),

    PAYMENTS_DUE("PAYMENTS_DUE"),

    PAYMENTS_PAST_DUE("PAYMENTS_PAST_DUE"),

    REVIEW_ANOMALIES("REVIEW_ANOMALIES"),

    REVIEW_BUDGET_ALERTS("REVIEW_BUDGET_ALERTS"),

    REVIEW_BUDGETS_EXCEEDED("REVIEW_BUDGETS_EXCEEDED"),

    REVIEW_EXPIRING_RI("REVIEW_EXPIRING_RI"),

    REVIEW_EXPIRING_SP("REVIEW_EXPIRING_SP"),

    REVIEW_FREETIER_USAGE_ALERTS("REVIEW_FREETIER_USAGE_ALERTS"),

    REVIEW_SAVINGS_OPPORTUNITY_RECOMMENDATIONS("REVIEW_SAVINGS_OPPORTUNITY_RECOMMENDATIONS"),

    UPDATE_EXPIRED_PAYMENT_METHOD("UPDATE_EXPIRED_PAYMENT_METHOD"),

    UPDATE_INVALID_PAYMENT_METHOD("UPDATE_INVALID_PAYMENT_METHOD"),

    UPDATE_TAX_EXEMPTION_CERTIFICATE("UPDATE_TAX_EXEMPTION_CERTIFICATE"),

    UPDATE_TAX_REGISTRATION_NUMBER("UPDATE_TAX_REGISTRATION_NUMBER"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionType> VALUE_MAP = EnumUtils.uniqueIndex(ActionType.class, ActionType::toString);

    private final String value;

    private ActionType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ActionType corresponding to the value
     */
    public static ActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ActionType}s
     */
    public static Set<ActionType> knownValues() {
        Set<ActionType> knownValues = EnumSet.allOf(ActionType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
