/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmrecommendedactions.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Feature {
    ACCOUNT("ACCOUNT"),
    BUDGETS("BUDGETS"),
    COST_ANOMALY_DETECTION("COST_ANOMALY_DETECTION"),
    COST_OPTIMIZATION_HUB("COST_OPTIMIZATION_HUB"),
    FREE_TIER("FREE_TIER"),
    IAM("IAM"),
    PAYMENTS("PAYMENTS"),
    RESERVATIONS("RESERVATIONS"),
    SAVINGS_PLANS("SAVINGS_PLANS"),
    TAX_SETTINGS("TAX_SETTINGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Feature> VALUE_MAP;
    private final String value;

    private Feature(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Feature fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Feature> knownValues() {
        EnumSet<Feature> knownValues = EnumSet.allOf(Feature.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Feature.class, Feature::toString);
    }
}

