/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmrecommendedactions;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest;
import software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsResponse;
import software.amazon.awssdk.services.bcmrecommendedactions.paginators.ListRecommendedActionsPublisher;

/**
 * Service client for accessing AWS Billing and Cost Management Recommended Actions asynchronously. This can be created
 * using the static {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * You can use the Billing and Cost Management Recommended Actions API to programmatically query your best practices and
 * recommendations to optimize your costs.
 * </p>
 * <p>
 * The Billing and Cost Management Recommended Actions API provides the following endpoint:
 * </p>
 * <ul>
 * <li>
 * <p>
 * https://bcm-recommended-actions.us-east-1.api.aws
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BcmRecommendedActionsAsyncClient extends AwsClient {
    String SERVICE_NAME = "bcm-recommended-actions";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bcm-recommended-actions";

    /**
     * <p>
     * Returns a list of recommended actions that match the filter criteria.
     * </p>
     *
     * @param listRecommendedActionsRequest
     * @return A Java Future containing the result of the ListRecommendedActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of your request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmRecommendedActionsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmRecommendedActionsAsyncClient.ListRecommendedActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-recommended-actions-2024-11-14/ListRecommendedActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecommendedActionsResponse> listRecommendedActions(
            ListRecommendedActionsRequest listRecommendedActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of recommended actions that match the filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendedActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendedActionsRequest#builder()}
     * </p>
     *
     * @param listRecommendedActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListRecommendedActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of your request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmRecommendedActionsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmRecommendedActionsAsyncClient.ListRecommendedActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-recommended-actions-2024-11-14/ListRecommendedActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecommendedActionsResponse> listRecommendedActions(
            Consumer<ListRecommendedActionsRequest.Builder> listRecommendedActionsRequest) {
        return listRecommendedActions(ListRecommendedActionsRequest.builder().applyMutation(listRecommendedActionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendedActions(software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmrecommendedactions.paginators.ListRecommendedActionsPublisher publisher = client.listRecommendedActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmrecommendedactions.paginators.ListRecommendedActionsPublisher publisher = client.listRecommendedActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendedActions(software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendedActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of your request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmRecommendedActionsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmRecommendedActionsAsyncClient.ListRecommendedActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-recommended-actions-2024-11-14/ListRecommendedActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendedActionsPublisher listRecommendedActionsPaginator(
            ListRecommendedActionsRequest listRecommendedActionsRequest) {
        return new ListRecommendedActionsPublisher(this, listRecommendedActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendedActions(software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmrecommendedactions.paginators.ListRecommendedActionsPublisher publisher = client.listRecommendedActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmrecommendedactions.paginators.ListRecommendedActionsPublisher publisher = client.listRecommendedActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendedActions(software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendedActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendedActionsRequest#builder()}
     * </p>
     *
     * @param listRecommendedActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of your request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmRecommendedActionsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmRecommendedActionsAsyncClient.ListRecommendedActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-recommended-actions-2024-11-14/ListRecommendedActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendedActionsPublisher listRecommendedActionsPaginator(
            Consumer<ListRecommendedActionsRequest.Builder> listRecommendedActionsRequest) {
        return listRecommendedActionsPaginator(ListRecommendedActionsRequest.builder()
                .applyMutation(listRecommendedActionsRequest).build());
    }

    @Override
    default BcmRecommendedActionsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BcmRecommendedActionsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BcmRecommendedActionsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BcmRecommendedActionsAsyncClient}.
     */
    static BcmRecommendedActionsAsyncClientBuilder builder() {
        return new DefaultBcmRecommendedActionsAsyncClientBuilder();
    }
}
