/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFoundationModelsRequest extends BedrockRequest implements
        ToCopyableBuilder<ListFoundationModelsRequest.Builder, ListFoundationModelsRequest> {
    private static final SdkField<String> BY_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("byProvider").getter(getter(ListFoundationModelsRequest::byProvider)).setter(setter(Builder::byProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("byProvider").build()).build();

    private static final SdkField<String> BY_CUSTOMIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("byCustomizationType").getter(getter(ListFoundationModelsRequest::byCustomizationTypeAsString))
            .setter(setter(Builder::byCustomizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("byCustomizationType").build())
            .build();

    private static final SdkField<String> BY_OUTPUT_MODALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("byOutputModality").getter(getter(ListFoundationModelsRequest::byOutputModalityAsString))
            .setter(setter(Builder::byOutputModality))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("byOutputModality").build())
            .build();

    private static final SdkField<String> BY_INFERENCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("byInferenceType").getter(getter(ListFoundationModelsRequest::byInferenceTypeAsString))
            .setter(setter(Builder::byInferenceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("byInferenceType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BY_PROVIDER_FIELD,
            BY_CUSTOMIZATION_TYPE_FIELD, BY_OUTPUT_MODALITY_FIELD, BY_INFERENCE_TYPE_FIELD));

    private final String byProvider;

    private final String byCustomizationType;

    private final String byOutputModality;

    private final String byInferenceType;

    private ListFoundationModelsRequest(BuilderImpl builder) {
        super(builder);
        this.byProvider = builder.byProvider;
        this.byCustomizationType = builder.byCustomizationType;
        this.byOutputModality = builder.byOutputModality;
        this.byInferenceType = builder.byInferenceType;
    }

    /**
     * <p>
     * A Amazon Bedrock model provider.
     * </p>
     * 
     * @return A Amazon Bedrock model provider.
     */
    public final String byProvider() {
        return byProvider;
    }

    /**
     * <p>
     * List by customization type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #byCustomizationType} will return {@link ModelCustomization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #byCustomizationTypeAsString}.
     * </p>
     * 
     * @return List by customization type.
     * @see ModelCustomization
     */
    public final ModelCustomization byCustomizationType() {
        return ModelCustomization.fromValue(byCustomizationType);
    }

    /**
     * <p>
     * List by customization type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #byCustomizationType} will return {@link ModelCustomization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #byCustomizationTypeAsString}.
     * </p>
     * 
     * @return List by customization type.
     * @see ModelCustomization
     */
    public final String byCustomizationTypeAsString() {
        return byCustomizationType;
    }

    /**
     * <p>
     * List by output modality type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byOutputModality}
     * will return {@link ModelModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byOutputModalityAsString}.
     * </p>
     * 
     * @return List by output modality type.
     * @see ModelModality
     */
    public final ModelModality byOutputModality() {
        return ModelModality.fromValue(byOutputModality);
    }

    /**
     * <p>
     * List by output modality type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byOutputModality}
     * will return {@link ModelModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byOutputModalityAsString}.
     * </p>
     * 
     * @return List by output modality type.
     * @see ModelModality
     */
    public final String byOutputModalityAsString() {
        return byOutputModality;
    }

    /**
     * <p>
     * List by inference type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byInferenceType}
     * will return {@link InferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byInferenceTypeAsString}.
     * </p>
     * 
     * @return List by inference type.
     * @see InferenceType
     */
    public final InferenceType byInferenceType() {
        return InferenceType.fromValue(byInferenceType);
    }

    /**
     * <p>
     * List by inference type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byInferenceType}
     * will return {@link InferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byInferenceTypeAsString}.
     * </p>
     * 
     * @return List by inference type.
     * @see InferenceType
     */
    public final String byInferenceTypeAsString() {
        return byInferenceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(byProvider());
        hashCode = 31 * hashCode + Objects.hashCode(byCustomizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(byOutputModalityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(byInferenceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFoundationModelsRequest)) {
            return false;
        }
        ListFoundationModelsRequest other = (ListFoundationModelsRequest) obj;
        return Objects.equals(byProvider(), other.byProvider())
                && Objects.equals(byCustomizationTypeAsString(), other.byCustomizationTypeAsString())
                && Objects.equals(byOutputModalityAsString(), other.byOutputModalityAsString())
                && Objects.equals(byInferenceTypeAsString(), other.byInferenceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFoundationModelsRequest").add("ByProvider", byProvider())
                .add("ByCustomizationType", byCustomizationTypeAsString()).add("ByOutputModality", byOutputModalityAsString())
                .add("ByInferenceType", byInferenceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "byProvider":
            return Optional.ofNullable(clazz.cast(byProvider()));
        case "byCustomizationType":
            return Optional.ofNullable(clazz.cast(byCustomizationTypeAsString()));
        case "byOutputModality":
            return Optional.ofNullable(clazz.cast(byOutputModalityAsString()));
        case "byInferenceType":
            return Optional.ofNullable(clazz.cast(byInferenceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFoundationModelsRequest, T> g) {
        return obj -> g.apply((ListFoundationModelsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFoundationModelsRequest> {
        /**
         * <p>
         * A Amazon Bedrock model provider.
         * </p>
         * 
         * @param byProvider
         *        A Amazon Bedrock model provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byProvider(String byProvider);

        /**
         * <p>
         * List by customization type.
         * </p>
         * 
         * @param byCustomizationType
         *        List by customization type.
         * @see ModelCustomization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCustomization
         */
        Builder byCustomizationType(String byCustomizationType);

        /**
         * <p>
         * List by customization type.
         * </p>
         * 
         * @param byCustomizationType
         *        List by customization type.
         * @see ModelCustomization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCustomization
         */
        Builder byCustomizationType(ModelCustomization byCustomizationType);

        /**
         * <p>
         * List by output modality type.
         * </p>
         * 
         * @param byOutputModality
         *        List by output modality type.
         * @see ModelModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelModality
         */
        Builder byOutputModality(String byOutputModality);

        /**
         * <p>
         * List by output modality type.
         * </p>
         * 
         * @param byOutputModality
         *        List by output modality type.
         * @see ModelModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelModality
         */
        Builder byOutputModality(ModelModality byOutputModality);

        /**
         * <p>
         * List by inference type.
         * </p>
         * 
         * @param byInferenceType
         *        List by inference type.
         * @see InferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceType
         */
        Builder byInferenceType(String byInferenceType);

        /**
         * <p>
         * List by inference type.
         * </p>
         * 
         * @param byInferenceType
         *        List by inference type.
         * @see InferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceType
         */
        Builder byInferenceType(InferenceType byInferenceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String byProvider;

        private String byCustomizationType;

        private String byOutputModality;

        private String byInferenceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFoundationModelsRequest model) {
            super(model);
            byProvider(model.byProvider);
            byCustomizationType(model.byCustomizationType);
            byOutputModality(model.byOutputModality);
            byInferenceType(model.byInferenceType);
        }

        public final String getByProvider() {
            return byProvider;
        }

        public final void setByProvider(String byProvider) {
            this.byProvider = byProvider;
        }

        @Override
        public final Builder byProvider(String byProvider) {
            this.byProvider = byProvider;
            return this;
        }

        public final String getByCustomizationType() {
            return byCustomizationType;
        }

        public final void setByCustomizationType(String byCustomizationType) {
            this.byCustomizationType = byCustomizationType;
        }

        @Override
        public final Builder byCustomizationType(String byCustomizationType) {
            this.byCustomizationType = byCustomizationType;
            return this;
        }

        @Override
        public final Builder byCustomizationType(ModelCustomization byCustomizationType) {
            this.byCustomizationType(byCustomizationType == null ? null : byCustomizationType.toString());
            return this;
        }

        public final String getByOutputModality() {
            return byOutputModality;
        }

        public final void setByOutputModality(String byOutputModality) {
            this.byOutputModality = byOutputModality;
        }

        @Override
        public final Builder byOutputModality(String byOutputModality) {
            this.byOutputModality = byOutputModality;
            return this;
        }

        @Override
        public final Builder byOutputModality(ModelModality byOutputModality) {
            this.byOutputModality(byOutputModality == null ? null : byOutputModality.toString());
            return this;
        }

        public final String getByInferenceType() {
            return byInferenceType;
        }

        public final void setByInferenceType(String byInferenceType) {
            this.byInferenceType = byInferenceType;
        }

        @Override
        public final Builder byInferenceType(String byInferenceType) {
            this.byInferenceType = byInferenceType;
            return this;
        }

        @Override
        public final Builder byInferenceType(InferenceType byInferenceType) {
            this.byInferenceType(byInferenceType == null ? null : byInferenceType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFoundationModelsRequest build() {
            return new ListFoundationModelsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
