/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the model evaluation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationSummary.Builder, EvaluationSummary> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(EvaluationSummary::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(EvaluationSummary::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(EvaluationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(EvaluationSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobType").getter(getter(EvaluationSummary::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()).build();

    private static final SdkField<List<String>> EVALUATION_TASK_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("evaluationTaskTypes")
            .getter(getter(EvaluationSummary::evaluationTaskTypesAsStrings))
            .setter(setter(Builder::evaluationTaskTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationTaskTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MODEL_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("modelIdentifiers")
            .getter(getter(EvaluationSummary::modelIdentifiers))
            .setter(setter(Builder::modelIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_NAME_FIELD,
            STATUS_FIELD, CREATION_TIME_FIELD, JOB_TYPE_FIELD, EVALUATION_TASK_TYPES_FIELD, MODEL_IDENTIFIERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobArn;

    private final String jobName;

    private final String status;

    private final Instant creationTime;

    private final String jobType;

    private final List<String> evaluationTaskTypes;

    private final List<String> modelIdentifiers;

    private EvaluationSummary(BuilderImpl builder) {
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.jobType = builder.jobType;
        this.evaluationTaskTypes = builder.evaluationTaskTypes;
        this.modelIdentifiers = builder.modelIdentifiers;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model evaluation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model evaluation job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The name of the model evaluation job.
     * </p>
     * 
     * @return The name of the model evaluation job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The current status of the model evaluation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the model evaluation job.
     * @see EvaluationJobStatus
     */
    public final EvaluationJobStatus status() {
        return EvaluationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the model evaluation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the model evaluation job.
     * @see EvaluationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * When the model evaluation job was created.
     * </p>
     * 
     * @return When the model evaluation job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The type, either human or automatic, of model evaluation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link EvaluationJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The type, either human or automatic, of model evaluation job.
     * @see EvaluationJobType
     */
    public final EvaluationJobType jobType() {
        return EvaluationJobType.fromValue(jobType);
    }

    /**
     * <p>
     * The type, either human or automatic, of model evaluation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link EvaluationJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The type, either human or automatic, of model evaluation job.
     * @see EvaluationJobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * What task type was used in the model evaluation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvaluationTaskTypes} method.
     * </p>
     * 
     * @return What task type was used in the model evaluation job.
     */
    public final List<EvaluationTaskType> evaluationTaskTypes() {
        return EvaluationTaskTypesCopier.copyStringToEnum(evaluationTaskTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the EvaluationTaskTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEvaluationTaskTypes() {
        return evaluationTaskTypes != null && !(evaluationTaskTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * What task type was used in the model evaluation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvaluationTaskTypes} method.
     * </p>
     * 
     * @return What task type was used in the model evaluation job.
     */
    public final List<String> evaluationTaskTypesAsStrings() {
        return evaluationTaskTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelIdentifiers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModelIdentifiers() {
        return modelIdentifiers != null && !(modelIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the model(s) used in the model evaluation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelIdentifiers} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the model(s) used in the model evaluation job.
     */
    public final List<String> modelIdentifiers() {
        return modelIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvaluationTaskTypes() ? evaluationTaskTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasModelIdentifiers() ? modelIdentifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationSummary)) {
            return false;
        }
        EvaluationSummary other = (EvaluationSummary) obj;
        return Objects.equals(jobArn(), other.jobArn()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString())
                && hasEvaluationTaskTypes() == other.hasEvaluationTaskTypes()
                && Objects.equals(evaluationTaskTypesAsStrings(), other.evaluationTaskTypesAsStrings())
                && hasModelIdentifiers() == other.hasModelIdentifiers()
                && Objects.equals(modelIdentifiers(), other.modelIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationSummary").add("JobArn", jobArn()).add("JobName", jobName())
                .add("Status", statusAsString()).add("CreationTime", creationTime()).add("JobType", jobTypeAsString())
                .add("EvaluationTaskTypes", hasEvaluationTaskTypes() ? evaluationTaskTypesAsStrings() : null)
                .add("ModelIdentifiers", hasModelIdentifiers() ? modelIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "jobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "evaluationTaskTypes":
            return Optional.ofNullable(clazz.cast(evaluationTaskTypesAsStrings()));
        case "modelIdentifiers":
            return Optional.ofNullable(clazz.cast(modelIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationSummary, T> g) {
        return obj -> g.apply((EvaluationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model evaluation job.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the model evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The name of the model evaluation job.
         * </p>
         * 
         * @param jobName
         *        The name of the model evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The current status of the model evaluation job.
         * </p>
         * 
         * @param status
         *        The current status of the model evaluation job.
         * @see EvaluationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the model evaluation job.
         * </p>
         * 
         * @param status
         *        The current status of the model evaluation job.
         * @see EvaluationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationJobStatus
         */
        Builder status(EvaluationJobStatus status);

        /**
         * <p>
         * When the model evaluation job was created.
         * </p>
         * 
         * @param creationTime
         *        When the model evaluation job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The type, either human or automatic, of model evaluation job.
         * </p>
         * 
         * @param jobType
         *        The type, either human or automatic, of model evaluation job.
         * @see EvaluationJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationJobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The type, either human or automatic, of model evaluation job.
         * </p>
         * 
         * @param jobType
         *        The type, either human or automatic, of model evaluation job.
         * @see EvaluationJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationJobType
         */
        Builder jobType(EvaluationJobType jobType);

        /**
         * <p>
         * What task type was used in the model evaluation job.
         * </p>
         * 
         * @param evaluationTaskTypes
         *        What task type was used in the model evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationTaskTypesWithStrings(Collection<String> evaluationTaskTypes);

        /**
         * <p>
         * What task type was used in the model evaluation job.
         * </p>
         * 
         * @param evaluationTaskTypes
         *        What task type was used in the model evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationTaskTypesWithStrings(String... evaluationTaskTypes);

        /**
         * <p>
         * What task type was used in the model evaluation job.
         * </p>
         * 
         * @param evaluationTaskTypes
         *        What task type was used in the model evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationTaskTypes(Collection<EvaluationTaskType> evaluationTaskTypes);

        /**
         * <p>
         * What task type was used in the model evaluation job.
         * </p>
         * 
         * @param evaluationTaskTypes
         *        What task type was used in the model evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationTaskTypes(EvaluationTaskType... evaluationTaskTypes);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the model(s) used in the model evaluation job.
         * </p>
         * 
         * @param modelIdentifiers
         *        The Amazon Resource Names (ARNs) of the model(s) used in the model evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelIdentifiers(Collection<String> modelIdentifiers);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the model(s) used in the model evaluation job.
         * </p>
         * 
         * @param modelIdentifiers
         *        The Amazon Resource Names (ARNs) of the model(s) used in the model evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelIdentifiers(String... modelIdentifiers);
    }

    static final class BuilderImpl implements Builder {
        private String jobArn;

        private String jobName;

        private String status;

        private Instant creationTime;

        private String jobType;

        private List<String> evaluationTaskTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> modelIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationSummary model) {
            jobArn(model.jobArn);
            jobName(model.jobName);
            status(model.status);
            creationTime(model.creationTime);
            jobType(model.jobType);
            evaluationTaskTypesWithStrings(model.evaluationTaskTypes);
            modelIdentifiers(model.modelIdentifiers);
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(EvaluationJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final Collection<String> getEvaluationTaskTypes() {
            if (evaluationTaskTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return evaluationTaskTypes;
        }

        public final void setEvaluationTaskTypes(Collection<String> evaluationTaskTypes) {
            this.evaluationTaskTypes = EvaluationTaskTypesCopier.copy(evaluationTaskTypes);
        }

        @Override
        public final Builder evaluationTaskTypesWithStrings(Collection<String> evaluationTaskTypes) {
            this.evaluationTaskTypes = EvaluationTaskTypesCopier.copy(evaluationTaskTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationTaskTypesWithStrings(String... evaluationTaskTypes) {
            evaluationTaskTypesWithStrings(Arrays.asList(evaluationTaskTypes));
            return this;
        }

        @Override
        public final Builder evaluationTaskTypes(Collection<EvaluationTaskType> evaluationTaskTypes) {
            this.evaluationTaskTypes = EvaluationTaskTypesCopier.copyEnumToString(evaluationTaskTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationTaskTypes(EvaluationTaskType... evaluationTaskTypes) {
            evaluationTaskTypes(Arrays.asList(evaluationTaskTypes));
            return this;
        }

        public final Collection<String> getModelIdentifiers() {
            if (modelIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return modelIdentifiers;
        }

        public final void setModelIdentifiers(Collection<String> modelIdentifiers) {
            this.modelIdentifiers = EvaluationModelIdentifiersCopier.copy(modelIdentifiers);
        }

        @Override
        public final Builder modelIdentifiers(Collection<String> modelIdentifiers) {
            this.modelIdentifiers = EvaluationModelIdentifiersCopier.copy(modelIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelIdentifiers(String... modelIdentifiers) {
            modelIdentifiers(Arrays.asList(modelIdentifiers));
            return this;
        }

        @Override
        public EvaluationSummary build() {
            return new EvaluationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
