/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for a foundation model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FoundationModelSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<FoundationModelSummary.Builder, FoundationModelSummary> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(FoundationModelSummary::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(FoundationModelSummary::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelName").getter(getter(FoundationModelSummary::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelName").build()).build();

    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerName").getter(getter(FoundationModelSummary::providerName))
            .setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()).build();

    private static final SdkField<List<String>> INPUT_MODALITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("inputModalities")
            .getter(getter(FoundationModelSummary::inputModalitiesAsStrings))
            .setter(setter(Builder::inputModalitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputModalities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OUTPUT_MODALITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("outputModalities")
            .getter(getter(FoundationModelSummary::outputModalitiesAsStrings))
            .setter(setter(Builder::outputModalitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputModalities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> RESPONSE_STREAMING_SUPPORTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("responseStreamingSupported")
            .getter(getter(FoundationModelSummary::responseStreamingSupported))
            .setter(setter(Builder::responseStreamingSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseStreamingSupported").build())
            .build();

    private static final SdkField<List<String>> CUSTOMIZATIONS_SUPPORTED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("customizationsSupported")
            .getter(getter(FoundationModelSummary::customizationsSupportedAsStrings))
            .setter(setter(Builder::customizationsSupportedWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customizationsSupported").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INFERENCE_TYPES_SUPPORTED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("inferenceTypesSupported")
            .getter(getter(FoundationModelSummary::inferenceTypesSupportedAsStrings))
            .setter(setter(Builder::inferenceTypesSupportedWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceTypesSupported").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FoundationModelLifecycle> MODEL_LIFECYCLE_FIELD = SdkField
            .<FoundationModelLifecycle> builder(MarshallingType.SDK_POJO).memberName("modelLifecycle")
            .getter(getter(FoundationModelSummary::modelLifecycle)).setter(setter(Builder::modelLifecycle))
            .constructor(FoundationModelLifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelLifecycle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD,
            MODEL_ID_FIELD, MODEL_NAME_FIELD, PROVIDER_NAME_FIELD, INPUT_MODALITIES_FIELD, OUTPUT_MODALITIES_FIELD,
            RESPONSE_STREAMING_SUPPORTED_FIELD, CUSTOMIZATIONS_SUPPORTED_FIELD, INFERENCE_TYPES_SUPPORTED_FIELD,
            MODEL_LIFECYCLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelArn;

    private final String modelId;

    private final String modelName;

    private final String providerName;

    private final List<String> inputModalities;

    private final List<String> outputModalities;

    private final Boolean responseStreamingSupported;

    private final List<String> customizationsSupported;

    private final List<String> inferenceTypesSupported;

    private final FoundationModelLifecycle modelLifecycle;

    private FoundationModelSummary(BuilderImpl builder) {
        this.modelArn = builder.modelArn;
        this.modelId = builder.modelId;
        this.modelName = builder.modelName;
        this.providerName = builder.providerName;
        this.inputModalities = builder.inputModalities;
        this.outputModalities = builder.outputModalities;
        this.responseStreamingSupported = builder.responseStreamingSupported;
        this.customizationsSupported = builder.customizationsSupported;
        this.inferenceTypesSupported = builder.inferenceTypesSupported;
        this.modelLifecycle = builder.modelLifecycle;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the foundation model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the foundation model.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The model ID of the foundation model.
     * </p>
     * 
     * @return The model ID of the foundation model.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The name of the model.
     * </p>
     * 
     * @return The name of the model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The model's provider name.
     * </p>
     * 
     * @return The model's provider name.
     */
    public final String providerName() {
        return providerName;
    }

    /**
     * <p>
     * The input modalities that the model supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputModalities} method.
     * </p>
     * 
     * @return The input modalities that the model supports.
     */
    public final List<ModelModality> inputModalities() {
        return ModelModalityListCopier.copyStringToEnum(inputModalities);
    }

    /**
     * For responses, this returns true if the service returned a value for the InputModalities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputModalities() {
        return inputModalities != null && !(inputModalities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The input modalities that the model supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputModalities} method.
     * </p>
     * 
     * @return The input modalities that the model supports.
     */
    public final List<String> inputModalitiesAsStrings() {
        return inputModalities;
    }

    /**
     * <p>
     * The output modalities that the model supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputModalities} method.
     * </p>
     * 
     * @return The output modalities that the model supports.
     */
    public final List<ModelModality> outputModalities() {
        return ModelModalityListCopier.copyStringToEnum(outputModalities);
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputModalities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputModalities() {
        return outputModalities != null && !(outputModalities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The output modalities that the model supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputModalities} method.
     * </p>
     * 
     * @return The output modalities that the model supports.
     */
    public final List<String> outputModalitiesAsStrings() {
        return outputModalities;
    }

    /**
     * <p>
     * Indicates whether the model supports streaming.
     * </p>
     * 
     * @return Indicates whether the model supports streaming.
     */
    public final Boolean responseStreamingSupported() {
        return responseStreamingSupported;
    }

    /**
     * <p>
     * Whether the model supports fine-tuning or continual pre-training.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomizationsSupported} method.
     * </p>
     * 
     * @return Whether the model supports fine-tuning or continual pre-training.
     */
    public final List<ModelCustomization> customizationsSupported() {
        return ModelCustomizationListCopier.copyStringToEnum(customizationsSupported);
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomizationsSupported property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomizationsSupported() {
        return customizationsSupported != null && !(customizationsSupported instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Whether the model supports fine-tuning or continual pre-training.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomizationsSupported} method.
     * </p>
     * 
     * @return Whether the model supports fine-tuning or continual pre-training.
     */
    public final List<String> customizationsSupportedAsStrings() {
        return customizationsSupported;
    }

    /**
     * <p>
     * The inference types that the model supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInferenceTypesSupported} method.
     * </p>
     * 
     * @return The inference types that the model supports.
     */
    public final List<InferenceType> inferenceTypesSupported() {
        return InferenceTypeListCopier.copyStringToEnum(inferenceTypesSupported);
    }

    /**
     * For responses, this returns true if the service returned a value for the InferenceTypesSupported property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInferenceTypesSupported() {
        return inferenceTypesSupported != null && !(inferenceTypesSupported instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inference types that the model supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInferenceTypesSupported} method.
     * </p>
     * 
     * @return The inference types that the model supports.
     */
    public final List<String> inferenceTypesSupportedAsStrings() {
        return inferenceTypesSupported;
    }

    /**
     * <p>
     * Contains details about whether a model version is available or deprecated.
     * </p>
     * 
     * @return Contains details about whether a model version is available or deprecated.
     */
    public final FoundationModelLifecycle modelLifecycle() {
        return modelLifecycle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputModalities() ? inputModalitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputModalities() ? outputModalitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(responseStreamingSupported());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomizationsSupported() ? customizationsSupportedAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInferenceTypesSupported() ? inferenceTypesSupportedAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(modelLifecycle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FoundationModelSummary)) {
            return false;
        }
        FoundationModelSummary other = (FoundationModelSummary) obj;
        return Objects.equals(modelArn(), other.modelArn()) && Objects.equals(modelId(), other.modelId())
                && Objects.equals(modelName(), other.modelName()) && Objects.equals(providerName(), other.providerName())
                && hasInputModalities() == other.hasInputModalities()
                && Objects.equals(inputModalitiesAsStrings(), other.inputModalitiesAsStrings())
                && hasOutputModalities() == other.hasOutputModalities()
                && Objects.equals(outputModalitiesAsStrings(), other.outputModalitiesAsStrings())
                && Objects.equals(responseStreamingSupported(), other.responseStreamingSupported())
                && hasCustomizationsSupported() == other.hasCustomizationsSupported()
                && Objects.equals(customizationsSupportedAsStrings(), other.customizationsSupportedAsStrings())
                && hasInferenceTypesSupported() == other.hasInferenceTypesSupported()
                && Objects.equals(inferenceTypesSupportedAsStrings(), other.inferenceTypesSupportedAsStrings())
                && Objects.equals(modelLifecycle(), other.modelLifecycle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FoundationModelSummary").add("ModelArn", modelArn()).add("ModelId", modelId())
                .add("ModelName", modelName()).add("ProviderName", providerName())
                .add("InputModalities", hasInputModalities() ? inputModalitiesAsStrings() : null)
                .add("OutputModalities", hasOutputModalities() ? outputModalitiesAsStrings() : null)
                .add("ResponseStreamingSupported", responseStreamingSupported())
                .add("CustomizationsSupported", hasCustomizationsSupported() ? customizationsSupportedAsStrings() : null)
                .add("InferenceTypesSupported", hasInferenceTypesSupported() ? inferenceTypesSupportedAsStrings() : null)
                .add("ModelLifecycle", modelLifecycle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "modelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "providerName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "inputModalities":
            return Optional.ofNullable(clazz.cast(inputModalitiesAsStrings()));
        case "outputModalities":
            return Optional.ofNullable(clazz.cast(outputModalitiesAsStrings()));
        case "responseStreamingSupported":
            return Optional.ofNullable(clazz.cast(responseStreamingSupported()));
        case "customizationsSupported":
            return Optional.ofNullable(clazz.cast(customizationsSupportedAsStrings()));
        case "inferenceTypesSupported":
            return Optional.ofNullable(clazz.cast(inferenceTypesSupportedAsStrings()));
        case "modelLifecycle":
            return Optional.ofNullable(clazz.cast(modelLifecycle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FoundationModelSummary, T> g) {
        return obj -> g.apply((FoundationModelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FoundationModelSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the foundation model.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the foundation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The model ID of the foundation model.
         * </p>
         * 
         * @param modelId
         *        The model ID of the foundation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The name of the model.
         * </p>
         * 
         * @param modelName
         *        The name of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The model's provider name.
         * </p>
         * 
         * @param providerName
         *        The model's provider name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The input modalities that the model supports.
         * </p>
         * 
         * @param inputModalities
         *        The input modalities that the model supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputModalitiesWithStrings(Collection<String> inputModalities);

        /**
         * <p>
         * The input modalities that the model supports.
         * </p>
         * 
         * @param inputModalities
         *        The input modalities that the model supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputModalitiesWithStrings(String... inputModalities);

        /**
         * <p>
         * The input modalities that the model supports.
         * </p>
         * 
         * @param inputModalities
         *        The input modalities that the model supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputModalities(Collection<ModelModality> inputModalities);

        /**
         * <p>
         * The input modalities that the model supports.
         * </p>
         * 
         * @param inputModalities
         *        The input modalities that the model supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputModalities(ModelModality... inputModalities);

        /**
         * <p>
         * The output modalities that the model supports.
         * </p>
         * 
         * @param outputModalities
         *        The output modalities that the model supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputModalitiesWithStrings(Collection<String> outputModalities);

        /**
         * <p>
         * The output modalities that the model supports.
         * </p>
         * 
         * @param outputModalities
         *        The output modalities that the model supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputModalitiesWithStrings(String... outputModalities);

        /**
         * <p>
         * The output modalities that the model supports.
         * </p>
         * 
         * @param outputModalities
         *        The output modalities that the model supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputModalities(Collection<ModelModality> outputModalities);

        /**
         * <p>
         * The output modalities that the model supports.
         * </p>
         * 
         * @param outputModalities
         *        The output modalities that the model supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputModalities(ModelModality... outputModalities);

        /**
         * <p>
         * Indicates whether the model supports streaming.
         * </p>
         * 
         * @param responseStreamingSupported
         *        Indicates whether the model supports streaming.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseStreamingSupported(Boolean responseStreamingSupported);

        /**
         * <p>
         * Whether the model supports fine-tuning or continual pre-training.
         * </p>
         * 
         * @param customizationsSupported
         *        Whether the model supports fine-tuning or continual pre-training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizationsSupportedWithStrings(Collection<String> customizationsSupported);

        /**
         * <p>
         * Whether the model supports fine-tuning or continual pre-training.
         * </p>
         * 
         * @param customizationsSupported
         *        Whether the model supports fine-tuning or continual pre-training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizationsSupportedWithStrings(String... customizationsSupported);

        /**
         * <p>
         * Whether the model supports fine-tuning or continual pre-training.
         * </p>
         * 
         * @param customizationsSupported
         *        Whether the model supports fine-tuning or continual pre-training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizationsSupported(Collection<ModelCustomization> customizationsSupported);

        /**
         * <p>
         * Whether the model supports fine-tuning or continual pre-training.
         * </p>
         * 
         * @param customizationsSupported
         *        Whether the model supports fine-tuning or continual pre-training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizationsSupported(ModelCustomization... customizationsSupported);

        /**
         * <p>
         * The inference types that the model supports.
         * </p>
         * 
         * @param inferenceTypesSupported
         *        The inference types that the model supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceTypesSupportedWithStrings(Collection<String> inferenceTypesSupported);

        /**
         * <p>
         * The inference types that the model supports.
         * </p>
         * 
         * @param inferenceTypesSupported
         *        The inference types that the model supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceTypesSupportedWithStrings(String... inferenceTypesSupported);

        /**
         * <p>
         * The inference types that the model supports.
         * </p>
         * 
         * @param inferenceTypesSupported
         *        The inference types that the model supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceTypesSupported(Collection<InferenceType> inferenceTypesSupported);

        /**
         * <p>
         * The inference types that the model supports.
         * </p>
         * 
         * @param inferenceTypesSupported
         *        The inference types that the model supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceTypesSupported(InferenceType... inferenceTypesSupported);

        /**
         * <p>
         * Contains details about whether a model version is available or deprecated.
         * </p>
         * 
         * @param modelLifecycle
         *        Contains details about whether a model version is available or deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelLifecycle(FoundationModelLifecycle modelLifecycle);

        /**
         * <p>
         * Contains details about whether a model version is available or deprecated.
         * </p>
         * This is a convenience method that creates an instance of the {@link FoundationModelLifecycle.Builder}
         * avoiding the need to create one manually via {@link FoundationModelLifecycle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FoundationModelLifecycle.Builder#build()} is called immediately
         * and its result is passed to {@link #modelLifecycle(FoundationModelLifecycle)}.
         * 
         * @param modelLifecycle
         *        a consumer that will call methods on {@link FoundationModelLifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelLifecycle(FoundationModelLifecycle)
         */
        default Builder modelLifecycle(Consumer<FoundationModelLifecycle.Builder> modelLifecycle) {
            return modelLifecycle(FoundationModelLifecycle.builder().applyMutation(modelLifecycle).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String modelArn;

        private String modelId;

        private String modelName;

        private String providerName;

        private List<String> inputModalities = DefaultSdkAutoConstructList.getInstance();

        private List<String> outputModalities = DefaultSdkAutoConstructList.getInstance();

        private Boolean responseStreamingSupported;

        private List<String> customizationsSupported = DefaultSdkAutoConstructList.getInstance();

        private List<String> inferenceTypesSupported = DefaultSdkAutoConstructList.getInstance();

        private FoundationModelLifecycle modelLifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(FoundationModelSummary model) {
            modelArn(model.modelArn);
            modelId(model.modelId);
            modelName(model.modelName);
            providerName(model.providerName);
            inputModalitiesWithStrings(model.inputModalities);
            outputModalitiesWithStrings(model.outputModalities);
            responseStreamingSupported(model.responseStreamingSupported);
            customizationsSupportedWithStrings(model.customizationsSupported);
            inferenceTypesSupportedWithStrings(model.inferenceTypesSupported);
            modelLifecycle(model.modelLifecycle);
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getProviderName() {
            return providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final Collection<String> getInputModalities() {
            if (inputModalities instanceof SdkAutoConstructList) {
                return null;
            }
            return inputModalities;
        }

        public final void setInputModalities(Collection<String> inputModalities) {
            this.inputModalities = ModelModalityListCopier.copy(inputModalities);
        }

        @Override
        public final Builder inputModalitiesWithStrings(Collection<String> inputModalities) {
            this.inputModalities = ModelModalityListCopier.copy(inputModalities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputModalitiesWithStrings(String... inputModalities) {
            inputModalitiesWithStrings(Arrays.asList(inputModalities));
            return this;
        }

        @Override
        public final Builder inputModalities(Collection<ModelModality> inputModalities) {
            this.inputModalities = ModelModalityListCopier.copyEnumToString(inputModalities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputModalities(ModelModality... inputModalities) {
            inputModalities(Arrays.asList(inputModalities));
            return this;
        }

        public final Collection<String> getOutputModalities() {
            if (outputModalities instanceof SdkAutoConstructList) {
                return null;
            }
            return outputModalities;
        }

        public final void setOutputModalities(Collection<String> outputModalities) {
            this.outputModalities = ModelModalityListCopier.copy(outputModalities);
        }

        @Override
        public final Builder outputModalitiesWithStrings(Collection<String> outputModalities) {
            this.outputModalities = ModelModalityListCopier.copy(outputModalities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputModalitiesWithStrings(String... outputModalities) {
            outputModalitiesWithStrings(Arrays.asList(outputModalities));
            return this;
        }

        @Override
        public final Builder outputModalities(Collection<ModelModality> outputModalities) {
            this.outputModalities = ModelModalityListCopier.copyEnumToString(outputModalities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputModalities(ModelModality... outputModalities) {
            outputModalities(Arrays.asList(outputModalities));
            return this;
        }

        public final Boolean getResponseStreamingSupported() {
            return responseStreamingSupported;
        }

        public final void setResponseStreamingSupported(Boolean responseStreamingSupported) {
            this.responseStreamingSupported = responseStreamingSupported;
        }

        @Override
        public final Builder responseStreamingSupported(Boolean responseStreamingSupported) {
            this.responseStreamingSupported = responseStreamingSupported;
            return this;
        }

        public final Collection<String> getCustomizationsSupported() {
            if (customizationsSupported instanceof SdkAutoConstructList) {
                return null;
            }
            return customizationsSupported;
        }

        public final void setCustomizationsSupported(Collection<String> customizationsSupported) {
            this.customizationsSupported = ModelCustomizationListCopier.copy(customizationsSupported);
        }

        @Override
        public final Builder customizationsSupportedWithStrings(Collection<String> customizationsSupported) {
            this.customizationsSupported = ModelCustomizationListCopier.copy(customizationsSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customizationsSupportedWithStrings(String... customizationsSupported) {
            customizationsSupportedWithStrings(Arrays.asList(customizationsSupported));
            return this;
        }

        @Override
        public final Builder customizationsSupported(Collection<ModelCustomization> customizationsSupported) {
            this.customizationsSupported = ModelCustomizationListCopier.copyEnumToString(customizationsSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customizationsSupported(ModelCustomization... customizationsSupported) {
            customizationsSupported(Arrays.asList(customizationsSupported));
            return this;
        }

        public final Collection<String> getInferenceTypesSupported() {
            if (inferenceTypesSupported instanceof SdkAutoConstructList) {
                return null;
            }
            return inferenceTypesSupported;
        }

        public final void setInferenceTypesSupported(Collection<String> inferenceTypesSupported) {
            this.inferenceTypesSupported = InferenceTypeListCopier.copy(inferenceTypesSupported);
        }

        @Override
        public final Builder inferenceTypesSupportedWithStrings(Collection<String> inferenceTypesSupported) {
            this.inferenceTypesSupported = InferenceTypeListCopier.copy(inferenceTypesSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceTypesSupportedWithStrings(String... inferenceTypesSupported) {
            inferenceTypesSupportedWithStrings(Arrays.asList(inferenceTypesSupported));
            return this;
        }

        @Override
        public final Builder inferenceTypesSupported(Collection<InferenceType> inferenceTypesSupported) {
            this.inferenceTypesSupported = InferenceTypeListCopier.copyEnumToString(inferenceTypesSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceTypesSupported(InferenceType... inferenceTypesSupported) {
            inferenceTypesSupported(Arrays.asList(inferenceTypesSupported));
            return this;
        }

        public final FoundationModelLifecycle.Builder getModelLifecycle() {
            return modelLifecycle != null ? modelLifecycle.toBuilder() : null;
        }

        public final void setModelLifecycle(FoundationModelLifecycle.BuilderImpl modelLifecycle) {
            this.modelLifecycle = modelLifecycle != null ? modelLifecycle.build() : null;
        }

        @Override
        public final Builder modelLifecycle(FoundationModelLifecycle modelLifecycle) {
            this.modelLifecycle = modelLifecycle;
            return this;
        }

        @Override
        public FoundationModelSummary build() {
            return new FoundationModelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
