/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetModelInvocationLoggingConfigurationResponse extends BedrockResponse implements
        ToCopyableBuilder<GetModelInvocationLoggingConfigurationResponse.Builder, GetModelInvocationLoggingConfigurationResponse> {
    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField
            .<LoggingConfig> builder(MarshallingType.SDK_POJO).memberName("loggingConfig")
            .getter(getter(GetModelInvocationLoggingConfigurationResponse::loggingConfig)).setter(setter(Builder::loggingConfig))
            .constructor(LoggingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGGING_CONFIG_FIELD));

    private final LoggingConfig loggingConfig;

    private GetModelInvocationLoggingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.loggingConfig = builder.loggingConfig;
    }

    /**
     * <p>
     * The current configuration values.
     * </p>
     * 
     * @return The current configuration values.
     */
    public final LoggingConfig loggingConfig() {
        return loggingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelInvocationLoggingConfigurationResponse)) {
            return false;
        }
        GetModelInvocationLoggingConfigurationResponse other = (GetModelInvocationLoggingConfigurationResponse) obj;
        return Objects.equals(loggingConfig(), other.loggingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetModelInvocationLoggingConfigurationResponse").add("LoggingConfig", loggingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loggingConfig":
            return Optional.ofNullable(clazz.cast(loggingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetModelInvocationLoggingConfigurationResponse, T> g) {
        return obj -> g.apply((GetModelInvocationLoggingConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetModelInvocationLoggingConfigurationResponse> {
        /**
         * <p>
         * The current configuration values.
         * </p>
         * 
         * @param loggingConfig
         *        The current configuration values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfig(LoggingConfig loggingConfig);

        /**
         * <p>
         * The current configuration values.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingConfig.Builder} avoiding the need
         * to create one manually via {@link LoggingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #loggingConfig(LoggingConfig)}.
         * 
         * @param loggingConfig
         *        a consumer that will call methods on {@link LoggingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfig(LoggingConfig)
         */
        default Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return loggingConfig(LoggingConfig.builder().applyMutation(loggingConfig).build());
        }
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private LoggingConfig loggingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelInvocationLoggingConfigurationResponse model) {
            super(model);
            loggingConfig(model.loggingConfig);
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return loggingConfig != null ? loggingConfig.toBuilder() : null;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        @Override
        public GetModelInvocationLoggingConfigurationResponse build() {
            return new GetModelInvocationLoggingConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
