/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntitiesCopier;
import software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntity;
import software.amazon.awssdk.services.bedrock.model.GuardrailRegex;
import software.amazon.awssdk.services.bedrock.model.GuardrailRegexesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailSensitiveInformationPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailSensitiveInformationPolicy> {
    private static final SdkField<List<GuardrailPiiEntity>> PII_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("piiEntities").getter(GuardrailSensitiveInformationPolicy.getter(GuardrailSensitiveInformationPolicy::piiEntities)).setter(GuardrailSensitiveInformationPolicy.setter(Builder::piiEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("piiEntities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailPiiEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GuardrailRegex>> REGEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regexes").getter(GuardrailSensitiveInformationPolicy.getter(GuardrailSensitiveInformationPolicy::regexes)).setter(GuardrailSensitiveInformationPolicy.setter(Builder::regexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailRegex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PII_ENTITIES_FIELD, REGEXES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<GuardrailPiiEntity> piiEntities;
    private final List<GuardrailRegex> regexes;

    private GuardrailSensitiveInformationPolicy(BuilderImpl builder) {
        this.piiEntities = builder.piiEntities;
        this.regexes = builder.regexes;
    }

    public final boolean hasPiiEntities() {
        return this.piiEntities != null && !(this.piiEntities instanceof SdkAutoConstructList);
    }

    public final List<GuardrailPiiEntity> piiEntities() {
        return this.piiEntities;
    }

    public final boolean hasRegexes() {
        return this.regexes != null && !(this.regexes instanceof SdkAutoConstructList);
    }

    public final List<GuardrailRegex> regexes() {
        return this.regexes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPiiEntities() ? this.piiEntities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegexes() ? this.regexes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailSensitiveInformationPolicy)) {
            return false;
        }
        GuardrailSensitiveInformationPolicy other = (GuardrailSensitiveInformationPolicy)obj;
        return this.hasPiiEntities() == other.hasPiiEntities() && Objects.equals(this.piiEntities(), other.piiEntities()) && this.hasRegexes() == other.hasRegexes() && Objects.equals(this.regexes(), other.regexes());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailSensitiveInformationPolicy").add("PiiEntities", this.hasPiiEntities() ? this.piiEntities() : null).add("Regexes", this.hasRegexes() ? this.regexes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "piiEntities": {
                return Optional.ofNullable(clazz.cast(this.piiEntities()));
            }
            case "regexes": {
                return Optional.ofNullable(clazz.cast(this.regexes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailSensitiveInformationPolicy, T> g) {
        return obj -> g.apply((GuardrailSensitiveInformationPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GuardrailPiiEntity> piiEntities = DefaultSdkAutoConstructList.getInstance();
        private List<GuardrailRegex> regexes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailSensitiveInformationPolicy model) {
            this.piiEntities(model.piiEntities);
            this.regexes(model.regexes);
        }

        public final List<GuardrailPiiEntity.Builder> getPiiEntities() {
            List<GuardrailPiiEntity.Builder> result = GuardrailPiiEntitiesCopier.copyToBuilder(this.piiEntities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPiiEntities(Collection<GuardrailPiiEntity.BuilderImpl> piiEntities) {
            this.piiEntities = GuardrailPiiEntitiesCopier.copyFromBuilder(piiEntities);
        }

        @Override
        public final Builder piiEntities(Collection<GuardrailPiiEntity> piiEntities) {
            this.piiEntities = GuardrailPiiEntitiesCopier.copy(piiEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntities(GuardrailPiiEntity ... piiEntities) {
            this.piiEntities(Arrays.asList(piiEntities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntities(Consumer<GuardrailPiiEntity.Builder> ... piiEntities) {
            this.piiEntities(Stream.of(piiEntities).map(c -> (GuardrailPiiEntity)((GuardrailPiiEntity.Builder)GuardrailPiiEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailRegex.Builder> getRegexes() {
            List<GuardrailRegex.Builder> result = GuardrailRegexesCopier.copyToBuilder(this.regexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegexes(Collection<GuardrailRegex.BuilderImpl> regexes) {
            this.regexes = GuardrailRegexesCopier.copyFromBuilder(regexes);
        }

        @Override
        public final Builder regexes(Collection<GuardrailRegex> regexes) {
            this.regexes = GuardrailRegexesCopier.copy(regexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexes(GuardrailRegex ... regexes) {
            this.regexes(Arrays.asList(regexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexes(Consumer<GuardrailRegex.Builder> ... regexes) {
            this.regexes(Stream.of(regexes).map(c -> (GuardrailRegex)((GuardrailRegex.Builder)GuardrailRegex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GuardrailSensitiveInformationPolicy build() {
            return new GuardrailSensitiveInformationPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailSensitiveInformationPolicy> {
        public Builder piiEntities(Collection<GuardrailPiiEntity> var1);

        public Builder piiEntities(GuardrailPiiEntity ... var1);

        public Builder piiEntities(Consumer<GuardrailPiiEntity.Builder> ... var1);

        public Builder regexes(Collection<GuardrailRegex> var1);

        public Builder regexes(GuardrailRegex ... var1);

        public Builder regexes(Consumer<GuardrailRegex.Builder> ... var1);
    }
}

