/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.protocols.core.OperationInfo;
import software.amazon.awssdk.protocols.core.ProtocolMarshaller;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.services.bedrock.model.GetImportedModelRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetImportedModelRequestMarshaller
implements Marshaller<GetImportedModelRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/imported-models/{modelIdentifier}").httpMethod(SdkHttpMethod.GET).hasExplicitPayloadMember(false).hasImplicitPayloadMembers(false).hasPayloadMembers(false).build();
    private final BaseAwsJsonProtocolFactory protocolFactory;

    public GetImportedModelRequestMarshaller(BaseAwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public SdkHttpFullRequest marshall(GetImportedModelRequest getImportedModelRequest) {
        Validate.paramNotNull((Object)((Object)getImportedModelRequest), (String)"getImportedModelRequest");
        try {
            ProtocolMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING);
            return (SdkHttpFullRequest)protocolMarshaller.marshall((SdkPojo)getImportedModelRequest);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

