/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The regular expression configured for the guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailRegex implements SdkPojo, Serializable, ToCopyableBuilder<GuardrailRegex.Builder, GuardrailRegex> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GuardrailRegex::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GuardrailRegex::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("pattern")
            .getter(getter(GuardrailRegex::pattern)).setter(setter(Builder::pattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pattern").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(GuardrailRegex::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            PATTERN_FIELD, ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String pattern;

    private final String action;

    private GuardrailRegex(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.pattern = builder.pattern;
        this.action = builder.action;
    }

    /**
     * <p>
     * The name of the regular expression for the guardrail.
     * </p>
     * 
     * @return The name of the regular expression for the guardrail.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the regular expression for the guardrail.
     * </p>
     * 
     * @return The description of the regular expression for the guardrail.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The pattern of the regular expression configured for the guardrail.
     * </p>
     * 
     * @return The pattern of the regular expression configured for the guardrail.
     */
    public final String pattern() {
        return pattern;
    }

    /**
     * <p>
     * The action taken when a match to the regular expression is detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailSensitiveInformationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action taken when a match to the regular expression is detected.
     * @see GuardrailSensitiveInformationAction
     */
    public final GuardrailSensitiveInformationAction action() {
        return GuardrailSensitiveInformationAction.fromValue(action);
    }

    /**
     * <p>
     * The action taken when a match to the regular expression is detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailSensitiveInformationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action taken when a match to the regular expression is detected.
     * @see GuardrailSensitiveInformationAction
     */
    public final String actionAsString() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(pattern());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailRegex)) {
            return false;
        }
        GuardrailRegex other = (GuardrailRegex) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(pattern(), other.pattern()) && Objects.equals(actionAsString(), other.actionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailRegex").add("Name", name()).add("Description", description()).add("Pattern", pattern())
                .add("Action", actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "pattern":
            return Optional.ofNullable(clazz.cast(pattern()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailRegex, T> g) {
        return obj -> g.apply((GuardrailRegex) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailRegex> {
        /**
         * <p>
         * The name of the regular expression for the guardrail.
         * </p>
         * 
         * @param name
         *        The name of the regular expression for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the regular expression for the guardrail.
         * </p>
         * 
         * @param description
         *        The description of the regular expression for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The pattern of the regular expression configured for the guardrail.
         * </p>
         * 
         * @param pattern
         *        The pattern of the regular expression configured for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pattern(String pattern);

        /**
         * <p>
         * The action taken when a match to the regular expression is detected.
         * </p>
         * 
         * @param action
         *        The action taken when a match to the regular expression is detected.
         * @see GuardrailSensitiveInformationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action taken when a match to the regular expression is detected.
         * </p>
         * 
         * @param action
         *        The action taken when a match to the regular expression is detected.
         * @see GuardrailSensitiveInformationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationAction
         */
        Builder action(GuardrailSensitiveInformationAction action);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String pattern;

        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailRegex model) {
            name(model.name);
            description(model.description);
            pattern(model.pattern);
            action(model.action);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPattern() {
            return pattern;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailSensitiveInformationAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        @Override
        public GuardrailRegex build() {
            return new GuardrailRegex(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
