/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProvisionedModelThroughputRequest extends BedrockRequest implements
        ToCopyableBuilder<UpdateProvisionedModelThroughputRequest.Builder, UpdateProvisionedModelThroughputRequest> {
    private static final SdkField<String> PROVISIONED_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provisionedModelId").getter(getter(UpdateProvisionedModelThroughputRequest::provisionedModelId))
            .setter(setter(Builder::provisionedModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("provisionedModelId").build()).build();

    private static final SdkField<String> DESIRED_PROVISIONED_MODEL_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("desiredProvisionedModelName")
            .getter(getter(UpdateProvisionedModelThroughputRequest::desiredProvisionedModelName))
            .setter(setter(Builder::desiredProvisionedModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredProvisionedModelName")
                    .build()).build();

    private static final SdkField<String> DESIRED_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desiredModelId").getter(getter(UpdateProvisionedModelThroughputRequest::desiredModelId))
            .setter(setter(Builder::desiredModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredModelId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_MODEL_ID_FIELD,
            DESIRED_PROVISIONED_MODEL_NAME_FIELD, DESIRED_MODEL_ID_FIELD));

    private final String provisionedModelId;

    private final String desiredProvisionedModelName;

    private final String desiredModelId;

    private UpdateProvisionedModelThroughputRequest(BuilderImpl builder) {
        super(builder);
        this.provisionedModelId = builder.provisionedModelId;
        this.desiredProvisionedModelName = builder.desiredProvisionedModelName;
        this.desiredModelId = builder.desiredModelId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or name of the Provisioned Throughput to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or name of the Provisioned Throughput to update.
     */
    public final String provisionedModelId() {
        return provisionedModelId;
    }

    /**
     * <p>
     * The new name for this Provisioned Throughput.
     * </p>
     * 
     * @return The new name for this Provisioned Throughput.
     */
    public final String desiredProvisionedModelName() {
        return desiredProvisionedModelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the new model to associate with this Provisioned Throughput. You can't specify
     * this field if this Provisioned Throughput is associated with a base model.
     * </p>
     * <p>
     * If this Provisioned Throughput is associated with a custom model, you can specify one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The base model from which the custom model was customized.
     * </p>
     * </li>
     * <li>
     * <p>
     * Another custom model that was customized from the same base model as the custom model.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of the new model to associate with this Provisioned Throughput. You can't
     *         specify this field if this Provisioned Throughput is associated with a base model.</p>
     *         <p>
     *         If this Provisioned Throughput is associated with a custom model, you can specify one of the following
     *         options:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The base model from which the custom model was customized.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Another custom model that was customized from the same base model as the custom model.
     *         </p>
     *         </li>
     */
    public final String desiredModelId() {
        return desiredModelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(provisionedModelId());
        hashCode = 31 * hashCode + Objects.hashCode(desiredProvisionedModelName());
        hashCode = 31 * hashCode + Objects.hashCode(desiredModelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisionedModelThroughputRequest)) {
            return false;
        }
        UpdateProvisionedModelThroughputRequest other = (UpdateProvisionedModelThroughputRequest) obj;
        return Objects.equals(provisionedModelId(), other.provisionedModelId())
                && Objects.equals(desiredProvisionedModelName(), other.desiredProvisionedModelName())
                && Objects.equals(desiredModelId(), other.desiredModelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProvisionedModelThroughputRequest").add("ProvisionedModelId", provisionedModelId())
                .add("DesiredProvisionedModelName", desiredProvisionedModelName()).add("DesiredModelId", desiredModelId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "provisionedModelId":
            return Optional.ofNullable(clazz.cast(provisionedModelId()));
        case "desiredProvisionedModelName":
            return Optional.ofNullable(clazz.cast(desiredProvisionedModelName()));
        case "desiredModelId":
            return Optional.ofNullable(clazz.cast(desiredModelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProvisionedModelThroughputRequest, T> g) {
        return obj -> g.apply((UpdateProvisionedModelThroughputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProvisionedModelThroughputRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) or name of the Provisioned Throughput to update.
         * </p>
         * 
         * @param provisionedModelId
         *        The Amazon Resource Name (ARN) or name of the Provisioned Throughput to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedModelId(String provisionedModelId);

        /**
         * <p>
         * The new name for this Provisioned Throughput.
         * </p>
         * 
         * @param desiredProvisionedModelName
         *        The new name for this Provisioned Throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredProvisionedModelName(String desiredProvisionedModelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the new model to associate with this Provisioned Throughput. You can't
         * specify this field if this Provisioned Throughput is associated with a base model.
         * </p>
         * <p>
         * If this Provisioned Throughput is associated with a custom model, you can specify one of the following
         * options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The base model from which the custom model was customized.
         * </p>
         * </li>
         * <li>
         * <p>
         * Another custom model that was customized from the same base model as the custom model.
         * </p>
         * </li>
         * </ul>
         * 
         * @param desiredModelId
         *        The Amazon Resource Name (ARN) of the new model to associate with this Provisioned Throughput. You
         *        can't specify this field if this Provisioned Throughput is associated with a base model.</p>
         *        <p>
         *        If this Provisioned Throughput is associated with a custom model, you can specify one of the following
         *        options:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The base model from which the custom model was customized.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Another custom model that was customized from the same base model as the custom model.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredModelId(String desiredModelId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String provisionedModelId;

        private String desiredProvisionedModelName;

        private String desiredModelId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisionedModelThroughputRequest model) {
            super(model);
            provisionedModelId(model.provisionedModelId);
            desiredProvisionedModelName(model.desiredProvisionedModelName);
            desiredModelId(model.desiredModelId);
        }

        public final String getProvisionedModelId() {
            return provisionedModelId;
        }

        public final void setProvisionedModelId(String provisionedModelId) {
            this.provisionedModelId = provisionedModelId;
        }

        @Override
        public final Builder provisionedModelId(String provisionedModelId) {
            this.provisionedModelId = provisionedModelId;
            return this;
        }

        public final String getDesiredProvisionedModelName() {
            return desiredProvisionedModelName;
        }

        public final void setDesiredProvisionedModelName(String desiredProvisionedModelName) {
            this.desiredProvisionedModelName = desiredProvisionedModelName;
        }

        @Override
        public final Builder desiredProvisionedModelName(String desiredProvisionedModelName) {
            this.desiredProvisionedModelName = desiredProvisionedModelName;
            return this;
        }

        public final String getDesiredModelId() {
            return desiredModelId;
        }

        public final void setDesiredModelId(String desiredModelId) {
            this.desiredModelId = desiredModelId;
        }

        @Override
        public final Builder desiredModelId(String desiredModelId) {
            this.desiredModelId = desiredModelId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProvisionedModelThroughputRequest build() {
            return new UpdateProvisionedModelThroughputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
