/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the models used in the model evaluation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationModelConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationModelConfig.Builder, EvaluationModelConfig> {
    private static final SdkField<EvaluationBedrockModel> BEDROCK_MODEL_FIELD = SdkField
            .<EvaluationBedrockModel> builder(MarshallingType.SDK_POJO).memberName("bedrockModel")
            .getter(getter(EvaluationModelConfig::bedrockModel)).setter(setter(Builder::bedrockModel))
            .constructor(EvaluationBedrockModel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockModel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEDROCK_MODEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final EvaluationBedrockModel bedrockModel;

    private final Type type;

    private EvaluationModelConfig(BuilderImpl builder) {
        this.bedrockModel = builder.bedrockModel;
        this.type = builder.type;
    }

    /**
     * <p>
     * Defines the Amazon Bedrock model or inference profile and inference parameters you want used.
     * </p>
     * 
     * @return Defines the Amazon Bedrock model or inference profile and inference parameters you want used.
     */
    public final EvaluationBedrockModel bedrockModel() {
        return bedrockModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bedrockModel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationModelConfig)) {
            return false;
        }
        EvaluationModelConfig other = (EvaluationModelConfig) obj;
        return Objects.equals(bedrockModel(), other.bedrockModel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationModelConfig").add("BedrockModel", bedrockModel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bedrockModel":
            return Optional.ofNullable(clazz.cast(bedrockModel()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #bedrockModel()} initialized to the given value.
     *
     * <p>
     * Defines the Amazon Bedrock model or inference profile and inference parameters you want used.
     * </p>
     * 
     * @param bedrockModel
     *        Defines the Amazon Bedrock model or inference profile and inference parameters you want used.
     */
    public static EvaluationModelConfig fromBedrockModel(EvaluationBedrockModel bedrockModel) {
        return builder().bedrockModel(bedrockModel).build();
    }

    /**
     * Create an instance of this class with {@link #bedrockModel()} initialized to the given value.
     *
     * <p>
     * Defines the Amazon Bedrock model or inference profile and inference parameters you want used.
     * </p>
     * 
     * @param bedrockModel
     *        Defines the Amazon Bedrock model or inference profile and inference parameters you want used.
     */
    public static EvaluationModelConfig fromBedrockModel(Consumer<EvaluationBedrockModel.Builder> bedrockModel) {
        EvaluationBedrockModel.Builder builder = EvaluationBedrockModel.builder();
        bedrockModel.accept(builder);
        return fromBedrockModel(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationModelConfig, T> g) {
        return obj -> g.apply((EvaluationModelConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationModelConfig> {
        /**
         * <p>
         * Defines the Amazon Bedrock model or inference profile and inference parameters you want used.
         * </p>
         * 
         * @param bedrockModel
         *        Defines the Amazon Bedrock model or inference profile and inference parameters you want used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockModel(EvaluationBedrockModel bedrockModel);

        /**
         * <p>
         * Defines the Amazon Bedrock model or inference profile and inference parameters you want used.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationBedrockModel.Builder} avoiding
         * the need to create one manually via {@link EvaluationBedrockModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationBedrockModel.Builder#build()} is called immediately and
         * its result is passed to {@link #bedrockModel(EvaluationBedrockModel)}.
         * 
         * @param bedrockModel
         *        a consumer that will call methods on {@link EvaluationBedrockModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bedrockModel(EvaluationBedrockModel)
         */
        default Builder bedrockModel(Consumer<EvaluationBedrockModel.Builder> bedrockModel) {
            return bedrockModel(EvaluationBedrockModel.builder().applyMutation(bedrockModel).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EvaluationBedrockModel bedrockModel;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationModelConfig model) {
            bedrockModel(model.bedrockModel);
        }

        public final EvaluationBedrockModel.Builder getBedrockModel() {
            return bedrockModel != null ? bedrockModel.toBuilder() : null;
        }

        public final void setBedrockModel(EvaluationBedrockModel.BuilderImpl bedrockModel) {
            Object oldValue = this.bedrockModel;
            this.bedrockModel = bedrockModel != null ? bedrockModel.build() : null;
            handleUnionValueChange(Type.BEDROCK_MODEL, oldValue, this.bedrockModel);
        }

        @Override
        public final Builder bedrockModel(EvaluationBedrockModel bedrockModel) {
            Object oldValue = this.bedrockModel;
            this.bedrockModel = bedrockModel;
            handleUnionValueChange(Type.BEDROCK_MODEL, oldValue, this.bedrockModel);
            return this;
        }

        @Override
        public EvaluationModelConfig build() {
            return new EvaluationModelConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EvaluationModelConfig#type()
     */
    public enum Type {
        BEDROCK_MODEL,

        UNKNOWN_TO_SDK_VERSION
    }
}
