/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetImportedModelResponse extends BedrockResponse implements
        ToCopyableBuilder<GetImportedModelResponse.Builder, GetImportedModelResponse> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(GetImportedModelResponse::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelName").getter(getter(GetImportedModelResponse::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelName").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(GetImportedModelResponse::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(GetImportedModelResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<ModelDataSource> MODEL_DATA_SOURCE_FIELD = SdkField
            .<ModelDataSource> builder(MarshallingType.SDK_POJO).memberName("modelDataSource")
            .getter(getter(GetImportedModelResponse::modelDataSource)).setter(setter(Builder::modelDataSource))
            .constructor(ModelDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelDataSource").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetImportedModelResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> MODEL_ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArchitecture").getter(getter(GetImportedModelResponse::modelArchitecture))
            .setter(setter(Builder::modelArchitecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArchitecture").build()).build();

    private static final SdkField<String> MODEL_KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelKmsKeyArn").getter(getter(GetImportedModelResponse::modelKmsKeyArn))
            .setter(setter(Builder::modelKmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelKmsKeyArn").build()).build();

    private static final SdkField<Boolean> INSTRUCT_SUPPORTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("instructSupported").getter(getter(GetImportedModelResponse::instructSupported))
            .setter(setter(Builder::instructSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructSupported").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD,
            MODEL_NAME_FIELD, JOB_NAME_FIELD, JOB_ARN_FIELD, MODEL_DATA_SOURCE_FIELD, CREATION_TIME_FIELD,
            MODEL_ARCHITECTURE_FIELD, MODEL_KMS_KEY_ARN_FIELD, INSTRUCT_SUPPORTED_FIELD));

    private final String modelArn;

    private final String modelName;

    private final String jobName;

    private final String jobArn;

    private final ModelDataSource modelDataSource;

    private final Instant creationTime;

    private final String modelArchitecture;

    private final String modelKmsKeyArn;

    private final Boolean instructSupported;

    private GetImportedModelResponse(BuilderImpl builder) {
        super(builder);
        this.modelArn = builder.modelArn;
        this.modelName = builder.modelName;
        this.jobName = builder.jobName;
        this.jobArn = builder.jobArn;
        this.modelDataSource = builder.modelDataSource;
        this.creationTime = builder.creationTime;
        this.modelArchitecture = builder.modelArchitecture;
        this.modelKmsKeyArn = builder.modelKmsKeyArn;
        this.instructSupported = builder.instructSupported;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with this imported model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with this imported model.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The name of the imported model.
     * </p>
     * 
     * @return The name of the imported model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * Job name associated with the imported model.
     * </p>
     * 
     * @return Job name associated with the imported model.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * Job Amazon Resource Name (ARN) associated with the imported model.
     * </p>
     * 
     * @return Job Amazon Resource Name (ARN) associated with the imported model.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The data source for this imported model.
     * </p>
     * 
     * @return The data source for this imported model.
     */
    public final ModelDataSource modelDataSource() {
        return modelDataSource;
    }

    /**
     * <p>
     * Creation time of the imported model.
     * </p>
     * 
     * @return Creation time of the imported model.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The architecture of the imported model.
     * </p>
     * 
     * @return The architecture of the imported model.
     */
    public final String modelArchitecture() {
        return modelArchitecture;
    }

    /**
     * <p>
     * The imported model is encrypted at rest using this key.
     * </p>
     * 
     * @return The imported model is encrypted at rest using this key.
     */
    public final String modelKmsKeyArn() {
        return modelKmsKeyArn;
    }

    /**
     * <p>
     * Specifies if the imported model supports converse.
     * </p>
     * 
     * @return Specifies if the imported model supports converse.
     */
    public final Boolean instructSupported() {
        return instructSupported;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(modelArchitecture());
        hashCode = 31 * hashCode + Objects.hashCode(modelKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(instructSupported());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImportedModelResponse)) {
            return false;
        }
        GetImportedModelResponse other = (GetImportedModelResponse) obj;
        return Objects.equals(modelArn(), other.modelArn()) && Objects.equals(modelName(), other.modelName())
                && Objects.equals(jobName(), other.jobName()) && Objects.equals(jobArn(), other.jobArn())
                && Objects.equals(modelDataSource(), other.modelDataSource())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(modelArchitecture(), other.modelArchitecture())
                && Objects.equals(modelKmsKeyArn(), other.modelKmsKeyArn())
                && Objects.equals(instructSupported(), other.instructSupported());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetImportedModelResponse").add("ModelArn", modelArn()).add("ModelName", modelName())
                .add("JobName", jobName()).add("JobArn", jobArn()).add("ModelDataSource", modelDataSource())
                .add("CreationTime", creationTime()).add("ModelArchitecture", modelArchitecture())
                .add("ModelKmsKeyArn", modelKmsKeyArn()).add("InstructSupported", instructSupported()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "modelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "modelDataSource":
            return Optional.ofNullable(clazz.cast(modelDataSource()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "modelArchitecture":
            return Optional.ofNullable(clazz.cast(modelArchitecture()));
        case "modelKmsKeyArn":
            return Optional.ofNullable(clazz.cast(modelKmsKeyArn()));
        case "instructSupported":
            return Optional.ofNullable(clazz.cast(instructSupported()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetImportedModelResponse, T> g) {
        return obj -> g.apply((GetImportedModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetImportedModelResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with this imported model.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) associated with this imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The name of the imported model.
         * </p>
         * 
         * @param modelName
         *        The name of the imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * Job name associated with the imported model.
         * </p>
         * 
         * @param jobName
         *        Job name associated with the imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * Job Amazon Resource Name (ARN) associated with the imported model.
         * </p>
         * 
         * @param jobArn
         *        Job Amazon Resource Name (ARN) associated with the imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The data source for this imported model.
         * </p>
         * 
         * @param modelDataSource
         *        The data source for this imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDataSource(ModelDataSource modelDataSource);

        /**
         * <p>
         * The data source for this imported model.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelDataSource.Builder} avoiding the
         * need to create one manually via {@link ModelDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #modelDataSource(ModelDataSource)}.
         * 
         * @param modelDataSource
         *        a consumer that will call methods on {@link ModelDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDataSource(ModelDataSource)
         */
        default Builder modelDataSource(Consumer<ModelDataSource.Builder> modelDataSource) {
            return modelDataSource(ModelDataSource.builder().applyMutation(modelDataSource).build());
        }

        /**
         * <p>
         * Creation time of the imported model.
         * </p>
         * 
         * @param creationTime
         *        Creation time of the imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The architecture of the imported model.
         * </p>
         * 
         * @param modelArchitecture
         *        The architecture of the imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArchitecture(String modelArchitecture);

        /**
         * <p>
         * The imported model is encrypted at rest using this key.
         * </p>
         * 
         * @param modelKmsKeyArn
         *        The imported model is encrypted at rest using this key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelKmsKeyArn(String modelKmsKeyArn);

        /**
         * <p>
         * Specifies if the imported model supports converse.
         * </p>
         * 
         * @param instructSupported
         *        Specifies if the imported model supports converse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instructSupported(Boolean instructSupported);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String modelArn;

        private String modelName;

        private String jobName;

        private String jobArn;

        private ModelDataSource modelDataSource;

        private Instant creationTime;

        private String modelArchitecture;

        private String modelKmsKeyArn;

        private Boolean instructSupported;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImportedModelResponse model) {
            super(model);
            modelArn(model.modelArn);
            modelName(model.modelName);
            jobName(model.jobName);
            jobArn(model.jobArn);
            modelDataSource(model.modelDataSource);
            creationTime(model.creationTime);
            modelArchitecture(model.modelArchitecture);
            modelKmsKeyArn(model.modelKmsKeyArn);
            instructSupported(model.instructSupported);
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final ModelDataSource.Builder getModelDataSource() {
            return modelDataSource != null ? modelDataSource.toBuilder() : null;
        }

        public final void setModelDataSource(ModelDataSource.BuilderImpl modelDataSource) {
            this.modelDataSource = modelDataSource != null ? modelDataSource.build() : null;
        }

        @Override
        public final Builder modelDataSource(ModelDataSource modelDataSource) {
            this.modelDataSource = modelDataSource;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getModelArchitecture() {
            return modelArchitecture;
        }

        public final void setModelArchitecture(String modelArchitecture) {
            this.modelArchitecture = modelArchitecture;
        }

        @Override
        public final Builder modelArchitecture(String modelArchitecture) {
            this.modelArchitecture = modelArchitecture;
            return this;
        }

        public final String getModelKmsKeyArn() {
            return modelKmsKeyArn;
        }

        public final void setModelKmsKeyArn(String modelKmsKeyArn) {
            this.modelKmsKeyArn = modelKmsKeyArn;
        }

        @Override
        public final Builder modelKmsKeyArn(String modelKmsKeyArn) {
            this.modelKmsKeyArn = modelKmsKeyArn;
            return this;
        }

        public final Boolean getInstructSupported() {
            return instructSupported;
        }

        public final void setInstructSupported(Boolean instructSupported) {
            this.instructSupported = instructSupported;
        }

        @Override
        public final Builder instructSupported(Boolean instructSupported) {
            this.instructSupported = instructSupported;
            return this;
        }

        @Override
        public GetImportedModelResponse build() {
            return new GetImportedModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
