/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.S3InputFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelInvocationJobS3InputDataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelInvocationJobS3InputDataConfig> {
    private static final SdkField<String> S3_INPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3InputFormat").getter(ModelInvocationJobS3InputDataConfig.getter(ModelInvocationJobS3InputDataConfig::s3InputFormatAsString)).setter(ModelInvocationJobS3InputDataConfig.setter(Builder::s3InputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3InputFormat").build()}).build();
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Uri").getter(ModelInvocationJobS3InputDataConfig.getter(ModelInvocationJobS3InputDataConfig::s3Uri)).setter(ModelInvocationJobS3InputDataConfig.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()}).build();
    private static final SdkField<String> S3_BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketOwner").getter(ModelInvocationJobS3InputDataConfig.getter(ModelInvocationJobS3InputDataConfig::s3BucketOwner)).setter(ModelInvocationJobS3InputDataConfig.setter(Builder::s3BucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_INPUT_FORMAT_FIELD, S3_URI_FIELD, S3_BUCKET_OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("s3InputFormat", S3_INPUT_FORMAT_FIELD);
            this.put("s3Uri", S3_URI_FIELD);
            this.put("s3BucketOwner", S3_BUCKET_OWNER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String s3InputFormat;
    private final String s3Uri;
    private final String s3BucketOwner;

    private ModelInvocationJobS3InputDataConfig(BuilderImpl builder) {
        this.s3InputFormat = builder.s3InputFormat;
        this.s3Uri = builder.s3Uri;
        this.s3BucketOwner = builder.s3BucketOwner;
    }

    public final S3InputFormat s3InputFormat() {
        return S3InputFormat.fromValue(this.s3InputFormat);
    }

    public final String s3InputFormatAsString() {
        return this.s3InputFormat;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final String s3BucketOwner() {
        return this.s3BucketOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3InputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelInvocationJobS3InputDataConfig)) {
            return false;
        }
        ModelInvocationJobS3InputDataConfig other = (ModelInvocationJobS3InputDataConfig)obj;
        return Objects.equals(this.s3InputFormatAsString(), other.s3InputFormatAsString()) && Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.s3BucketOwner(), other.s3BucketOwner());
    }

    public final String toString() {
        return ToString.builder((String)"ModelInvocationJobS3InputDataConfig").add("S3InputFormat", (Object)this.s3InputFormatAsString()).add("S3Uri", (Object)this.s3Uri()).add("S3BucketOwner", (Object)this.s3BucketOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3InputFormat": {
                return Optional.ofNullable(clazz.cast(this.s3InputFormatAsString()));
            }
            case "s3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "s3BucketOwner": {
                return Optional.ofNullable(clazz.cast(this.s3BucketOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModelInvocationJobS3InputDataConfig, T> g) {
        return obj -> g.apply((ModelInvocationJobS3InputDataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3InputFormat;
        private String s3Uri;
        private String s3BucketOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelInvocationJobS3InputDataConfig model) {
            this.s3InputFormat(model.s3InputFormat);
            this.s3Uri(model.s3Uri);
            this.s3BucketOwner(model.s3BucketOwner);
        }

        public final String getS3InputFormat() {
            return this.s3InputFormat;
        }

        public final void setS3InputFormat(String s3InputFormat) {
            this.s3InputFormat = s3InputFormat;
        }

        @Override
        public final Builder s3InputFormat(String s3InputFormat) {
            this.s3InputFormat = s3InputFormat;
            return this;
        }

        @Override
        public final Builder s3InputFormat(S3InputFormat s3InputFormat) {
            this.s3InputFormat(s3InputFormat == null ? null : s3InputFormat.toString());
            return this;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getS3BucketOwner() {
            return this.s3BucketOwner;
        }

        public final void setS3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
        }

        @Override
        public final Builder s3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
            return this;
        }

        public ModelInvocationJobS3InputDataConfig build() {
            return new ModelInvocationJobS3InputDataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelInvocationJobS3InputDataConfig> {
        public Builder s3InputFormat(String var1);

        public Builder s3InputFormat(S3InputFormat var1);

        public Builder s3Uri(String var1);

        public Builder s3BucketOwner(String var1);
    }
}

