/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.FoundationModelSummary;
import software.amazon.awssdk.services.bedrock.model.FoundationModelSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFoundationModelsResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListFoundationModelsResponse> {
    private static final SdkField<List<FoundationModelSummary>> MODEL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelSummaries").getter(ListFoundationModelsResponse.getter(ListFoundationModelsResponse::modelSummaries)).setter(ListFoundationModelsResponse.setter(Builder::modelSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FoundationModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("modelSummaries", MODEL_SUMMARIES_FIELD);
        }
    });
    private final List<FoundationModelSummary> modelSummaries;

    private ListFoundationModelsResponse(BuilderImpl builder) {
        super(builder);
        this.modelSummaries = builder.modelSummaries;
    }

    public final boolean hasModelSummaries() {
        return this.modelSummaries != null && !(this.modelSummaries instanceof SdkAutoConstructList);
    }

    public final List<FoundationModelSummary> modelSummaries() {
        return this.modelSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelSummaries() ? this.modelSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFoundationModelsResponse)) {
            return false;
        }
        ListFoundationModelsResponse other = (ListFoundationModelsResponse)((Object)obj);
        return this.hasModelSummaries() == other.hasModelSummaries() && Objects.equals(this.modelSummaries(), other.modelSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListFoundationModelsResponse").add("ModelSummaries", this.hasModelSummaries() ? this.modelSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelSummaries": {
                return Optional.ofNullable(clazz.cast(this.modelSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListFoundationModelsResponse, T> g) {
        return obj -> g.apply((ListFoundationModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private List<FoundationModelSummary> modelSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFoundationModelsResponse model) {
            super(model);
            this.modelSummaries(model.modelSummaries);
        }

        public final List<FoundationModelSummary.Builder> getModelSummaries() {
            List<FoundationModelSummary.Builder> result = FoundationModelSummaryListCopier.copyToBuilder(this.modelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelSummaries(Collection<FoundationModelSummary.BuilderImpl> modelSummaries) {
            this.modelSummaries = FoundationModelSummaryListCopier.copyFromBuilder(modelSummaries);
        }

        @Override
        public final Builder modelSummaries(Collection<FoundationModelSummary> modelSummaries) {
            this.modelSummaries = FoundationModelSummaryListCopier.copy(modelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelSummaries(FoundationModelSummary ... modelSummaries) {
            this.modelSummaries(Arrays.asList(modelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelSummaries(Consumer<FoundationModelSummary.Builder> ... modelSummaries) {
            this.modelSummaries(Stream.of(modelSummaries).map(c -> (FoundationModelSummary)((FoundationModelSummary.Builder)FoundationModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFoundationModelsResponse build() {
            return new ListFoundationModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFoundationModelsResponse> {
        public Builder modelSummaries(Collection<FoundationModelSummary> var1);

        public Builder modelSummaries(FoundationModelSummary ... var1);

        public Builder modelSummaries(Consumer<FoundationModelSummary.Builder> ... var1);
    }
}

