/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON array that provides the status of the model evaluation jobs being deleted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteEvaluationJobError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDeleteEvaluationJobError.Builder, BatchDeleteEvaluationJobError> {
    private static final SdkField<String> JOB_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobIdentifier").getter(getter(BatchDeleteEvaluationJobError::jobIdentifier))
            .setter(setter(Builder::jobIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobIdentifier").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(BatchDeleteEvaluationJobError::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(BatchDeleteEvaluationJobError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_IDENTIFIER_FIELD,
            CODE_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobIdentifier;

    private final String code;

    private final String message;

    private BatchDeleteEvaluationJobError(BuilderImpl builder) {
        this.jobIdentifier = builder.jobIdentifier;
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The ARN of the model evaluation job being deleted.
     * </p>
     * 
     * @return The ARN of the model evaluation job being deleted.
     */
    public final String jobIdentifier() {
        return jobIdentifier;
    }

    /**
     * <p>
     * A HTTP status code of the model evaluation job being deleted.
     * </p>
     * 
     * @return A HTTP status code of the model evaluation job being deleted.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * A status message about the model evaluation job deletion.
     * </p>
     * 
     * @return A status message about the model evaluation job deletion.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteEvaluationJobError)) {
            return false;
        }
        BatchDeleteEvaluationJobError other = (BatchDeleteEvaluationJobError) obj;
        return Objects.equals(jobIdentifier(), other.jobIdentifier()) && Objects.equals(code(), other.code())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteEvaluationJobError")
                .add("JobIdentifier", jobIdentifier() == null ? null : "*** Sensitive Data Redacted ***").add("Code", code())
                .add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobIdentifier":
            return Optional.ofNullable(clazz.cast(jobIdentifier()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteEvaluationJobError, T> g) {
        return obj -> g.apply((BatchDeleteEvaluationJobError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDeleteEvaluationJobError> {
        /**
         * <p>
         * The ARN of the model evaluation job being deleted.
         * </p>
         * 
         * @param jobIdentifier
         *        The ARN of the model evaluation job being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobIdentifier(String jobIdentifier);

        /**
         * <p>
         * A HTTP status code of the model evaluation job being deleted.
         * </p>
         * 
         * @param code
         *        A HTTP status code of the model evaluation job being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * A status message about the model evaluation job deletion.
         * </p>
         * 
         * @param message
         *        A status message about the model evaluation job deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String jobIdentifier;

        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteEvaluationJobError model) {
            jobIdentifier(model.jobIdentifier);
            code(model.code);
            message(model.message);
        }

        public final String getJobIdentifier() {
            return jobIdentifier;
        }

        public final void setJobIdentifier(String jobIdentifier) {
            this.jobIdentifier = jobIdentifier;
        }

        @Override
        public final Builder jobIdentifier(String jobIdentifier) {
            this.jobIdentifier = jobIdentifier;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BatchDeleteEvaluationJobError build() {
            return new BatchDeleteEvaluationJobError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
