/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelImportJobRequest extends BedrockRequest implements
        ToCopyableBuilder<CreateModelImportJobRequest.Builder, CreateModelImportJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(CreateModelImportJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> IMPORTED_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importedModelName").getter(getter(CreateModelImportJobRequest::importedModelName))
            .setter(setter(Builder::importedModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateModelImportJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<ModelDataSource> MODEL_DATA_SOURCE_FIELD = SdkField
            .<ModelDataSource> builder(MarshallingType.SDK_POJO).memberName("modelDataSource")
            .getter(getter(CreateModelImportJobRequest::modelDataSource)).setter(setter(Builder::modelDataSource))
            .constructor(ModelDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelDataSource").build()).build();

    private static final SdkField<List<Tag>> JOB_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("jobTags")
            .getter(getter(CreateModelImportJobRequest::jobTags))
            .setter(setter(Builder::jobTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> IMPORTED_MODEL_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("importedModelTags")
            .getter(getter(CreateModelImportJobRequest::importedModelTags))
            .setter(setter(Builder::importedModelTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(CreateModelImportJobRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("vpcConfig").getter(getter(CreateModelImportJobRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<String> IMPORTED_MODEL_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importedModelKmsKeyId").getter(getter(CreateModelImportJobRequest::importedModelKmsKeyId))
            .setter(setter(Builder::importedModelKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelKmsKeyId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            IMPORTED_MODEL_NAME_FIELD, ROLE_ARN_FIELD, MODEL_DATA_SOURCE_FIELD, JOB_TAGS_FIELD, IMPORTED_MODEL_TAGS_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, VPC_CONFIG_FIELD, IMPORTED_MODEL_KMS_KEY_ID_FIELD));

    private final String jobName;

    private final String importedModelName;

    private final String roleArn;

    private final ModelDataSource modelDataSource;

    private final List<Tag> jobTags;

    private final List<Tag> importedModelTags;

    private final String clientRequestToken;

    private final VpcConfig vpcConfig;

    private final String importedModelKmsKeyId;

    private CreateModelImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.importedModelName = builder.importedModelName;
        this.roleArn = builder.roleArn;
        this.modelDataSource = builder.modelDataSource;
        this.jobTags = builder.jobTags;
        this.importedModelTags = builder.importedModelTags;
        this.clientRequestToken = builder.clientRequestToken;
        this.vpcConfig = builder.vpcConfig;
        this.importedModelKmsKeyId = builder.importedModelKmsKeyId;
    }

    /**
     * <p>
     * The name of the import job.
     * </p>
     * 
     * @return The name of the import job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The name of the imported model.
     * </p>
     * 
     * @return The name of the imported model.
     */
    public final String importedModelName() {
        return importedModelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model import job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model import job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The data source for the imported model.
     * </p>
     * 
     * @return The data source for the imported model.
     */
    public final ModelDataSource modelDataSource() {
        return modelDataSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobTags() {
        return jobTags != null && !(jobTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to attach to this import job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobTags} method.
     * </p>
     * 
     * @return Tags to attach to this import job.
     */
    public final List<Tag> jobTags() {
        return jobTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImportedModelTags property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImportedModelTags() {
        return importedModelTags != null && !(importedModelTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to attach to the imported model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImportedModelTags} method.
     * </p>
     * 
     * @return Tags to attach to the imported model.
     */
    public final List<Tag> importedModelTags() {
        return importedModelTags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
     *         this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * VPC configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are
     * using for the import job.
     * </p>
     * 
     * @return VPC configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you
     *         are using for the import job.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The imported model is encrypted at rest using this key.
     * </p>
     * 
     * @return The imported model is encrypted at rest using this key.
     */
    public final String importedModelKmsKeyId() {
        return importedModelKmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(importedModelName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasJobTags() ? jobTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImportedModelTags() ? importedModelTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(importedModelKmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelImportJobRequest)) {
            return false;
        }
        CreateModelImportJobRequest other = (CreateModelImportJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(importedModelName(), other.importedModelName())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(modelDataSource(), other.modelDataSource())
                && hasJobTags() == other.hasJobTags() && Objects.equals(jobTags(), other.jobTags())
                && hasImportedModelTags() == other.hasImportedModelTags()
                && Objects.equals(importedModelTags(), other.importedModelTags())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(importedModelKmsKeyId(), other.importedModelKmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateModelImportJobRequest").add("JobName", jobName())
                .add("ImportedModelName", importedModelName()).add("RoleArn", roleArn())
                .add("ModelDataSource", modelDataSource()).add("JobTags", hasJobTags() ? jobTags() : null)
                .add("ImportedModelTags", hasImportedModelTags() ? importedModelTags() : null)
                .add("ClientRequestToken", clientRequestToken()).add("VpcConfig", vpcConfig())
                .add("ImportedModelKmsKeyId", importedModelKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "importedModelName":
            return Optional.ofNullable(clazz.cast(importedModelName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "modelDataSource":
            return Optional.ofNullable(clazz.cast(modelDataSource()));
        case "jobTags":
            return Optional.ofNullable(clazz.cast(jobTags()));
        case "importedModelTags":
            return Optional.ofNullable(clazz.cast(importedModelTags()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "importedModelKmsKeyId":
            return Optional.ofNullable(clazz.cast(importedModelKmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelImportJobRequest, T> g) {
        return obj -> g.apply((CreateModelImportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateModelImportJobRequest> {
        /**
         * <p>
         * The name of the import job.
         * </p>
         * 
         * @param jobName
         *        The name of the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The name of the imported model.
         * </p>
         * 
         * @param importedModelName
         *        The name of the imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedModelName(String importedModelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model import job.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the model import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The data source for the imported model.
         * </p>
         * 
         * @param modelDataSource
         *        The data source for the imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDataSource(ModelDataSource modelDataSource);

        /**
         * <p>
         * The data source for the imported model.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelDataSource.Builder} avoiding the
         * need to create one manually via {@link ModelDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #modelDataSource(ModelDataSource)}.
         * 
         * @param modelDataSource
         *        a consumer that will call methods on {@link ModelDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDataSource(ModelDataSource)
         */
        default Builder modelDataSource(Consumer<ModelDataSource.Builder> modelDataSource) {
            return modelDataSource(ModelDataSource.builder().applyMutation(modelDataSource).build());
        }

        /**
         * <p>
         * Tags to attach to this import job.
         * </p>
         * 
         * @param jobTags
         *        Tags to attach to this import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTags(Collection<Tag> jobTags);

        /**
         * <p>
         * Tags to attach to this import job.
         * </p>
         * 
         * @param jobTags
         *        Tags to attach to this import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTags(Tag... jobTags);

        /**
         * <p>
         * Tags to attach to this import job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.bedrock.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #jobTags(List<Tag>)}.
         * 
         * @param jobTags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobTags(java.util.Collection<Tag>)
         */
        Builder jobTags(Consumer<Tag.Builder>... jobTags);

        /**
         * <p>
         * Tags to attach to the imported model.
         * </p>
         * 
         * @param importedModelTags
         *        Tags to attach to the imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedModelTags(Collection<Tag> importedModelTags);

        /**
         * <p>
         * Tags to attach to the imported model.
         * </p>
         * 
         * @param importedModelTags
         *        Tags to attach to the imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedModelTags(Tag... importedModelTags);

        /**
         * <p>
         * Tags to attach to the imported model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.bedrock.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #importedModelTags(List<Tag>)}.
         * 
         * @param importedModelTags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importedModelTags(java.util.Collection<Tag>)
         */
        Builder importedModelTags(Consumer<Tag.Builder>... importedModelTags);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * VPC configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are
         * using for the import job.
         * </p>
         * 
         * @param vpcConfig
         *        VPC configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources
         *        you are using for the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * VPC configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are
         * using for the import job.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The imported model is encrypted at rest using this key.
         * </p>
         * 
         * @param importedModelKmsKeyId
         *        The imported model is encrypted at rest using this key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedModelKmsKeyId(String importedModelKmsKeyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String jobName;

        private String importedModelName;

        private String roleArn;

        private ModelDataSource modelDataSource;

        private List<Tag> jobTags = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> importedModelTags = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private VpcConfig vpcConfig;

        private String importedModelKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelImportJobRequest model) {
            super(model);
            jobName(model.jobName);
            importedModelName(model.importedModelName);
            roleArn(model.roleArn);
            modelDataSource(model.modelDataSource);
            jobTags(model.jobTags);
            importedModelTags(model.importedModelTags);
            clientRequestToken(model.clientRequestToken);
            vpcConfig(model.vpcConfig);
            importedModelKmsKeyId(model.importedModelKmsKeyId);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getImportedModelName() {
            return importedModelName;
        }

        public final void setImportedModelName(String importedModelName) {
            this.importedModelName = importedModelName;
        }

        @Override
        public final Builder importedModelName(String importedModelName) {
            this.importedModelName = importedModelName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ModelDataSource.Builder getModelDataSource() {
            return modelDataSource != null ? modelDataSource.toBuilder() : null;
        }

        public final void setModelDataSource(ModelDataSource.BuilderImpl modelDataSource) {
            this.modelDataSource = modelDataSource != null ? modelDataSource.build() : null;
        }

        @Override
        public final Builder modelDataSource(ModelDataSource modelDataSource) {
            this.modelDataSource = modelDataSource;
            return this;
        }

        public final List<Tag.Builder> getJobTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.jobTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobTags(Collection<Tag.BuilderImpl> jobTags) {
            this.jobTags = TagListCopier.copyFromBuilder(jobTags);
        }

        @Override
        public final Builder jobTags(Collection<Tag> jobTags) {
            this.jobTags = TagListCopier.copy(jobTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(Tag... jobTags) {
            jobTags(Arrays.asList(jobTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(Consumer<Tag.Builder>... jobTags) {
            jobTags(Stream.of(jobTags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getImportedModelTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.importedModelTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportedModelTags(Collection<Tag.BuilderImpl> importedModelTags) {
            this.importedModelTags = TagListCopier.copyFromBuilder(importedModelTags);
        }

        @Override
        public final Builder importedModelTags(Collection<Tag> importedModelTags) {
            this.importedModelTags = TagListCopier.copy(importedModelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importedModelTags(Tag... importedModelTags) {
            importedModelTags(Arrays.asList(importedModelTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importedModelTags(Consumer<Tag.Builder>... importedModelTags) {
            importedModelTags(Stream.of(importedModelTags).map(c -> Tag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getImportedModelKmsKeyId() {
            return importedModelKmsKeyId;
        }

        public final void setImportedModelKmsKeyId(String importedModelKmsKeyId) {
            this.importedModelKmsKeyId = importedModelKmsKeyId;
        }

        @Override
        public final Builder importedModelKmsKeyId(String importedModelKmsKeyId) {
            this.importedModelKmsKeyId = importedModelKmsKeyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelImportJobRequest build() {
            return new CreateModelImportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
