/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInferenceProfileResponse extends BedrockResponse implements
        ToCopyableBuilder<GetInferenceProfileResponse.Builder, GetInferenceProfileResponse> {
    private static final SdkField<String> INFERENCE_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inferenceProfileName").getter(getter(GetInferenceProfileResponse::inferenceProfileName))
            .setter(setter(Builder::inferenceProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceProfileName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetInferenceProfileResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetInferenceProfileResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetInferenceProfileResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> INFERENCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inferenceProfileArn").getter(getter(GetInferenceProfileResponse::inferenceProfileArn))
            .setter(setter(Builder::inferenceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceProfileArn").build())
            .build();

    private static final SdkField<List<InferenceProfileModel>> MODELS_FIELD = SdkField
            .<List<InferenceProfileModel>> builder(MarshallingType.LIST)
            .memberName("models")
            .getter(getter(GetInferenceProfileResponse::models))
            .setter(setter(Builder::models))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InferenceProfileModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(InferenceProfileModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INFERENCE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inferenceProfileId").getter(getter(GetInferenceProfileResponse::inferenceProfileId))
            .setter(setter(Builder::inferenceProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceProfileId").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetInferenceProfileResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetInferenceProfileResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_PROFILE_NAME_FIELD,
            DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, INFERENCE_PROFILE_ARN_FIELD, MODELS_FIELD,
            INFERENCE_PROFILE_ID_FIELD, STATUS_FIELD, TYPE_FIELD));

    private final String inferenceProfileName;

    private final String description;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String inferenceProfileArn;

    private final List<InferenceProfileModel> models;

    private final String inferenceProfileId;

    private final String status;

    private final String type;

    private GetInferenceProfileResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceProfileName = builder.inferenceProfileName;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.inferenceProfileArn = builder.inferenceProfileArn;
        this.models = builder.models;
        this.inferenceProfileId = builder.inferenceProfileId;
        this.status = builder.status;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the inference profile.
     * </p>
     * 
     * @return The name of the inference profile.
     */
    public final String inferenceProfileName() {
        return inferenceProfileName;
    }

    /**
     * <p>
     * The description of the inference profile.
     * </p>
     * 
     * @return The description of the inference profile.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time at which the inference profile was created.
     * </p>
     * 
     * @return The time at which the inference profile was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time at which the inference profile was last updated.
     * </p>
     * 
     * @return The time at which the inference profile was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the inference profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the inference profile.
     */
    public final String inferenceProfileArn() {
        return inferenceProfileArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Models property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasModels() {
        return models != null && !(models instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of information about each model in the inference profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModels} method.
     * </p>
     * 
     * @return A list of information about each model in the inference profile.
     */
    public final List<InferenceProfileModel> models() {
        return models;
    }

    /**
     * <p>
     * The unique identifier of the inference profile.
     * </p>
     * 
     * @return The unique identifier of the inference profile.
     */
    public final String inferenceProfileId() {
        return inferenceProfileId;
    }

    /**
     * <p>
     * The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to be
     *         used.
     * @see InferenceProfileStatus
     */
    public final InferenceProfileStatus status() {
        return InferenceProfileStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to be
     *         used.
     * @see InferenceProfileStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of the inference profile. The following types are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route inference
     * requests across regions with these inference profiles.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile can track
     * metrics and costs when invoking the model in it. The inference profile may route requests to one or multiple
     * regions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InferenceProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the inference profile. The following types are possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route inference
     *         requests across regions with these inference profiles.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile
     *         can track metrics and costs when invoking the model in it. The inference profile may route requests to
     *         one or multiple regions.
     *         </p>
     *         </li>
     * @see InferenceProfileType
     */
    public final InferenceProfileType type() {
        return InferenceProfileType.fromValue(type);
    }

    /**
     * <p>
     * The type of the inference profile. The following types are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route inference
     * requests across regions with these inference profiles.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile can track
     * metrics and costs when invoking the model in it. The inference profile may route requests to one or multiple
     * regions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InferenceProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the inference profile. The following types are possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route inference
     *         requests across regions with these inference profiles.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile
     *         can track metrics and costs when invoking the model in it. The inference profile may route requests to
     *         one or multiple regions.
     *         </p>
     *         </li>
     * @see InferenceProfileType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inferenceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasModels() ? models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inferenceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInferenceProfileResponse)) {
            return false;
        }
        GetInferenceProfileResponse other = (GetInferenceProfileResponse) obj;
        return Objects.equals(inferenceProfileName(), other.inferenceProfileName())
                && Objects.equals(description(), other.description()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(inferenceProfileArn(), other.inferenceProfileArn()) && hasModels() == other.hasModels()
                && Objects.equals(models(), other.models()) && Objects.equals(inferenceProfileId(), other.inferenceProfileId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInferenceProfileResponse").add("InferenceProfileName", inferenceProfileName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("InferenceProfileArn", inferenceProfileArn())
                .add("Models", hasModels() ? models() : null).add("InferenceProfileId", inferenceProfileId())
                .add("Status", statusAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inferenceProfileName":
            return Optional.ofNullable(clazz.cast(inferenceProfileName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "inferenceProfileArn":
            return Optional.ofNullable(clazz.cast(inferenceProfileArn()));
        case "models":
            return Optional.ofNullable(clazz.cast(models()));
        case "inferenceProfileId":
            return Optional.ofNullable(clazz.cast(inferenceProfileId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInferenceProfileResponse, T> g) {
        return obj -> g.apply((GetInferenceProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInferenceProfileResponse> {
        /**
         * <p>
         * The name of the inference profile.
         * </p>
         * 
         * @param inferenceProfileName
         *        The name of the inference profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceProfileName(String inferenceProfileName);

        /**
         * <p>
         * The description of the inference profile.
         * </p>
         * 
         * @param description
         *        The description of the inference profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time at which the inference profile was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the inference profile was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time at which the inference profile was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the inference profile was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the inference profile.
         * </p>
         * 
         * @param inferenceProfileArn
         *        The Amazon Resource Name (ARN) of the inference profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceProfileArn(String inferenceProfileArn);

        /**
         * <p>
         * A list of information about each model in the inference profile.
         * </p>
         * 
         * @param models
         *        A list of information about each model in the inference profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Collection<InferenceProfileModel> models);

        /**
         * <p>
         * A list of information about each model in the inference profile.
         * </p>
         * 
         * @param models
         *        A list of information about each model in the inference profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(InferenceProfileModel... models);

        /**
         * <p>
         * A list of information about each model in the inference profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.InferenceProfileModel.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.bedrock.model.InferenceProfileModel#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.InferenceProfileModel.Builder#build()} is called
         * immediately and its result is passed to {@link #models(List<InferenceProfileModel>)}.
         * 
         * @param models
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.InferenceProfileModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #models(java.util.Collection<InferenceProfileModel>)
         */
        Builder models(Consumer<InferenceProfileModel.Builder>... models);

        /**
         * <p>
         * The unique identifier of the inference profile.
         * </p>
         * 
         * @param inferenceProfileId
         *        The unique identifier of the inference profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceProfileId(String inferenceProfileId);

        /**
         * <p>
         * The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to be
         * used.
         * </p>
         * 
         * @param status
         *        The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to
         *        be used.
         * @see InferenceProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceProfileStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to be
         * used.
         * </p>
         * 
         * @param status
         *        The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to
         *        be used.
         * @see InferenceProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceProfileStatus
         */
        Builder status(InferenceProfileStatus status);

        /**
         * <p>
         * The type of the inference profile. The following types are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route inference
         * requests across regions with these inference profiles.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile can
         * track metrics and costs when invoking the model in it. The inference profile may route requests to one or
         * multiple regions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the inference profile. The following types are possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route
         *        inference requests across regions with these inference profiles.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile
         *        can track metrics and costs when invoking the model in it. The inference profile may route requests to
         *        one or multiple regions.
         *        </p>
         *        </li>
         * @see InferenceProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceProfileType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the inference profile. The following types are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route inference
         * requests across regions with these inference profiles.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile can
         * track metrics and costs when invoking the model in it. The inference profile may route requests to one or
         * multiple regions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the inference profile. The following types are possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SYSTEM_DEFINED</code> – The inference profile is defined by Amazon Bedrock. You can route
         *        inference requests across regions with these inference profiles.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPLICATION</code> – The inference profile was created by a user. This type of inference profile
         *        can track metrics and costs when invoking the model in it. The inference profile may route requests to
         *        one or multiple regions.
         *        </p>
         *        </li>
         * @see InferenceProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceProfileType
         */
        Builder type(InferenceProfileType type);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String inferenceProfileName;

        private String description;

        private Instant createdAt;

        private Instant updatedAt;

        private String inferenceProfileArn;

        private List<InferenceProfileModel> models = DefaultSdkAutoConstructList.getInstance();

        private String inferenceProfileId;

        private String status;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInferenceProfileResponse model) {
            super(model);
            inferenceProfileName(model.inferenceProfileName);
            description(model.description);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            inferenceProfileArn(model.inferenceProfileArn);
            models(model.models);
            inferenceProfileId(model.inferenceProfileId);
            status(model.status);
            type(model.type);
        }

        public final String getInferenceProfileName() {
            return inferenceProfileName;
        }

        public final void setInferenceProfileName(String inferenceProfileName) {
            this.inferenceProfileName = inferenceProfileName;
        }

        @Override
        public final Builder inferenceProfileName(String inferenceProfileName) {
            this.inferenceProfileName = inferenceProfileName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getInferenceProfileArn() {
            return inferenceProfileArn;
        }

        public final void setInferenceProfileArn(String inferenceProfileArn) {
            this.inferenceProfileArn = inferenceProfileArn;
        }

        @Override
        public final Builder inferenceProfileArn(String inferenceProfileArn) {
            this.inferenceProfileArn = inferenceProfileArn;
            return this;
        }

        public final List<InferenceProfileModel.Builder> getModels() {
            List<InferenceProfileModel.Builder> result = InferenceProfileModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<InferenceProfileModel.BuilderImpl> models) {
            this.models = InferenceProfileModelsCopier.copyFromBuilder(models);
        }

        @Override
        public final Builder models(Collection<InferenceProfileModel> models) {
            this.models = InferenceProfileModelsCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(InferenceProfileModel... models) {
            models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<InferenceProfileModel.Builder>... models) {
            models(Stream.of(models).map(c -> InferenceProfileModel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getInferenceProfileId() {
            return inferenceProfileId;
        }

        public final void setInferenceProfileId(String inferenceProfileId) {
            this.inferenceProfileId = inferenceProfileId;
        }

        @Override
        public final Builder inferenceProfileId(String inferenceProfileId) {
            this.inferenceProfileId = inferenceProfileId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InferenceProfileType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetInferenceProfileResponse build() {
            return new GetInferenceProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
