/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInferenceProfilesResponse extends BedrockResponse implements
        ToCopyableBuilder<ListInferenceProfilesResponse.Builder, ListInferenceProfilesResponse> {
    private static final SdkField<List<InferenceProfileSummary>> INFERENCE_PROFILE_SUMMARIES_FIELD = SdkField
            .<List<InferenceProfileSummary>> builder(MarshallingType.LIST)
            .memberName("inferenceProfileSummaries")
            .getter(getter(ListInferenceProfilesResponse::inferenceProfileSummaries))
            .setter(setter(Builder::inferenceProfileSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceProfileSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InferenceProfileSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(InferenceProfileSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListInferenceProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INFERENCE_PROFILE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<InferenceProfileSummary> inferenceProfileSummaries;

    private final String nextToken;

    private ListInferenceProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceProfileSummaries = builder.inferenceProfileSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InferenceProfileSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInferenceProfileSummaries() {
        return inferenceProfileSummaries != null && !(inferenceProfileSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of information about each inference profile that you can use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInferenceProfileSummaries} method.
     * </p>
     * 
     * @return A list of information about each inference profile that you can use.
     */
    public final List<InferenceProfileSummary> inferenceProfileSummaries() {
        return inferenceProfileSummaries;
    }

    /**
     * <p>
     * If the total number of results is greater than the <code>maxResults</code> value provided in the request, use
     * this token when making another request in the <code>nextToken</code> field to return the next batch of results.
     * </p>
     * 
     * @return If the total number of results is greater than the <code>maxResults</code> value provided in the request,
     *         use this token when making another request in the <code>nextToken</code> field to return the next batch
     *         of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInferenceProfileSummaries() ? inferenceProfileSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceProfilesResponse)) {
            return false;
        }
        ListInferenceProfilesResponse other = (ListInferenceProfilesResponse) obj;
        return hasInferenceProfileSummaries() == other.hasInferenceProfileSummaries()
                && Objects.equals(inferenceProfileSummaries(), other.inferenceProfileSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInferenceProfilesResponse")
                .add("InferenceProfileSummaries", hasInferenceProfileSummaries() ? inferenceProfileSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inferenceProfileSummaries":
            return Optional.ofNullable(clazz.cast(inferenceProfileSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceProfilesResponse, T> g) {
        return obj -> g.apply((ListInferenceProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInferenceProfilesResponse> {
        /**
         * <p>
         * A list of information about each inference profile that you can use.
         * </p>
         * 
         * @param inferenceProfileSummaries
         *        A list of information about each inference profile that you can use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceProfileSummaries(Collection<InferenceProfileSummary> inferenceProfileSummaries);

        /**
         * <p>
         * A list of information about each inference profile that you can use.
         * </p>
         * 
         * @param inferenceProfileSummaries
         *        A list of information about each inference profile that you can use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceProfileSummaries(InferenceProfileSummary... inferenceProfileSummaries);

        /**
         * <p>
         * A list of information about each inference profile that you can use.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.InferenceProfileSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.InferenceProfileSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.InferenceProfileSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #inferenceProfileSummaries(List<InferenceProfileSummary>)}.
         * 
         * @param inferenceProfileSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.InferenceProfileSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceProfileSummaries(java.util.Collection<InferenceProfileSummary>)
         */
        Builder inferenceProfileSummaries(Consumer<InferenceProfileSummary.Builder>... inferenceProfileSummaries);

        /**
         * <p>
         * If the total number of results is greater than the <code>maxResults</code> value provided in the request, use
         * this token when making another request in the <code>nextToken</code> field to return the next batch of
         * results.
         * </p>
         * 
         * @param nextToken
         *        If the total number of results is greater than the <code>maxResults</code> value provided in the
         *        request, use this token when making another request in the <code>nextToken</code> field to return the
         *        next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private List<InferenceProfileSummary> inferenceProfileSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceProfilesResponse model) {
            super(model);
            inferenceProfileSummaries(model.inferenceProfileSummaries);
            nextToken(model.nextToken);
        }

        public final List<InferenceProfileSummary.Builder> getInferenceProfileSummaries() {
            List<InferenceProfileSummary.Builder> result = InferenceProfileSummariesCopier
                    .copyToBuilder(this.inferenceProfileSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceProfileSummaries(Collection<InferenceProfileSummary.BuilderImpl> inferenceProfileSummaries) {
            this.inferenceProfileSummaries = InferenceProfileSummariesCopier.copyFromBuilder(inferenceProfileSummaries);
        }

        @Override
        public final Builder inferenceProfileSummaries(Collection<InferenceProfileSummary> inferenceProfileSummaries) {
            this.inferenceProfileSummaries = InferenceProfileSummariesCopier.copy(inferenceProfileSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceProfileSummaries(InferenceProfileSummary... inferenceProfileSummaries) {
            inferenceProfileSummaries(Arrays.asList(inferenceProfileSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceProfileSummaries(Consumer<InferenceProfileSummary.Builder>... inferenceProfileSummaries) {
            inferenceProfileSummaries(Stream.of(inferenceProfileSummaries)
                    .map(c -> InferenceProfileSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInferenceProfilesResponse build() {
            return new ListInferenceProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
