/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for a custom model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomModelSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomModelSummary.Builder, CustomModelSummary> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(CustomModelSummary::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelName").getter(getter(CustomModelSummary::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(CustomModelSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> BASE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("baseModelArn").getter(getter(CustomModelSummary::baseModelArn)).setter(setter(Builder::baseModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseModelArn").build()).build();

    private static final SdkField<String> BASE_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("baseModelName").getter(getter(CustomModelSummary::baseModelName)).setter(setter(Builder::baseModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseModelName").build()).build();

    private static final SdkField<String> CUSTOMIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customizationType").getter(getter(CustomModelSummary::customizationTypeAsString))
            .setter(setter(Builder::customizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customizationType").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerAccountId").getter(getter(CustomModelSummary::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD,
            MODEL_NAME_FIELD, CREATION_TIME_FIELD, BASE_MODEL_ARN_FIELD, BASE_MODEL_NAME_FIELD, CUSTOMIZATION_TYPE_FIELD,
            OWNER_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelArn;

    private final String modelName;

    private final Instant creationTime;

    private final String baseModelArn;

    private final String baseModelName;

    private final String customizationType;

    private final String ownerAccountId;

    private CustomModelSummary(BuilderImpl builder) {
        this.modelArn = builder.modelArn;
        this.modelName = builder.modelName;
        this.creationTime = builder.creationTime;
        this.baseModelArn = builder.baseModelArn;
        this.baseModelName = builder.baseModelName;
        this.customizationType = builder.customizationType;
        this.ownerAccountId = builder.ownerAccountId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom model.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The name of the custom model.
     * </p>
     * 
     * @return The name of the custom model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * Creation time of the model.
     * </p>
     * 
     * @return Creation time of the model.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The base model Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The base model Amazon Resource Name (ARN).
     */
    public final String baseModelArn() {
        return baseModelArn;
    }

    /**
     * <p>
     * The base model name.
     * </p>
     * 
     * @return The base model name.
     */
    public final String baseModelName() {
        return baseModelName;
    }

    /**
     * <p>
     * Specifies whether to carry out continued pre-training of a model or whether to fine-tune it. For more
     * information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom
     * models</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customizationType}
     * will return {@link CustomizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #customizationTypeAsString}.
     * </p>
     * 
     * @return Specifies whether to carry out continued pre-training of a model or whether to fine-tune it. For more
     *         information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom
     *         models</a>.
     * @see CustomizationType
     */
    public final CustomizationType customizationType() {
        return CustomizationType.fromValue(customizationType);
    }

    /**
     * <p>
     * Specifies whether to carry out continued pre-training of a model or whether to fine-tune it. For more
     * information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom
     * models</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customizationType}
     * will return {@link CustomizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #customizationTypeAsString}.
     * </p>
     * 
     * @return Specifies whether to carry out continued pre-training of a model or whether to fine-tune it. For more
     *         information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom
     *         models</a>.
     * @see CustomizationType
     */
    public final String customizationTypeAsString() {
        return customizationType;
    }

    /**
     * <p>
     * The unique identifier of the account that owns the model.
     * </p>
     * 
     * @return The unique identifier of the account that owns the model.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(baseModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(baseModelName());
        hashCode = 31 * hashCode + Objects.hashCode(customizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomModelSummary)) {
            return false;
        }
        CustomModelSummary other = (CustomModelSummary) obj;
        return Objects.equals(modelArn(), other.modelArn()) && Objects.equals(modelName(), other.modelName())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(baseModelArn(), other.baseModelArn())
                && Objects.equals(baseModelName(), other.baseModelName())
                && Objects.equals(customizationTypeAsString(), other.customizationTypeAsString())
                && Objects.equals(ownerAccountId(), other.ownerAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomModelSummary").add("ModelArn", modelArn()).add("ModelName", modelName())
                .add("CreationTime", creationTime()).add("BaseModelArn", baseModelArn()).add("BaseModelName", baseModelName())
                .add("CustomizationType", customizationTypeAsString()).add("OwnerAccountId", ownerAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "modelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "baseModelArn":
            return Optional.ofNullable(clazz.cast(baseModelArn()));
        case "baseModelName":
            return Optional.ofNullable(clazz.cast(baseModelName()));
        case "customizationType":
            return Optional.ofNullable(clazz.cast(customizationTypeAsString()));
        case "ownerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("modelName", MODEL_NAME_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("baseModelArn", BASE_MODEL_ARN_FIELD);
        map.put("baseModelName", BASE_MODEL_NAME_FIELD);
        map.put("customizationType", CUSTOMIZATION_TYPE_FIELD);
        map.put("ownerAccountId", OWNER_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomModelSummary, T> g) {
        return obj -> g.apply((CustomModelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomModelSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom model.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the custom model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The name of the custom model.
         * </p>
         * 
         * @param modelName
         *        The name of the custom model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * Creation time of the model.
         * </p>
         * 
         * @param creationTime
         *        Creation time of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The base model Amazon Resource Name (ARN).
         * </p>
         * 
         * @param baseModelArn
         *        The base model Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseModelArn(String baseModelArn);

        /**
         * <p>
         * The base model name.
         * </p>
         * 
         * @param baseModelName
         *        The base model name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseModelName(String baseModelName);

        /**
         * <p>
         * Specifies whether to carry out continued pre-training of a model or whether to fine-tune it. For more
         * information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom
         * models</a>.
         * </p>
         * 
         * @param customizationType
         *        Specifies whether to carry out continued pre-training of a model or whether to fine-tune it. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a>.
         * @see CustomizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizationType
         */
        Builder customizationType(String customizationType);

        /**
         * <p>
         * Specifies whether to carry out continued pre-training of a model or whether to fine-tune it. For more
         * information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom
         * models</a>.
         * </p>
         * 
         * @param customizationType
         *        Specifies whether to carry out continued pre-training of a model or whether to fine-tune it. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a>.
         * @see CustomizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizationType
         */
        Builder customizationType(CustomizationType customizationType);

        /**
         * <p>
         * The unique identifier of the account that owns the model.
         * </p>
         * 
         * @param ownerAccountId
         *        The unique identifier of the account that owns the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);
    }

    static final class BuilderImpl implements Builder {
        private String modelArn;

        private String modelName;

        private Instant creationTime;

        private String baseModelArn;

        private String baseModelName;

        private String customizationType;

        private String ownerAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomModelSummary model) {
            modelArn(model.modelArn);
            modelName(model.modelName);
            creationTime(model.creationTime);
            baseModelArn(model.baseModelArn);
            baseModelName(model.baseModelName);
            customizationType(model.customizationType);
            ownerAccountId(model.ownerAccountId);
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getBaseModelArn() {
            return baseModelArn;
        }

        public final void setBaseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
        }

        @Override
        public final Builder baseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
            return this;
        }

        public final String getBaseModelName() {
            return baseModelName;
        }

        public final void setBaseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
        }

        @Override
        public final Builder baseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
            return this;
        }

        public final String getCustomizationType() {
            return customizationType;
        }

        public final void setCustomizationType(String customizationType) {
            this.customizationType = customizationType;
        }

        @Override
        public final Builder customizationType(String customizationType) {
            this.customizationType = customizationType;
            return this;
        }

        @Override
        public final Builder customizationType(CustomizationType customizationType) {
            this.customizationType(customizationType == null ? null : customizationType.toString());
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        @Override
        public CustomModelSummary build() {
            return new CustomModelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
