/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGuardrailResponse extends BedrockResponse implements
        ToCopyableBuilder<GetGuardrailResponse.Builder, GetGuardrailResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetGuardrailResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetGuardrailResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> GUARDRAIL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailId").getter(getter(GetGuardrailResponse::guardrailId)).setter(setter(Builder::guardrailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailId").build()).build();

    private static final SdkField<String> GUARDRAIL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailArn").getter(getter(GetGuardrailResponse::guardrailArn)).setter(setter(Builder::guardrailArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailArn").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(GetGuardrailResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetGuardrailResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<GuardrailTopicPolicy> TOPIC_POLICY_FIELD = SdkField
            .<GuardrailTopicPolicy> builder(MarshallingType.SDK_POJO).memberName("topicPolicy")
            .getter(getter(GetGuardrailResponse::topicPolicy)).setter(setter(Builder::topicPolicy))
            .constructor(GuardrailTopicPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicPolicy").build()).build();

    private static final SdkField<GuardrailContentPolicy> CONTENT_POLICY_FIELD = SdkField
            .<GuardrailContentPolicy> builder(MarshallingType.SDK_POJO).memberName("contentPolicy")
            .getter(getter(GetGuardrailResponse::contentPolicy)).setter(setter(Builder::contentPolicy))
            .constructor(GuardrailContentPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentPolicy").build()).build();

    private static final SdkField<GuardrailWordPolicy> WORD_POLICY_FIELD = SdkField
            .<GuardrailWordPolicy> builder(MarshallingType.SDK_POJO).memberName("wordPolicy")
            .getter(getter(GetGuardrailResponse::wordPolicy)).setter(setter(Builder::wordPolicy))
            .constructor(GuardrailWordPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wordPolicy").build()).build();

    private static final SdkField<GuardrailSensitiveInformationPolicy> SENSITIVE_INFORMATION_POLICY_FIELD = SdkField
            .<GuardrailSensitiveInformationPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("sensitiveInformationPolicy")
            .getter(getter(GetGuardrailResponse::sensitiveInformationPolicy))
            .setter(setter(Builder::sensitiveInformationPolicy))
            .constructor(GuardrailSensitiveInformationPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveInformationPolicy").build())
            .build();

    private static final SdkField<GuardrailContextualGroundingPolicy> CONTEXTUAL_GROUNDING_POLICY_FIELD = SdkField
            .<GuardrailContextualGroundingPolicy> builder(MarshallingType.SDK_POJO).memberName("contextualGroundingPolicy")
            .getter(getter(GetGuardrailResponse::contextualGroundingPolicy)).setter(setter(Builder::contextualGroundingPolicy))
            .constructor(GuardrailContextualGroundingPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contextualGroundingPolicy").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetGuardrailResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetGuardrailResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<String>> STATUS_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statusReasons")
            .getter(getter(GetGuardrailResponse::statusReasons))
            .setter(setter(Builder::statusReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FAILURE_RECOMMENDATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureRecommendations")
            .getter(getter(GetGuardrailResponse::failureRecommendations))
            .setter(setter(Builder::failureRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureRecommendations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BLOCKED_INPUT_MESSAGING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockedInputMessaging").getter(getter(GetGuardrailResponse::blockedInputMessaging))
            .setter(setter(Builder::blockedInputMessaging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedInputMessaging").build())
            .build();

    private static final SdkField<String> BLOCKED_OUTPUTS_MESSAGING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockedOutputsMessaging").getter(getter(GetGuardrailResponse::blockedOutputsMessaging))
            .setter(setter(Builder::blockedOutputsMessaging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedOutputsMessaging").build())
            .build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(GetGuardrailResponse::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            GUARDRAIL_ID_FIELD, GUARDRAIL_ARN_FIELD, VERSION_FIELD, STATUS_FIELD, TOPIC_POLICY_FIELD, CONTENT_POLICY_FIELD,
            WORD_POLICY_FIELD, SENSITIVE_INFORMATION_POLICY_FIELD, CONTEXTUAL_GROUNDING_POLICY_FIELD, CREATED_AT_FIELD,
            UPDATED_AT_FIELD, STATUS_REASONS_FIELD, FAILURE_RECOMMENDATIONS_FIELD, BLOCKED_INPUT_MESSAGING_FIELD,
            BLOCKED_OUTPUTS_MESSAGING_FIELD, KMS_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final String guardrailId;

    private final String guardrailArn;

    private final String version;

    private final String status;

    private final GuardrailTopicPolicy topicPolicy;

    private final GuardrailContentPolicy contentPolicy;

    private final GuardrailWordPolicy wordPolicy;

    private final GuardrailSensitiveInformationPolicy sensitiveInformationPolicy;

    private final GuardrailContextualGroundingPolicy contextualGroundingPolicy;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final List<String> statusReasons;

    private final List<String> failureRecommendations;

    private final String blockedInputMessaging;

    private final String blockedOutputsMessaging;

    private final String kmsKeyArn;

    private GetGuardrailResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.guardrailId = builder.guardrailId;
        this.guardrailArn = builder.guardrailArn;
        this.version = builder.version;
        this.status = builder.status;
        this.topicPolicy = builder.topicPolicy;
        this.contentPolicy = builder.contentPolicy;
        this.wordPolicy = builder.wordPolicy;
        this.sensitiveInformationPolicy = builder.sensitiveInformationPolicy;
        this.contextualGroundingPolicy = builder.contextualGroundingPolicy;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.statusReasons = builder.statusReasons;
        this.failureRecommendations = builder.failureRecommendations;
        this.blockedInputMessaging = builder.blockedInputMessaging;
        this.blockedOutputsMessaging = builder.blockedOutputsMessaging;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The name of the guardrail.
     * </p>
     * 
     * @return The name of the guardrail.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the guardrail.
     * </p>
     * 
     * @return The description of the guardrail.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the guardrail.
     * </p>
     * 
     * @return The unique identifier of the guardrail.
     */
    public final String guardrailId() {
        return guardrailId;
    }

    /**
     * <p>
     * The ARN of the guardrail.
     * </p>
     * 
     * @return The ARN of the guardrail.
     */
    public final String guardrailArn() {
        return guardrailArn;
    }

    /**
     * <p>
     * The version of the guardrail.
     * </p>
     * 
     * @return The version of the guardrail.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The status of the guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GuardrailStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the guardrail.
     * @see GuardrailStatus
     */
    public final GuardrailStatus status() {
        return GuardrailStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GuardrailStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the guardrail.
     * @see GuardrailStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The topic policy that was configured for the guardrail.
     * </p>
     * 
     * @return The topic policy that was configured for the guardrail.
     */
    public final GuardrailTopicPolicy topicPolicy() {
        return topicPolicy;
    }

    /**
     * <p>
     * The content policy that was configured for the guardrail.
     * </p>
     * 
     * @return The content policy that was configured for the guardrail.
     */
    public final GuardrailContentPolicy contentPolicy() {
        return contentPolicy;
    }

    /**
     * <p>
     * The word policy that was configured for the guardrail.
     * </p>
     * 
     * @return The word policy that was configured for the guardrail.
     */
    public final GuardrailWordPolicy wordPolicy() {
        return wordPolicy;
    }

    /**
     * <p>
     * The sensitive information policy that was configured for the guardrail.
     * </p>
     * 
     * @return The sensitive information policy that was configured for the guardrail.
     */
    public final GuardrailSensitiveInformationPolicy sensitiveInformationPolicy() {
        return sensitiveInformationPolicy;
    }

    /**
     * <p>
     * The contextual grounding policy used in the guardrail.
     * </p>
     * 
     * @return The contextual grounding policy used in the guardrail.
     */
    public final GuardrailContextualGroundingPolicy contextualGroundingPolicy() {
        return contextualGroundingPolicy;
    }

    /**
     * <p>
     * The date and time at which the guardrail was created.
     * </p>
     * 
     * @return The date and time at which the guardrail was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time at which the guardrail was updated.
     * </p>
     * 
     * @return The date and time at which the guardrail was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusReasons() {
        return statusReasons != null && !(statusReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Appears if the <code>status</code> is <code>FAILED</code>. A list of reasons for why the guardrail failed to be
     * created, updated, versioned, or deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusReasons} method.
     * </p>
     * 
     * @return Appears if the <code>status</code> is <code>FAILED</code>. A list of reasons for why the guardrail failed
     *         to be created, updated, versioned, or deleted.
     */
    public final List<String> statusReasons() {
        return statusReasons;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureRecommendations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFailureRecommendations() {
        return failureRecommendations != null && !(failureRecommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Appears if the <code>status</code> of the guardrail is <code>FAILED</code>. A list of recommendations to carry
     * out before retrying the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureRecommendations} method.
     * </p>
     * 
     * @return Appears if the <code>status</code> of the guardrail is <code>FAILED</code>. A list of recommendations to
     *         carry out before retrying the request.
     */
    public final List<String> failureRecommendations() {
        return failureRecommendations;
    }

    /**
     * <p>
     * The message that the guardrail returns when it blocks a prompt.
     * </p>
     * 
     * @return The message that the guardrail returns when it blocks a prompt.
     */
    public final String blockedInputMessaging() {
        return blockedInputMessaging;
    }

    /**
     * <p>
     * The message that the guardrail returns when it blocks a model response.
     * </p>
     * 
     * @return The message that the guardrail returns when it blocks a model response.
     */
    public final String blockedOutputsMessaging() {
        return blockedOutputsMessaging;
    }

    /**
     * <p>
     * The ARN of the KMS key that encrypts the guardrail.
     * </p>
     * 
     * @return The ARN of the KMS key that encrypts the guardrail.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(topicPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(contentPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(wordPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(sensitiveInformationPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(contextualGroundingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusReasons() ? statusReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureRecommendations() ? failureRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(blockedInputMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(blockedOutputsMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGuardrailResponse)) {
            return false;
        }
        GetGuardrailResponse other = (GetGuardrailResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(guardrailId(), other.guardrailId()) && Objects.equals(guardrailArn(), other.guardrailArn())
                && Objects.equals(version(), other.version()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(topicPolicy(), other.topicPolicy()) && Objects.equals(contentPolicy(), other.contentPolicy())
                && Objects.equals(wordPolicy(), other.wordPolicy())
                && Objects.equals(sensitiveInformationPolicy(), other.sensitiveInformationPolicy())
                && Objects.equals(contextualGroundingPolicy(), other.contextualGroundingPolicy())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && hasStatusReasons() == other.hasStatusReasons() && Objects.equals(statusReasons(), other.statusReasons())
                && hasFailureRecommendations() == other.hasFailureRecommendations()
                && Objects.equals(failureRecommendations(), other.failureRecommendations())
                && Objects.equals(blockedInputMessaging(), other.blockedInputMessaging())
                && Objects.equals(blockedOutputsMessaging(), other.blockedOutputsMessaging())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGuardrailResponse").add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GuardrailId", guardrailId()).add("GuardrailArn", guardrailArn()).add("Version", version())
                .add("Status", statusAsString()).add("TopicPolicy", topicPolicy()).add("ContentPolicy", contentPolicy())
                .add("WordPolicy", wordPolicy()).add("SensitiveInformationPolicy", sensitiveInformationPolicy())
                .add("ContextualGroundingPolicy", contextualGroundingPolicy()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt())
                .add("StatusReasons", statusReasons() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FailureRecommendations", failureRecommendations() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BlockedInputMessaging", blockedInputMessaging() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BlockedOutputsMessaging", blockedOutputsMessaging() == null ? null : "*** Sensitive Data Redacted ***")
                .add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "guardrailId":
            return Optional.ofNullable(clazz.cast(guardrailId()));
        case "guardrailArn":
            return Optional.ofNullable(clazz.cast(guardrailArn()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "topicPolicy":
            return Optional.ofNullable(clazz.cast(topicPolicy()));
        case "contentPolicy":
            return Optional.ofNullable(clazz.cast(contentPolicy()));
        case "wordPolicy":
            return Optional.ofNullable(clazz.cast(wordPolicy()));
        case "sensitiveInformationPolicy":
            return Optional.ofNullable(clazz.cast(sensitiveInformationPolicy()));
        case "contextualGroundingPolicy":
            return Optional.ofNullable(clazz.cast(contextualGroundingPolicy()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "statusReasons":
            return Optional.ofNullable(clazz.cast(statusReasons()));
        case "failureRecommendations":
            return Optional.ofNullable(clazz.cast(failureRecommendations()));
        case "blockedInputMessaging":
            return Optional.ofNullable(clazz.cast(blockedInputMessaging()));
        case "blockedOutputsMessaging":
            return Optional.ofNullable(clazz.cast(blockedOutputsMessaging()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("guardrailId", GUARDRAIL_ID_FIELD);
        map.put("guardrailArn", GUARDRAIL_ARN_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("topicPolicy", TOPIC_POLICY_FIELD);
        map.put("contentPolicy", CONTENT_POLICY_FIELD);
        map.put("wordPolicy", WORD_POLICY_FIELD);
        map.put("sensitiveInformationPolicy", SENSITIVE_INFORMATION_POLICY_FIELD);
        map.put("contextualGroundingPolicy", CONTEXTUAL_GROUNDING_POLICY_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("statusReasons", STATUS_REASONS_FIELD);
        map.put("failureRecommendations", FAILURE_RECOMMENDATIONS_FIELD);
        map.put("blockedInputMessaging", BLOCKED_INPUT_MESSAGING_FIELD);
        map.put("blockedOutputsMessaging", BLOCKED_OUTPUTS_MESSAGING_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGuardrailResponse, T> g) {
        return obj -> g.apply((GetGuardrailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetGuardrailResponse> {
        /**
         * <p>
         * The name of the guardrail.
         * </p>
         * 
         * @param name
         *        The name of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the guardrail.
         * </p>
         * 
         * @param description
         *        The description of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the guardrail.
         * </p>
         * 
         * @param guardrailId
         *        The unique identifier of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailId(String guardrailId);

        /**
         * <p>
         * The ARN of the guardrail.
         * </p>
         * 
         * @param guardrailArn
         *        The ARN of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailArn(String guardrailArn);

        /**
         * <p>
         * The version of the guardrail.
         * </p>
         * 
         * @param version
         *        The version of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The status of the guardrail.
         * </p>
         * 
         * @param status
         *        The status of the guardrail.
         * @see GuardrailStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the guardrail.
         * </p>
         * 
         * @param status
         *        The status of the guardrail.
         * @see GuardrailStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailStatus
         */
        Builder status(GuardrailStatus status);

        /**
         * <p>
         * The topic policy that was configured for the guardrail.
         * </p>
         * 
         * @param topicPolicy
         *        The topic policy that was configured for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicPolicy(GuardrailTopicPolicy topicPolicy);

        /**
         * <p>
         * The topic policy that was configured for the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailTopicPolicy.Builder} avoiding
         * the need to create one manually via {@link GuardrailTopicPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailTopicPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #topicPolicy(GuardrailTopicPolicy)}.
         * 
         * @param topicPolicy
         *        a consumer that will call methods on {@link GuardrailTopicPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicPolicy(GuardrailTopicPolicy)
         */
        default Builder topicPolicy(Consumer<GuardrailTopicPolicy.Builder> topicPolicy) {
            return topicPolicy(GuardrailTopicPolicy.builder().applyMutation(topicPolicy).build());
        }

        /**
         * <p>
         * The content policy that was configured for the guardrail.
         * </p>
         * 
         * @param contentPolicy
         *        The content policy that was configured for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentPolicy(GuardrailContentPolicy contentPolicy);

        /**
         * <p>
         * The content policy that was configured for the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailContentPolicy.Builder} avoiding
         * the need to create one manually via {@link GuardrailContentPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailContentPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #contentPolicy(GuardrailContentPolicy)}.
         * 
         * @param contentPolicy
         *        a consumer that will call methods on {@link GuardrailContentPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentPolicy(GuardrailContentPolicy)
         */
        default Builder contentPolicy(Consumer<GuardrailContentPolicy.Builder> contentPolicy) {
            return contentPolicy(GuardrailContentPolicy.builder().applyMutation(contentPolicy).build());
        }

        /**
         * <p>
         * The word policy that was configured for the guardrail.
         * </p>
         * 
         * @param wordPolicy
         *        The word policy that was configured for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wordPolicy(GuardrailWordPolicy wordPolicy);

        /**
         * <p>
         * The word policy that was configured for the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailWordPolicy.Builder} avoiding the
         * need to create one manually via {@link GuardrailWordPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailWordPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #wordPolicy(GuardrailWordPolicy)}.
         * 
         * @param wordPolicy
         *        a consumer that will call methods on {@link GuardrailWordPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wordPolicy(GuardrailWordPolicy)
         */
        default Builder wordPolicy(Consumer<GuardrailWordPolicy.Builder> wordPolicy) {
            return wordPolicy(GuardrailWordPolicy.builder().applyMutation(wordPolicy).build());
        }

        /**
         * <p>
         * The sensitive information policy that was configured for the guardrail.
         * </p>
         * 
         * @param sensitiveInformationPolicy
         *        The sensitive information policy that was configured for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitiveInformationPolicy(GuardrailSensitiveInformationPolicy sensitiveInformationPolicy);

        /**
         * <p>
         * The sensitive information policy that was configured for the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailSensitiveInformationPolicy.Builder} avoiding the need to create one manually via
         * {@link GuardrailSensitiveInformationPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailSensitiveInformationPolicy.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #sensitiveInformationPolicy(GuardrailSensitiveInformationPolicy)}.
         * 
         * @param sensitiveInformationPolicy
         *        a consumer that will call methods on {@link GuardrailSensitiveInformationPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sensitiveInformationPolicy(GuardrailSensitiveInformationPolicy)
         */
        default Builder sensitiveInformationPolicy(
                Consumer<GuardrailSensitiveInformationPolicy.Builder> sensitiveInformationPolicy) {
            return sensitiveInformationPolicy(GuardrailSensitiveInformationPolicy.builder()
                    .applyMutation(sensitiveInformationPolicy).build());
        }

        /**
         * <p>
         * The contextual grounding policy used in the guardrail.
         * </p>
         * 
         * @param contextualGroundingPolicy
         *        The contextual grounding policy used in the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextualGroundingPolicy(GuardrailContextualGroundingPolicy contextualGroundingPolicy);

        /**
         * <p>
         * The contextual grounding policy used in the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailContextualGroundingPolicy.Builder} avoiding the need to create one manually via
         * {@link GuardrailContextualGroundingPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailContextualGroundingPolicy.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #contextualGroundingPolicy(GuardrailContextualGroundingPolicy)}.
         * 
         * @param contextualGroundingPolicy
         *        a consumer that will call methods on {@link GuardrailContextualGroundingPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextualGroundingPolicy(GuardrailContextualGroundingPolicy)
         */
        default Builder contextualGroundingPolicy(Consumer<GuardrailContextualGroundingPolicy.Builder> contextualGroundingPolicy) {
            return contextualGroundingPolicy(GuardrailContextualGroundingPolicy.builder()
                    .applyMutation(contextualGroundingPolicy).build());
        }

        /**
         * <p>
         * The date and time at which the guardrail was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time at which the guardrail was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time at which the guardrail was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time at which the guardrail was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * Appears if the <code>status</code> is <code>FAILED</code>. A list of reasons for why the guardrail failed to
         * be created, updated, versioned, or deleted.
         * </p>
         * 
         * @param statusReasons
         *        Appears if the <code>status</code> is <code>FAILED</code>. A list of reasons for why the guardrail
         *        failed to be created, updated, versioned, or deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReasons(Collection<String> statusReasons);

        /**
         * <p>
         * Appears if the <code>status</code> is <code>FAILED</code>. A list of reasons for why the guardrail failed to
         * be created, updated, versioned, or deleted.
         * </p>
         * 
         * @param statusReasons
         *        Appears if the <code>status</code> is <code>FAILED</code>. A list of reasons for why the guardrail
         *        failed to be created, updated, versioned, or deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReasons(String... statusReasons);

        /**
         * <p>
         * Appears if the <code>status</code> of the guardrail is <code>FAILED</code>. A list of recommendations to
         * carry out before retrying the request.
         * </p>
         * 
         * @param failureRecommendations
         *        Appears if the <code>status</code> of the guardrail is <code>FAILED</code>. A list of recommendations
         *        to carry out before retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureRecommendations(Collection<String> failureRecommendations);

        /**
         * <p>
         * Appears if the <code>status</code> of the guardrail is <code>FAILED</code>. A list of recommendations to
         * carry out before retrying the request.
         * </p>
         * 
         * @param failureRecommendations
         *        Appears if the <code>status</code> of the guardrail is <code>FAILED</code>. A list of recommendations
         *        to carry out before retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureRecommendations(String... failureRecommendations);

        /**
         * <p>
         * The message that the guardrail returns when it blocks a prompt.
         * </p>
         * 
         * @param blockedInputMessaging
         *        The message that the guardrail returns when it blocks a prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedInputMessaging(String blockedInputMessaging);

        /**
         * <p>
         * The message that the guardrail returns when it blocks a model response.
         * </p>
         * 
         * @param blockedOutputsMessaging
         *        The message that the guardrail returns when it blocks a model response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedOutputsMessaging(String blockedOutputsMessaging);

        /**
         * <p>
         * The ARN of the KMS key that encrypts the guardrail.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the KMS key that encrypts the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String guardrailId;

        private String guardrailArn;

        private String version;

        private String status;

        private GuardrailTopicPolicy topicPolicy;

        private GuardrailContentPolicy contentPolicy;

        private GuardrailWordPolicy wordPolicy;

        private GuardrailSensitiveInformationPolicy sensitiveInformationPolicy;

        private GuardrailContextualGroundingPolicy contextualGroundingPolicy;

        private Instant createdAt;

        private Instant updatedAt;

        private List<String> statusReasons = DefaultSdkAutoConstructList.getInstance();

        private List<String> failureRecommendations = DefaultSdkAutoConstructList.getInstance();

        private String blockedInputMessaging;

        private String blockedOutputsMessaging;

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGuardrailResponse model) {
            super(model);
            name(model.name);
            description(model.description);
            guardrailId(model.guardrailId);
            guardrailArn(model.guardrailArn);
            version(model.version);
            status(model.status);
            topicPolicy(model.topicPolicy);
            contentPolicy(model.contentPolicy);
            wordPolicy(model.wordPolicy);
            sensitiveInformationPolicy(model.sensitiveInformationPolicy);
            contextualGroundingPolicy(model.contextualGroundingPolicy);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            statusReasons(model.statusReasons);
            failureRecommendations(model.failureRecommendations);
            blockedInputMessaging(model.blockedInputMessaging);
            blockedOutputsMessaging(model.blockedOutputsMessaging);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getGuardrailId() {
            return guardrailId;
        }

        public final void setGuardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
        }

        @Override
        public final Builder guardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
            return this;
        }

        public final String getGuardrailArn() {
            return guardrailArn;
        }

        public final void setGuardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
        }

        @Override
        public final Builder guardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GuardrailStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final GuardrailTopicPolicy.Builder getTopicPolicy() {
            return topicPolicy != null ? topicPolicy.toBuilder() : null;
        }

        public final void setTopicPolicy(GuardrailTopicPolicy.BuilderImpl topicPolicy) {
            this.topicPolicy = topicPolicy != null ? topicPolicy.build() : null;
        }

        @Override
        public final Builder topicPolicy(GuardrailTopicPolicy topicPolicy) {
            this.topicPolicy = topicPolicy;
            return this;
        }

        public final GuardrailContentPolicy.Builder getContentPolicy() {
            return contentPolicy != null ? contentPolicy.toBuilder() : null;
        }

        public final void setContentPolicy(GuardrailContentPolicy.BuilderImpl contentPolicy) {
            this.contentPolicy = contentPolicy != null ? contentPolicy.build() : null;
        }

        @Override
        public final Builder contentPolicy(GuardrailContentPolicy contentPolicy) {
            this.contentPolicy = contentPolicy;
            return this;
        }

        public final GuardrailWordPolicy.Builder getWordPolicy() {
            return wordPolicy != null ? wordPolicy.toBuilder() : null;
        }

        public final void setWordPolicy(GuardrailWordPolicy.BuilderImpl wordPolicy) {
            this.wordPolicy = wordPolicy != null ? wordPolicy.build() : null;
        }

        @Override
        public final Builder wordPolicy(GuardrailWordPolicy wordPolicy) {
            this.wordPolicy = wordPolicy;
            return this;
        }

        public final GuardrailSensitiveInformationPolicy.Builder getSensitiveInformationPolicy() {
            return sensitiveInformationPolicy != null ? sensitiveInformationPolicy.toBuilder() : null;
        }

        public final void setSensitiveInformationPolicy(GuardrailSensitiveInformationPolicy.BuilderImpl sensitiveInformationPolicy) {
            this.sensitiveInformationPolicy = sensitiveInformationPolicy != null ? sensitiveInformationPolicy.build() : null;
        }

        @Override
        public final Builder sensitiveInformationPolicy(GuardrailSensitiveInformationPolicy sensitiveInformationPolicy) {
            this.sensitiveInformationPolicy = sensitiveInformationPolicy;
            return this;
        }

        public final GuardrailContextualGroundingPolicy.Builder getContextualGroundingPolicy() {
            return contextualGroundingPolicy != null ? contextualGroundingPolicy.toBuilder() : null;
        }

        public final void setContextualGroundingPolicy(GuardrailContextualGroundingPolicy.BuilderImpl contextualGroundingPolicy) {
            this.contextualGroundingPolicy = contextualGroundingPolicy != null ? contextualGroundingPolicy.build() : null;
        }

        @Override
        public final Builder contextualGroundingPolicy(GuardrailContextualGroundingPolicy contextualGroundingPolicy) {
            this.contextualGroundingPolicy = contextualGroundingPolicy;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Collection<String> getStatusReasons() {
            if (statusReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return statusReasons;
        }

        public final void setStatusReasons(Collection<String> statusReasons) {
            this.statusReasons = GuardrailStatusReasonsCopier.copy(statusReasons);
        }

        @Override
        public final Builder statusReasons(Collection<String> statusReasons) {
            this.statusReasons = GuardrailStatusReasonsCopier.copy(statusReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(String... statusReasons) {
            statusReasons(Arrays.asList(statusReasons));
            return this;
        }

        public final Collection<String> getFailureRecommendations() {
            if (failureRecommendations instanceof SdkAutoConstructList) {
                return null;
            }
            return failureRecommendations;
        }

        public final void setFailureRecommendations(Collection<String> failureRecommendations) {
            this.failureRecommendations = GuardrailFailureRecommendationsCopier.copy(failureRecommendations);
        }

        @Override
        public final Builder failureRecommendations(Collection<String> failureRecommendations) {
            this.failureRecommendations = GuardrailFailureRecommendationsCopier.copy(failureRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureRecommendations(String... failureRecommendations) {
            failureRecommendations(Arrays.asList(failureRecommendations));
            return this;
        }

        public final String getBlockedInputMessaging() {
            return blockedInputMessaging;
        }

        public final void setBlockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
        }

        @Override
        public final Builder blockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
            return this;
        }

        public final String getBlockedOutputsMessaging() {
            return blockedOutputsMessaging;
        }

        public final void setBlockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
        }

        @Override
        public final Builder blockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public GetGuardrailResponse build() {
            return new GetGuardrailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
