/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains <code>SageMakerFlowDefinition</code> object. The object is used to specify the prompt dataset, task type,
 * rating method and metric names.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanWorkflowConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HumanWorkflowConfig.Builder, HumanWorkflowConfig> {
    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowDefinitionArn").getter(getter(HumanWorkflowConfig::flowDefinitionArn))
            .setter(setter(Builder::flowDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowDefinitionArn").build()).build();

    private static final SdkField<String> INSTRUCTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instructions").getter(getter(HumanWorkflowConfig::instructions)).setter(setter(Builder::instructions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_DEFINITION_ARN_FIELD,
            INSTRUCTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String flowDefinitionArn;

    private final String instructions;

    private HumanWorkflowConfig(BuilderImpl builder) {
        this.flowDefinitionArn = builder.flowDefinitionArn;
        this.instructions = builder.instructions;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) for the flow definition
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) for the flow definition
     */
    public final String flowDefinitionArn() {
        return flowDefinitionArn;
    }

    /**
     * <p>
     * Instructions for the flow definition
     * </p>
     * 
     * @return Instructions for the flow definition
     */
    public final String instructions() {
        return instructions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(instructions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanWorkflowConfig)) {
            return false;
        }
        HumanWorkflowConfig other = (HumanWorkflowConfig) obj;
        return Objects.equals(flowDefinitionArn(), other.flowDefinitionArn())
                && Objects.equals(instructions(), other.instructions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HumanWorkflowConfig").add("FlowDefinitionArn", flowDefinitionArn())
                .add("Instructions", instructions() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flowDefinitionArn":
            return Optional.ofNullable(clazz.cast(flowDefinitionArn()));
        case "instructions":
            return Optional.ofNullable(clazz.cast(instructions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("flowDefinitionArn", FLOW_DEFINITION_ARN_FIELD);
        map.put("instructions", INSTRUCTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HumanWorkflowConfig, T> g) {
        return obj -> g.apply((HumanWorkflowConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanWorkflowConfig> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) for the flow definition
         * </p>
         * 
         * @param flowDefinitionArn
         *        The Amazon Resource Number (ARN) for the flow definition
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowDefinitionArn(String flowDefinitionArn);

        /**
         * <p>
         * Instructions for the flow definition
         * </p>
         * 
         * @param instructions
         *        Instructions for the flow definition
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instructions(String instructions);
    }

    static final class BuilderImpl implements Builder {
        private String flowDefinitionArn;

        private String instructions;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanWorkflowConfig model) {
            flowDefinitionArn(model.flowDefinitionArn);
            instructions(model.instructions);
        }

        public final String getFlowDefinitionArn() {
            return flowDefinitionArn;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        @Override
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        public final String getInstructions() {
            return instructions;
        }

        public final void setInstructions(String instructions) {
            this.instructions = instructions;
        }

        @Override
        public final Builder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        @Override
        public HumanWorkflowConfig build() {
            return new HumanWorkflowConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
