/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A mapping of a metadata key to a value that it should or should not equal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestMetadataBaseFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<RequestMetadataBaseFilters.Builder, RequestMetadataBaseFilters> {
    private static final SdkField<Map<String, String>> EQUALS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("equals")
            .getter(getter(RequestMetadataBaseFilters::equalsValue))
            .setter(setter(Builder::equalsValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equals").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> NOT_EQUALS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("notEquals")
            .getter(getter(RequestMetadataBaseFilters::notEquals))
            .setter(setter(Builder::notEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notEquals").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EQUALS_FIELD, NOT_EQUALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> equalsValue;

    private final Map<String, String> notEquals;

    private RequestMetadataBaseFilters(BuilderImpl builder) {
        this.equalsValue = builder.equalsValue;
        this.notEquals = builder.notEquals;
    }

    /**
     * For responses, this returns true if the service returned a value for the Equals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEqualsValue() {
        return equalsValue != null && !(equalsValue instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Include results where the key equals the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEqualsValue} method.
     * </p>
     * 
     * @return Include results where the key equals the value.
     */
    public final Map<String, String> equalsValue() {
        return equalsValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotEquals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNotEquals() {
        return notEquals != null && !(notEquals instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Include results where the key does not equal the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotEquals} method.
     * </p>
     * 
     * @return Include results where the key does not equal the value.
     */
    public final Map<String, String> notEquals() {
        return notEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEqualsValue() ? equalsValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotEquals() ? notEquals() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestMetadataBaseFilters)) {
            return false;
        }
        RequestMetadataBaseFilters other = (RequestMetadataBaseFilters) obj;
        return hasEqualsValue() == other.hasEqualsValue() && Objects.equals(equalsValue(), other.equalsValue())
                && hasNotEquals() == other.hasNotEquals() && Objects.equals(notEquals(), other.notEquals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestMetadataBaseFilters")
                .add("Equals", equalsValue() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NotEquals", notEquals() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "equals":
            return Optional.ofNullable(clazz.cast(equalsValue()));
        case "notEquals":
            return Optional.ofNullable(clazz.cast(notEquals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("equals", EQUALS_FIELD);
        map.put("notEquals", NOT_EQUALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestMetadataBaseFilters, T> g) {
        return obj -> g.apply((RequestMetadataBaseFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestMetadataBaseFilters> {
        /**
         * <p>
         * Include results where the key equals the value.
         * </p>
         * 
         * @param equalsValue
         *        Include results where the key equals the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsValue(Map<String, String> equalsValue);

        /**
         * <p>
         * Include results where the key does not equal the value.
         * </p>
         * 
         * @param notEquals
         *        Include results where the key does not equal the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEquals(Map<String, String> notEquals);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> equalsValue = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> notEquals = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RequestMetadataBaseFilters model) {
            equalsValue(model.equalsValue);
            notEquals(model.notEquals);
        }

        public final Map<String, String> getEqualsValue() {
            if (equalsValue instanceof SdkAutoConstructMap) {
                return null;
            }
            return equalsValue;
        }

        public final void setEqualsValue(Map<String, String> equalsValue) {
            this.equalsValue = RequestMetadataMapCopier.copy(equalsValue);
        }

        @Override
        public final Builder equalsValue(Map<String, String> equalsValue) {
            this.equalsValue = RequestMetadataMapCopier.copy(equalsValue);
            return this;
        }

        public final Map<String, String> getNotEquals() {
            if (notEquals instanceof SdkAutoConstructMap) {
                return null;
            }
            return notEquals;
        }

        public final void setNotEquals(Map<String, String> notEquals) {
            this.notEquals = RequestMetadataMapCopier.copy(notEquals);
        }

        @Override
        public final Builder notEquals(Map<String, String> notEquals) {
            this.notEquals = RequestMetadataMapCopier.copy(notEquals);
            return this;
        }

        @Override
        public RequestMetadataBaseFilters build() {
            return new RequestMetadataBaseFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
