/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details of an automated evaluation job. The <code>EvaluationDatasetMetricConfig</code> object is
 * used to specify the prompt datasets, task type, and metric names.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedEvaluationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedEvaluationConfig.Builder, AutomatedEvaluationConfig> {
    private static final SdkField<List<EvaluationDatasetMetricConfig>> DATASET_METRIC_CONFIGS_FIELD = SdkField
            .<List<EvaluationDatasetMetricConfig>> builder(MarshallingType.LIST)
            .memberName("datasetMetricConfigs")
            .getter(getter(AutomatedEvaluationConfig::datasetMetricConfigs))
            .setter(setter(Builder::datasetMetricConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetMetricConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationDatasetMetricConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationDatasetMetricConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EvaluatorModelConfig> EVALUATOR_MODEL_CONFIG_FIELD = SdkField
            .<EvaluatorModelConfig> builder(MarshallingType.SDK_POJO).memberName("evaluatorModelConfig")
            .getter(getter(AutomatedEvaluationConfig::evaluatorModelConfig)).setter(setter(Builder::evaluatorModelConfig))
            .constructor(EvaluatorModelConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatorModelConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_METRIC_CONFIGS_FIELD,
            EVALUATOR_MODEL_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EvaluationDatasetMetricConfig> datasetMetricConfigs;

    private final EvaluatorModelConfig evaluatorModelConfig;

    private AutomatedEvaluationConfig(BuilderImpl builder) {
        this.datasetMetricConfigs = builder.datasetMetricConfigs;
        this.evaluatorModelConfig = builder.evaluatorModelConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the DatasetMetricConfigs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDatasetMetricConfigs() {
        return datasetMetricConfigs != null && !(datasetMetricConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration details of the prompt datasets and metrics you want to use for your evaluation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasetMetricConfigs} method.
     * </p>
     * 
     * @return Configuration details of the prompt datasets and metrics you want to use for your evaluation job.
     */
    public final List<EvaluationDatasetMetricConfig> datasetMetricConfigs() {
        return datasetMetricConfigs;
    }

    /**
     * <p>
     * Contains the evaluator model configuration details. <code>EvaluatorModelConfig</code> is required for evaluation
     * jobs that use a knowledge base or in model evaluation job that use a model as judge. This model computes all
     * evaluation related metrics.
     * </p>
     * 
     * @return Contains the evaluator model configuration details. <code>EvaluatorModelConfig</code> is required for
     *         evaluation jobs that use a knowledge base or in model evaluation job that use a model as judge. This
     *         model computes all evaluation related metrics.
     */
    public final EvaluatorModelConfig evaluatorModelConfig() {
        return evaluatorModelConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDatasetMetricConfigs() ? datasetMetricConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(evaluatorModelConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedEvaluationConfig)) {
            return false;
        }
        AutomatedEvaluationConfig other = (AutomatedEvaluationConfig) obj;
        return hasDatasetMetricConfigs() == other.hasDatasetMetricConfigs()
                && Objects.equals(datasetMetricConfigs(), other.datasetMetricConfigs())
                && Objects.equals(evaluatorModelConfig(), other.evaluatorModelConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedEvaluationConfig")
                .add("DatasetMetricConfigs", hasDatasetMetricConfigs() ? datasetMetricConfigs() : null)
                .add("EvaluatorModelConfig", evaluatorModelConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetMetricConfigs":
            return Optional.ofNullable(clazz.cast(datasetMetricConfigs()));
        case "evaluatorModelConfig":
            return Optional.ofNullable(clazz.cast(evaluatorModelConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datasetMetricConfigs", DATASET_METRIC_CONFIGS_FIELD);
        map.put("evaluatorModelConfig", EVALUATOR_MODEL_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedEvaluationConfig, T> g) {
        return obj -> g.apply((AutomatedEvaluationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedEvaluationConfig> {
        /**
         * <p>
         * Configuration details of the prompt datasets and metrics you want to use for your evaluation job.
         * </p>
         * 
         * @param datasetMetricConfigs
         *        Configuration details of the prompt datasets and metrics you want to use for your evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetMetricConfigs(Collection<EvaluationDatasetMetricConfig> datasetMetricConfigs);

        /**
         * <p>
         * Configuration details of the prompt datasets and metrics you want to use for your evaluation job.
         * </p>
         * 
         * @param datasetMetricConfigs
         *        Configuration details of the prompt datasets and metrics you want to use for your evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetMetricConfigs(EvaluationDatasetMetricConfig... datasetMetricConfigs);

        /**
         * <p>
         * Configuration details of the prompt datasets and metrics you want to use for your evaluation job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfig.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #datasetMetricConfigs(List<EvaluationDatasetMetricConfig>)}.
         * 
         * @param datasetMetricConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetMetricConfigs(java.util.Collection<EvaluationDatasetMetricConfig>)
         */
        Builder datasetMetricConfigs(Consumer<EvaluationDatasetMetricConfig.Builder>... datasetMetricConfigs);

        /**
         * <p>
         * Contains the evaluator model configuration details. <code>EvaluatorModelConfig</code> is required for
         * evaluation jobs that use a knowledge base or in model evaluation job that use a model as judge. This model
         * computes all evaluation related metrics.
         * </p>
         * 
         * @param evaluatorModelConfig
         *        Contains the evaluator model configuration details. <code>EvaluatorModelConfig</code> is required for
         *        evaluation jobs that use a knowledge base or in model evaluation job that use a model as judge. This
         *        model computes all evaluation related metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluatorModelConfig(EvaluatorModelConfig evaluatorModelConfig);

        /**
         * <p>
         * Contains the evaluator model configuration details. <code>EvaluatorModelConfig</code> is required for
         * evaluation jobs that use a knowledge base or in model evaluation job that use a model as judge. This model
         * computes all evaluation related metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluatorModelConfig.Builder} avoiding
         * the need to create one manually via {@link EvaluatorModelConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluatorModelConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #evaluatorModelConfig(EvaluatorModelConfig)}.
         * 
         * @param evaluatorModelConfig
         *        a consumer that will call methods on {@link EvaluatorModelConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluatorModelConfig(EvaluatorModelConfig)
         */
        default Builder evaluatorModelConfig(Consumer<EvaluatorModelConfig.Builder> evaluatorModelConfig) {
            return evaluatorModelConfig(EvaluatorModelConfig.builder().applyMutation(evaluatorModelConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<EvaluationDatasetMetricConfig> datasetMetricConfigs = DefaultSdkAutoConstructList.getInstance();

        private EvaluatorModelConfig evaluatorModelConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedEvaluationConfig model) {
            datasetMetricConfigs(model.datasetMetricConfigs);
            evaluatorModelConfig(model.evaluatorModelConfig);
        }

        public final List<EvaluationDatasetMetricConfig.Builder> getDatasetMetricConfigs() {
            List<EvaluationDatasetMetricConfig.Builder> result = EvaluationDatasetMetricConfigsCopier
                    .copyToBuilder(this.datasetMetricConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasetMetricConfigs(Collection<EvaluationDatasetMetricConfig.BuilderImpl> datasetMetricConfigs) {
            this.datasetMetricConfigs = EvaluationDatasetMetricConfigsCopier.copyFromBuilder(datasetMetricConfigs);
        }

        @Override
        public final Builder datasetMetricConfigs(Collection<EvaluationDatasetMetricConfig> datasetMetricConfigs) {
            this.datasetMetricConfigs = EvaluationDatasetMetricConfigsCopier.copy(datasetMetricConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetMetricConfigs(EvaluationDatasetMetricConfig... datasetMetricConfigs) {
            datasetMetricConfigs(Arrays.asList(datasetMetricConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetMetricConfigs(Consumer<EvaluationDatasetMetricConfig.Builder>... datasetMetricConfigs) {
            datasetMetricConfigs(Stream.of(datasetMetricConfigs)
                    .map(c -> EvaluationDatasetMetricConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final EvaluatorModelConfig.Builder getEvaluatorModelConfig() {
            return evaluatorModelConfig != null ? evaluatorModelConfig.toBuilder() : null;
        }

        public final void setEvaluatorModelConfig(EvaluatorModelConfig.BuilderImpl evaluatorModelConfig) {
            this.evaluatorModelConfig = evaluatorModelConfig != null ? evaluatorModelConfig.build() : null;
        }

        @Override
        public final Builder evaluatorModelConfig(EvaluatorModelConfig evaluatorModelConfig) {
            this.evaluatorModelConfig = evaluatorModelConfig;
            return this;
        }

        @Override
        public AutomatedEvaluationConfig build() {
            return new AutomatedEvaluationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
