/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEvaluationJobResponse extends BedrockResponse implements
        ToCopyableBuilder<GetEvaluationJobResponse.Builder, GetEvaluationJobResponse> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(GetEvaluationJobResponse::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetEvaluationJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(GetEvaluationJobResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> JOB_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobDescription").getter(getter(GetEvaluationJobResponse::jobDescription))
            .setter(setter(Builder::jobDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDescription").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetEvaluationJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerEncryptionKeyId").getter(getter(GetEvaluationJobResponse::customerEncryptionKeyId))
            .setter(setter(Builder::customerEncryptionKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyId").build())
            .build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobType").getter(getter(GetEvaluationJobResponse::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()).build();

    private static final SdkField<String> APPLICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationType").getter(getter(GetEvaluationJobResponse::applicationTypeAsString))
            .setter(setter(Builder::applicationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationType").build()).build();

    private static final SdkField<EvaluationConfig> EVALUATION_CONFIG_FIELD = SdkField
            .<EvaluationConfig> builder(MarshallingType.SDK_POJO).memberName("evaluationConfig")
            .getter(getter(GetEvaluationJobResponse::evaluationConfig)).setter(setter(Builder::evaluationConfig))
            .constructor(EvaluationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationConfig").build()).build();

    private static final SdkField<EvaluationInferenceConfig> INFERENCE_CONFIG_FIELD = SdkField
            .<EvaluationInferenceConfig> builder(MarshallingType.SDK_POJO).memberName("inferenceConfig")
            .getter(getter(GetEvaluationJobResponse::inferenceConfig)).setter(setter(Builder::inferenceConfig))
            .constructor(EvaluationInferenceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfig").build()).build();

    private static final SdkField<EvaluationOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<EvaluationOutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("outputDataConfig")
            .getter(getter(GetEvaluationJobResponse::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(EvaluationOutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetEvaluationJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(GetEvaluationJobResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<String>> FAILURE_MESSAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureMessages")
            .getter(getter(GetEvaluationJobResponse::failureMessages))
            .setter(setter(Builder::failureMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, STATUS_FIELD,
            JOB_ARN_FIELD, JOB_DESCRIPTION_FIELD, ROLE_ARN_FIELD, CUSTOMER_ENCRYPTION_KEY_ID_FIELD, JOB_TYPE_FIELD,
            APPLICATION_TYPE_FIELD, EVALUATION_CONFIG_FIELD, INFERENCE_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_MESSAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobName;

    private final String status;

    private final String jobArn;

    private final String jobDescription;

    private final String roleArn;

    private final String customerEncryptionKeyId;

    private final String jobType;

    private final String applicationType;

    private final EvaluationConfig evaluationConfig;

    private final EvaluationInferenceConfig inferenceConfig;

    private final EvaluationOutputDataConfig outputDataConfig;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final List<String> failureMessages;

    private GetEvaluationJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.status = builder.status;
        this.jobArn = builder.jobArn;
        this.jobDescription = builder.jobDescription;
        this.roleArn = builder.roleArn;
        this.customerEncryptionKeyId = builder.customerEncryptionKeyId;
        this.jobType = builder.jobType;
        this.applicationType = builder.applicationType;
        this.evaluationConfig = builder.evaluationConfig;
        this.inferenceConfig = builder.inferenceConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureMessages = builder.failureMessages;
    }

    /**
     * <p>
     * The name for the evaluation job.
     * </p>
     * 
     * @return The name for the evaluation job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The current status of the evaluation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the evaluation job.
     * @see EvaluationJobStatus
     */
    public final EvaluationJobStatus status() {
        return EvaluationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the evaluation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the evaluation job.
     * @see EvaluationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the evaluation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the evaluation job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The description of the evaluation job.
     * </p>
     * 
     * @return The description of the evaluation job.
     */
    public final String jobDescription() {
        return jobDescription;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM service role used in the evaluation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM service role used in the evaluation job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the customer managed encryption key specified when the evaluation job was
     * created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the customer managed encryption key specified when the evaluation job
     *         was created.
     */
    public final String customerEncryptionKeyId() {
        return customerEncryptionKeyId;
    }

    /**
     * <p>
     * Specifies whether the evaluation job is automated or human-based.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link EvaluationJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the evaluation job is automated or human-based.
     * @see EvaluationJobType
     */
    public final EvaluationJobType jobType() {
        return EvaluationJobType.fromValue(jobType);
    }

    /**
     * <p>
     * Specifies whether the evaluation job is automated or human-based.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link EvaluationJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the evaluation job is automated or human-based.
     * @see EvaluationJobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * Specifies whether the evaluation job is for evaluating a model or evaluating a knowledge base (retrieval and
     * response generation).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationType}
     * will return {@link ApplicationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the evaluation job is for evaluating a model or evaluating a knowledge base (retrieval
     *         and response generation).
     * @see ApplicationType
     */
    public final ApplicationType applicationType() {
        return ApplicationType.fromValue(applicationType);
    }

    /**
     * <p>
     * Specifies whether the evaluation job is for evaluating a model or evaluating a knowledge base (retrieval and
     * response generation).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationType}
     * will return {@link ApplicationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the evaluation job is for evaluating a model or evaluating a knowledge base (retrieval
     *         and response generation).
     * @see ApplicationType
     */
    public final String applicationTypeAsString() {
        return applicationType;
    }

    /**
     * <p>
     * Contains the configuration details of either an automated or human-based evaluation job.
     * </p>
     * 
     * @return Contains the configuration details of either an automated or human-based evaluation job.
     */
    public final EvaluationConfig evaluationConfig() {
        return evaluationConfig;
    }

    /**
     * <p>
     * Contains the configuration details of the inference model used for the evaluation job.
     * </p>
     * 
     * @return Contains the configuration details of the inference model used for the evaluation job.
     */
    public final EvaluationInferenceConfig inferenceConfig() {
        return inferenceConfig;
    }

    /**
     * <p>
     * Contains the configuration details of the Amazon S3 bucket for storing the results of the evaluation job.
     * </p>
     * 
     * @return Contains the configuration details of the Amazon S3 bucket for storing the results of the evaluation job.
     */
    public final EvaluationOutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The time the evaluation job was created.
     * </p>
     * 
     * @return The time the evaluation job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the evaluation job was last modified.
     * </p>
     * 
     * @return The time the evaluation job was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureMessages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureMessages() {
        return failureMessages != null && !(failureMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of strings that specify why the evaluation job failed to create.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureMessages} method.
     * </p>
     * 
     * @return A list of strings that specify why the evaluation job failed to create.
     */
    public final List<String> failureMessages() {
        return failureMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobDescription());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(customerEncryptionKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureMessages() ? failureMessages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEvaluationJobResponse)) {
            return false;
        }
        GetEvaluationJobResponse other = (GetEvaluationJobResponse) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(jobArn(), other.jobArn()) && Objects.equals(jobDescription(), other.jobDescription())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(customerEncryptionKeyId(), other.customerEncryptionKeyId())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString())
                && Objects.equals(applicationTypeAsString(), other.applicationTypeAsString())
                && Objects.equals(evaluationConfig(), other.evaluationConfig())
                && Objects.equals(inferenceConfig(), other.inferenceConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && hasFailureMessages() == other.hasFailureMessages()
                && Objects.equals(failureMessages(), other.failureMessages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEvaluationJobResponse").add("JobName", jobName()).add("Status", statusAsString())
                .add("JobArn", jobArn())
                .add("JobDescription", jobDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RoleArn", roleArn()).add("CustomerEncryptionKeyId", customerEncryptionKeyId())
                .add("JobType", jobTypeAsString()).add("ApplicationType", applicationTypeAsString())
                .add("EvaluationConfig", evaluationConfig()).add("InferenceConfig", inferenceConfig())
                .add("OutputDataConfig", outputDataConfig()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime())
                .add("FailureMessages", hasFailureMessages() ? failureMessages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobDescription":
            return Optional.ofNullable(clazz.cast(jobDescription()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "customerEncryptionKeyId":
            return Optional.ofNullable(clazz.cast(customerEncryptionKeyId()));
        case "jobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "applicationType":
            return Optional.ofNullable(clazz.cast(applicationTypeAsString()));
        case "evaluationConfig":
            return Optional.ofNullable(clazz.cast(evaluationConfig()));
        case "inferenceConfig":
            return Optional.ofNullable(clazz.cast(inferenceConfig()));
        case "outputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "failureMessages":
            return Optional.ofNullable(clazz.cast(failureMessages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobName", JOB_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobDescription", JOB_DESCRIPTION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("customerEncryptionKeyId", CUSTOMER_ENCRYPTION_KEY_ID_FIELD);
        map.put("jobType", JOB_TYPE_FIELD);
        map.put("applicationType", APPLICATION_TYPE_FIELD);
        map.put("evaluationConfig", EVALUATION_CONFIG_FIELD);
        map.put("inferenceConfig", INFERENCE_CONFIG_FIELD);
        map.put("outputDataConfig", OUTPUT_DATA_CONFIG_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("failureMessages", FAILURE_MESSAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEvaluationJobResponse, T> g) {
        return obj -> g.apply((GetEvaluationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEvaluationJobResponse> {
        /**
         * <p>
         * The name for the evaluation job.
         * </p>
         * 
         * @param jobName
         *        The name for the evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The current status of the evaluation job.
         * </p>
         * 
         * @param status
         *        The current status of the evaluation job.
         * @see EvaluationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the evaluation job.
         * </p>
         * 
         * @param status
         *        The current status of the evaluation job.
         * @see EvaluationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationJobStatus
         */
        Builder status(EvaluationJobStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the evaluation job.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The description of the evaluation job.
         * </p>
         * 
         * @param jobDescription
         *        The description of the evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDescription(String jobDescription);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM service role used in the evaluation job.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM service role used in the evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the customer managed encryption key specified when the evaluation job was
         * created.
         * </p>
         * 
         * @param customerEncryptionKeyId
         *        The Amazon Resource Name (ARN) of the customer managed encryption key specified when the evaluation
         *        job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerEncryptionKeyId(String customerEncryptionKeyId);

        /**
         * <p>
         * Specifies whether the evaluation job is automated or human-based.
         * </p>
         * 
         * @param jobType
         *        Specifies whether the evaluation job is automated or human-based.
         * @see EvaluationJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationJobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * Specifies whether the evaluation job is automated or human-based.
         * </p>
         * 
         * @param jobType
         *        Specifies whether the evaluation job is automated or human-based.
         * @see EvaluationJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationJobType
         */
        Builder jobType(EvaluationJobType jobType);

        /**
         * <p>
         * Specifies whether the evaluation job is for evaluating a model or evaluating a knowledge base (retrieval and
         * response generation).
         * </p>
         * 
         * @param applicationType
         *        Specifies whether the evaluation job is for evaluating a model or evaluating a knowledge base
         *        (retrieval and response generation).
         * @see ApplicationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationType
         */
        Builder applicationType(String applicationType);

        /**
         * <p>
         * Specifies whether the evaluation job is for evaluating a model or evaluating a knowledge base (retrieval and
         * response generation).
         * </p>
         * 
         * @param applicationType
         *        Specifies whether the evaluation job is for evaluating a model or evaluating a knowledge base
         *        (retrieval and response generation).
         * @see ApplicationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationType
         */
        Builder applicationType(ApplicationType applicationType);

        /**
         * <p>
         * Contains the configuration details of either an automated or human-based evaluation job.
         * </p>
         * 
         * @param evaluationConfig
         *        Contains the configuration details of either an automated or human-based evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationConfig(EvaluationConfig evaluationConfig);

        /**
         * <p>
         * Contains the configuration details of either an automated or human-based evaluation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationConfig.Builder} avoiding the
         * need to create one manually via {@link EvaluationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #evaluationConfig(EvaluationConfig)}.
         * 
         * @param evaluationConfig
         *        a consumer that will call methods on {@link EvaluationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationConfig(EvaluationConfig)
         */
        default Builder evaluationConfig(Consumer<EvaluationConfig.Builder> evaluationConfig) {
            return evaluationConfig(EvaluationConfig.builder().applyMutation(evaluationConfig).build());
        }

        /**
         * <p>
         * Contains the configuration details of the inference model used for the evaluation job.
         * </p>
         * 
         * @param inferenceConfig
         *        Contains the configuration details of the inference model used for the evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceConfig(EvaluationInferenceConfig inferenceConfig);

        /**
         * <p>
         * Contains the configuration details of the inference model used for the evaluation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationInferenceConfig.Builder}
         * avoiding the need to create one manually via {@link EvaluationInferenceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationInferenceConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #inferenceConfig(EvaluationInferenceConfig)}.
         * 
         * @param inferenceConfig
         *        a consumer that will call methods on {@link EvaluationInferenceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceConfig(EvaluationInferenceConfig)
         */
        default Builder inferenceConfig(Consumer<EvaluationInferenceConfig.Builder> inferenceConfig) {
            return inferenceConfig(EvaluationInferenceConfig.builder().applyMutation(inferenceConfig).build());
        }

        /**
         * <p>
         * Contains the configuration details of the Amazon S3 bucket for storing the results of the evaluation job.
         * </p>
         * 
         * @param outputDataConfig
         *        Contains the configuration details of the Amazon S3 bucket for storing the results of the evaluation
         *        job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(EvaluationOutputDataConfig outputDataConfig);

        /**
         * <p>
         * Contains the configuration details of the Amazon S3 bucket for storing the results of the evaluation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationOutputDataConfig.Builder}
         * avoiding the need to create one manually via {@link EvaluationOutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationOutputDataConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #outputDataConfig(EvaluationOutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link EvaluationOutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(EvaluationOutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<EvaluationOutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(EvaluationOutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The time the evaluation job was created.
         * </p>
         * 
         * @param creationTime
         *        The time the evaluation job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the evaluation job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time the evaluation job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * A list of strings that specify why the evaluation job failed to create.
         * </p>
         * 
         * @param failureMessages
         *        A list of strings that specify why the evaluation job failed to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessages(Collection<String> failureMessages);

        /**
         * <p>
         * A list of strings that specify why the evaluation job failed to create.
         * </p>
         * 
         * @param failureMessages
         *        A list of strings that specify why the evaluation job failed to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessages(String... failureMessages);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String jobName;

        private String status;

        private String jobArn;

        private String jobDescription;

        private String roleArn;

        private String customerEncryptionKeyId;

        private String jobType;

        private String applicationType;

        private EvaluationConfig evaluationConfig;

        private EvaluationInferenceConfig inferenceConfig;

        private EvaluationOutputDataConfig outputDataConfig;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private List<String> failureMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEvaluationJobResponse model) {
            super(model);
            jobName(model.jobName);
            status(model.status);
            jobArn(model.jobArn);
            jobDescription(model.jobDescription);
            roleArn(model.roleArn);
            customerEncryptionKeyId(model.customerEncryptionKeyId);
            jobType(model.jobType);
            applicationType(model.applicationType);
            evaluationConfig(model.evaluationConfig);
            inferenceConfig(model.inferenceConfig);
            outputDataConfig(model.outputDataConfig);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            failureMessages(model.failureMessages);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobDescription() {
            return jobDescription;
        }

        public final void setJobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
        }

        @Override
        public final Builder jobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getCustomerEncryptionKeyId() {
            return customerEncryptionKeyId;
        }

        public final void setCustomerEncryptionKeyId(String customerEncryptionKeyId) {
            this.customerEncryptionKeyId = customerEncryptionKeyId;
        }

        @Override
        public final Builder customerEncryptionKeyId(String customerEncryptionKeyId) {
            this.customerEncryptionKeyId = customerEncryptionKeyId;
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(EvaluationJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getApplicationType() {
            return applicationType;
        }

        public final void setApplicationType(String applicationType) {
            this.applicationType = applicationType;
        }

        @Override
        public final Builder applicationType(String applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        @Override
        public final Builder applicationType(ApplicationType applicationType) {
            this.applicationType(applicationType == null ? null : applicationType.toString());
            return this;
        }

        public final EvaluationConfig.Builder getEvaluationConfig() {
            return evaluationConfig != null ? evaluationConfig.toBuilder() : null;
        }

        public final void setEvaluationConfig(EvaluationConfig.BuilderImpl evaluationConfig) {
            this.evaluationConfig = evaluationConfig != null ? evaluationConfig.build() : null;
        }

        @Override
        public final Builder evaluationConfig(EvaluationConfig evaluationConfig) {
            this.evaluationConfig = evaluationConfig;
            return this;
        }

        public final EvaluationInferenceConfig.Builder getInferenceConfig() {
            return inferenceConfig != null ? inferenceConfig.toBuilder() : null;
        }

        public final void setInferenceConfig(EvaluationInferenceConfig.BuilderImpl inferenceConfig) {
            this.inferenceConfig = inferenceConfig != null ? inferenceConfig.build() : null;
        }

        @Override
        public final Builder inferenceConfig(EvaluationInferenceConfig inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public final EvaluationOutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(EvaluationOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(EvaluationOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Collection<String> getFailureMessages() {
            if (failureMessages instanceof SdkAutoConstructList) {
                return null;
            }
            return failureMessages;
        }

        public final void setFailureMessages(Collection<String> failureMessages) {
            this.failureMessages = ErrorMessagesCopier.copy(failureMessages);
        }

        @Override
        public final Builder failureMessages(Collection<String> failureMessages) {
            this.failureMessages = ErrorMessagesCopier.copy(failureMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureMessages(String... failureMessages) {
            failureMessages(Arrays.asList(failureMessages));
            return this;
        }

        @Override
        public GetEvaluationJobResponse build() {
            return new GetEvaluationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
