/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetModelCustomizationJobResponse extends BedrockResponse implements
        ToCopyableBuilder<GetModelCustomizationJobResponse.Builder, GetModelCustomizationJobResponse> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(GetModelCustomizationJobResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(GetModelCustomizationJobResponse::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> OUTPUT_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputModelName").getter(getter(GetModelCustomizationJobResponse::outputModelName))
            .setter(setter(Builder::outputModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputModelName").build()).build();

    private static final SdkField<String> OUTPUT_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputModelArn").getter(getter(GetModelCustomizationJobResponse::outputModelArn))
            .setter(setter(Builder::outputModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputModelArn").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(GetModelCustomizationJobResponse::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetModelCustomizationJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetModelCustomizationJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(GetModelCustomizationJobResponse::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetModelCustomizationJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(GetModelCustomizationJobResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(GetModelCustomizationJobResponse::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> BASE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("baseModelArn").getter(getter(GetModelCustomizationJobResponse::baseModelArn))
            .setter(setter(Builder::baseModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseModelArn").build()).build();

    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("hyperParameters")
            .getter(getter(GetModelCustomizationJobResponse::hyperParameters))
            .setter(setter(Builder::hyperParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<TrainingDataConfig> TRAINING_DATA_CONFIG_FIELD = SdkField
            .<TrainingDataConfig> builder(MarshallingType.SDK_POJO).memberName("trainingDataConfig")
            .getter(getter(GetModelCustomizationJobResponse::trainingDataConfig)).setter(setter(Builder::trainingDataConfig))
            .constructor(TrainingDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataConfig").build())
            .build();

    private static final SdkField<ValidationDataConfig> VALIDATION_DATA_CONFIG_FIELD = SdkField
            .<ValidationDataConfig> builder(MarshallingType.SDK_POJO).memberName("validationDataConfig")
            .getter(getter(GetModelCustomizationJobResponse::validationDataConfig)).setter(setter(Builder::validationDataConfig))
            .constructor(ValidationDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationDataConfig").build())
            .build();

    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("outputDataConfig")
            .getter(getter(GetModelCustomizationJobResponse::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()).build();

    private static final SdkField<String> CUSTOMIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customizationType").getter(getter(GetModelCustomizationJobResponse::customizationTypeAsString))
            .setter(setter(Builder::customizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customizationType").build()).build();

    private static final SdkField<String> OUTPUT_MODEL_KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputModelKmsKeyArn").getter(getter(GetModelCustomizationJobResponse::outputModelKmsKeyArn))
            .setter(setter(Builder::outputModelKmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputModelKmsKeyArn").build())
            .build();

    private static final SdkField<TrainingMetrics> TRAINING_METRICS_FIELD = SdkField
            .<TrainingMetrics> builder(MarshallingType.SDK_POJO).memberName("trainingMetrics")
            .getter(getter(GetModelCustomizationJobResponse::trainingMetrics)).setter(setter(Builder::trainingMetrics))
            .constructor(TrainingMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingMetrics").build()).build();

    private static final SdkField<List<ValidatorMetric>> VALIDATION_METRICS_FIELD = SdkField
            .<List<ValidatorMetric>> builder(MarshallingType.LIST)
            .memberName("validationMetrics")
            .getter(getter(GetModelCustomizationJobResponse::validationMetrics))
            .setter(setter(Builder::validationMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidatorMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidatorMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("vpcConfig").getter(getter(GetModelCustomizationJobResponse::vpcConfig))
            .setter(setter(Builder::vpcConfig)).constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<CustomizationConfig> CUSTOMIZATION_CONFIG_FIELD = SdkField
            .<CustomizationConfig> builder(MarshallingType.SDK_POJO).memberName("customizationConfig")
            .getter(getter(GetModelCustomizationJobResponse::customizationConfig)).setter(setter(Builder::customizationConfig))
            .constructor(CustomizationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customizationConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_NAME_FIELD,
            OUTPUT_MODEL_NAME_FIELD, OUTPUT_MODEL_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, ROLE_ARN_FIELD, STATUS_FIELD,
            FAILURE_MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, END_TIME_FIELD, BASE_MODEL_ARN_FIELD,
            HYPER_PARAMETERS_FIELD, TRAINING_DATA_CONFIG_FIELD, VALIDATION_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD,
            CUSTOMIZATION_TYPE_FIELD, OUTPUT_MODEL_KMS_KEY_ARN_FIELD, TRAINING_METRICS_FIELD, VALIDATION_METRICS_FIELD,
            VPC_CONFIG_FIELD, CUSTOMIZATION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobArn;

    private final String jobName;

    private final String outputModelName;

    private final String outputModelArn;

    private final String clientRequestToken;

    private final String roleArn;

    private final String status;

    private final String failureMessage;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final Instant endTime;

    private final String baseModelArn;

    private final Map<String, String> hyperParameters;

    private final TrainingDataConfig trainingDataConfig;

    private final ValidationDataConfig validationDataConfig;

    private final OutputDataConfig outputDataConfig;

    private final String customizationType;

    private final String outputModelKmsKeyArn;

    private final TrainingMetrics trainingMetrics;

    private final List<ValidatorMetric> validationMetrics;

    private final VpcConfig vpcConfig;

    private final CustomizationConfig customizationConfig;

    private GetModelCustomizationJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.outputModelName = builder.outputModelName;
        this.outputModelArn = builder.outputModelArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.failureMessage = builder.failureMessage;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.endTime = builder.endTime;
        this.baseModelArn = builder.baseModelArn;
        this.hyperParameters = builder.hyperParameters;
        this.trainingDataConfig = builder.trainingDataConfig;
        this.validationDataConfig = builder.validationDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.customizationType = builder.customizationType;
        this.outputModelKmsKeyArn = builder.outputModelKmsKeyArn;
        this.trainingMetrics = builder.trainingMetrics;
        this.validationMetrics = builder.validationMetrics;
        this.vpcConfig = builder.vpcConfig;
        this.customizationConfig = builder.customizationConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the customization job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the customization job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The name of the customization job.
     * </p>
     * 
     * @return The name of the customization job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The name of the output model.
     * </p>
     * 
     * @return The name of the output model.
     */
    public final String outputModelName() {
        return outputModelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the output model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the output model.
     */
    public final String outputModelArn() {
        return outputModelArn;
    }

    /**
     * <p>
     * The token that you specified in the <code>CreateCustomizationJob</code> request.
     * </p>
     * 
     * @return The token that you specified in the <code>CreateCustomizationJob</code> request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the job. A successful job transitions from in-progress to completed when the output model is ready
     * to use. If the job failed, the failure message contains information about why the job failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelCustomizationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job. A successful job transitions from in-progress to completed when the output model
     *         is ready to use. If the job failed, the failure message contains information about why the job failed.
     * @see ModelCustomizationJobStatus
     */
    public final ModelCustomizationJobStatus status() {
        return ModelCustomizationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the job. A successful job transitions from in-progress to completed when the output model is ready
     * to use. If the job failed, the failure message contains information about why the job failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelCustomizationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job. A successful job transitions from in-progress to completed when the output model
     *         is ready to use. If the job failed, the failure message contains information about why the job failed.
     * @see ModelCustomizationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Information about why the job failed.
     * </p>
     * 
     * @return Information about why the job failed.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * Time that the resource was created.
     * </p>
     * 
     * @return Time that the resource was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Time that the resource was last modified.
     * </p>
     * 
     * @return Time that the resource was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Time that the resource transitioned to terminal state.
     * </p>
     * 
     * @return Time that the resource transitioned to terminal state.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the base model.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the base model.
     */
    public final String baseModelArn() {
        return baseModelArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the HyperParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHyperParameters() {
        return hyperParameters != null && !(hyperParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The hyperparameter values for the job. For details on the format for different models, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html">Custom model
     * hyperparameters</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHyperParameters} method.
     * </p>
     * 
     * @return The hyperparameter values for the job. For details on the format for different models, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html">Custom model
     *         hyperparameters</a>.
     */
    public final Map<String, String> hyperParameters() {
        return hyperParameters;
    }

    /**
     * <p>
     * Contains information about the training dataset.
     * </p>
     * 
     * @return Contains information about the training dataset.
     */
    public final TrainingDataConfig trainingDataConfig() {
        return trainingDataConfig;
    }

    /**
     * <p>
     * Contains information about the validation dataset.
     * </p>
     * 
     * @return Contains information about the validation dataset.
     */
    public final ValidationDataConfig validationDataConfig() {
        return validationDataConfig;
    }

    /**
     * <p>
     * Output data configuration
     * </p>
     * 
     * @return Output data configuration
     */
    public final OutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The type of model customization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customizationType}
     * will return {@link CustomizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #customizationTypeAsString}.
     * </p>
     * 
     * @return The type of model customization.
     * @see CustomizationType
     */
    public final CustomizationType customizationType() {
        return CustomizationType.fromValue(customizationType);
    }

    /**
     * <p>
     * The type of model customization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customizationType}
     * will return {@link CustomizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #customizationTypeAsString}.
     * </p>
     * 
     * @return The type of model customization.
     * @see CustomizationType
     */
    public final String customizationTypeAsString() {
        return customizationType;
    }

    /**
     * <p>
     * The custom model is encrypted at rest using this key.
     * </p>
     * 
     * @return The custom model is encrypted at rest using this key.
     */
    public final String outputModelKmsKeyArn() {
        return outputModelKmsKeyArn;
    }

    /**
     * <p>
     * Contains training metrics from the job creation.
     * </p>
     * 
     * @return Contains training metrics from the job creation.
     */
    public final TrainingMetrics trainingMetrics() {
        return trainingMetrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValidationMetrics property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasValidationMetrics() {
        return validationMetrics != null && !(validationMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The loss metric for each validator that you provided in the createjob request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidationMetrics} method.
     * </p>
     * 
     * @return The loss metric for each validator that you provided in the createjob request.
     */
    public final List<ValidatorMetric> validationMetrics() {
        return validationMetrics;
    }

    /**
     * <p>
     * VPC configuration for the custom model job.
     * </p>
     * 
     * @return VPC configuration for the custom model job.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The customization configuration for the model customization job.
     * </p>
     * 
     * @return The customization configuration for the model customization job.
     */
    public final CustomizationConfig customizationConfig() {
        return customizationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(outputModelName());
        hashCode = 31 * hashCode + Objects.hashCode(outputModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(baseModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasHyperParameters() ? hyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(validationDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(customizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputModelKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(trainingMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(hasValidationMetrics() ? validationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(customizationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelCustomizationJobResponse)) {
            return false;
        }
        GetModelCustomizationJobResponse other = (GetModelCustomizationJobResponse) obj;
        return Objects.equals(jobArn(), other.jobArn()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(outputModelName(), other.outputModelName())
                && Objects.equals(outputModelArn(), other.outputModelArn())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(baseModelArn(), other.baseModelArn()) && hasHyperParameters() == other.hasHyperParameters()
                && Objects.equals(hyperParameters(), other.hyperParameters())
                && Objects.equals(trainingDataConfig(), other.trainingDataConfig())
                && Objects.equals(validationDataConfig(), other.validationDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(customizationTypeAsString(), other.customizationTypeAsString())
                && Objects.equals(outputModelKmsKeyArn(), other.outputModelKmsKeyArn())
                && Objects.equals(trainingMetrics(), other.trainingMetrics())
                && hasValidationMetrics() == other.hasValidationMetrics()
                && Objects.equals(validationMetrics(), other.validationMetrics())
                && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(customizationConfig(), other.customizationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetModelCustomizationJobResponse").add("JobArn", jobArn()).add("JobName", jobName())
                .add("OutputModelName", outputModelName()).add("OutputModelArn", outputModelArn())
                .add("ClientRequestToken", clientRequestToken()).add("RoleArn", roleArn()).add("Status", statusAsString())
                .add("FailureMessage", failureMessage()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("EndTime", endTime()).add("BaseModelArn", baseModelArn())
                .add("HyperParameters", hasHyperParameters() ? hyperParameters() : null)
                .add("TrainingDataConfig", trainingDataConfig()).add("ValidationDataConfig", validationDataConfig())
                .add("OutputDataConfig", outputDataConfig()).add("CustomizationType", customizationTypeAsString())
                .add("OutputModelKmsKeyArn", outputModelKmsKeyArn()).add("TrainingMetrics", trainingMetrics())
                .add("ValidationMetrics", hasValidationMetrics() ? validationMetrics() : null).add("VpcConfig", vpcConfig())
                .add("CustomizationConfig", customizationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "outputModelName":
            return Optional.ofNullable(clazz.cast(outputModelName()));
        case "outputModelArn":
            return Optional.ofNullable(clazz.cast(outputModelArn()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "baseModelArn":
            return Optional.ofNullable(clazz.cast(baseModelArn()));
        case "hyperParameters":
            return Optional.ofNullable(clazz.cast(hyperParameters()));
        case "trainingDataConfig":
            return Optional.ofNullable(clazz.cast(trainingDataConfig()));
        case "validationDataConfig":
            return Optional.ofNullable(clazz.cast(validationDataConfig()));
        case "outputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "customizationType":
            return Optional.ofNullable(clazz.cast(customizationTypeAsString()));
        case "outputModelKmsKeyArn":
            return Optional.ofNullable(clazz.cast(outputModelKmsKeyArn()));
        case "trainingMetrics":
            return Optional.ofNullable(clazz.cast(trainingMetrics()));
        case "validationMetrics":
            return Optional.ofNullable(clazz.cast(validationMetrics()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "customizationConfig":
            return Optional.ofNullable(clazz.cast(customizationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("outputModelName", OUTPUT_MODEL_NAME_FIELD);
        map.put("outputModelArn", OUTPUT_MODEL_ARN_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("baseModelArn", BASE_MODEL_ARN_FIELD);
        map.put("hyperParameters", HYPER_PARAMETERS_FIELD);
        map.put("trainingDataConfig", TRAINING_DATA_CONFIG_FIELD);
        map.put("validationDataConfig", VALIDATION_DATA_CONFIG_FIELD);
        map.put("outputDataConfig", OUTPUT_DATA_CONFIG_FIELD);
        map.put("customizationType", CUSTOMIZATION_TYPE_FIELD);
        map.put("outputModelKmsKeyArn", OUTPUT_MODEL_KMS_KEY_ARN_FIELD);
        map.put("trainingMetrics", TRAINING_METRICS_FIELD);
        map.put("validationMetrics", VALIDATION_METRICS_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        map.put("customizationConfig", CUSTOMIZATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetModelCustomizationJobResponse, T> g) {
        return obj -> g.apply((GetModelCustomizationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetModelCustomizationJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the customization job.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the customization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The name of the customization job.
         * </p>
         * 
         * @param jobName
         *        The name of the customization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The name of the output model.
         * </p>
         * 
         * @param outputModelName
         *        The name of the output model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputModelName(String outputModelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the output model.
         * </p>
         * 
         * @param outputModelArn
         *        The Amazon Resource Name (ARN) of the output model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputModelArn(String outputModelArn);

        /**
         * <p>
         * The token that you specified in the <code>CreateCustomizationJob</code> request.
         * </p>
         * 
         * @param clientRequestToken
         *        The token that you specified in the <code>CreateCustomizationJob</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the job. A successful job transitions from in-progress to completed when the output model is
         * ready to use. If the job failed, the failure message contains information about why the job failed.
         * </p>
         * 
         * @param status
         *        The status of the job. A successful job transitions from in-progress to completed when the output
         *        model is ready to use. If the job failed, the failure message contains information about why the job
         *        failed.
         * @see ModelCustomizationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCustomizationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the job. A successful job transitions from in-progress to completed when the output model is
         * ready to use. If the job failed, the failure message contains information about why the job failed.
         * </p>
         * 
         * @param status
         *        The status of the job. A successful job transitions from in-progress to completed when the output
         *        model is ready to use. If the job failed, the failure message contains information about why the job
         *        failed.
         * @see ModelCustomizationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCustomizationJobStatus
         */
        Builder status(ModelCustomizationJobStatus status);

        /**
         * <p>
         * Information about why the job failed.
         * </p>
         * 
         * @param failureMessage
         *        Information about why the job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * Time that the resource was created.
         * </p>
         * 
         * @param creationTime
         *        Time that the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Time that the resource was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        Time that the resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Time that the resource transitioned to terminal state.
         * </p>
         * 
         * @param endTime
         *        Time that the resource transitioned to terminal state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the base model.
         * </p>
         * 
         * @param baseModelArn
         *        Amazon Resource Name (ARN) of the base model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseModelArn(String baseModelArn);

        /**
         * <p>
         * The hyperparameter values for the job. For details on the format for different models, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html">Custom model
         * hyperparameters</a>.
         * </p>
         * 
         * @param hyperParameters
         *        The hyperparameter values for the job. For details on the format for different models, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html">Custom model
         *        hyperparameters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameters(Map<String, String> hyperParameters);

        /**
         * <p>
         * Contains information about the training dataset.
         * </p>
         * 
         * @param trainingDataConfig
         *        Contains information about the training dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataConfig(TrainingDataConfig trainingDataConfig);

        /**
         * <p>
         * Contains information about the training dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainingDataConfig.Builder} avoiding the
         * need to create one manually via {@link TrainingDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainingDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingDataConfig(TrainingDataConfig)}.
         * 
         * @param trainingDataConfig
         *        a consumer that will call methods on {@link TrainingDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingDataConfig(TrainingDataConfig)
         */
        default Builder trainingDataConfig(Consumer<TrainingDataConfig.Builder> trainingDataConfig) {
            return trainingDataConfig(TrainingDataConfig.builder().applyMutation(trainingDataConfig).build());
        }

        /**
         * <p>
         * Contains information about the validation dataset.
         * </p>
         * 
         * @param validationDataConfig
         *        Contains information about the validation dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationDataConfig(ValidationDataConfig validationDataConfig);

        /**
         * <p>
         * Contains information about the validation dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValidationDataConfig.Builder} avoiding
         * the need to create one manually via {@link ValidationDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValidationDataConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #validationDataConfig(ValidationDataConfig)}.
         * 
         * @param validationDataConfig
         *        a consumer that will call methods on {@link ValidationDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationDataConfig(ValidationDataConfig)
         */
        default Builder validationDataConfig(Consumer<ValidationDataConfig.Builder> validationDataConfig) {
            return validationDataConfig(ValidationDataConfig.builder().applyMutation(validationDataConfig).build());
        }

        /**
         * <p>
         * Output data configuration
         * </p>
         * 
         * @param outputDataConfig
         *        Output data configuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(OutputDataConfig outputDataConfig);

        /**
         * <p>
         * Output data configuration
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputDataConfig.Builder} avoiding the
         * need to create one manually via {@link OutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputDataConfig(OutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(OutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(OutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The type of model customization.
         * </p>
         * 
         * @param customizationType
         *        The type of model customization.
         * @see CustomizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizationType
         */
        Builder customizationType(String customizationType);

        /**
         * <p>
         * The type of model customization.
         * </p>
         * 
         * @param customizationType
         *        The type of model customization.
         * @see CustomizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizationType
         */
        Builder customizationType(CustomizationType customizationType);

        /**
         * <p>
         * The custom model is encrypted at rest using this key.
         * </p>
         * 
         * @param outputModelKmsKeyArn
         *        The custom model is encrypted at rest using this key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputModelKmsKeyArn(String outputModelKmsKeyArn);

        /**
         * <p>
         * Contains training metrics from the job creation.
         * </p>
         * 
         * @param trainingMetrics
         *        Contains training metrics from the job creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingMetrics(TrainingMetrics trainingMetrics);

        /**
         * <p>
         * Contains training metrics from the job creation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainingMetrics.Builder} avoiding the
         * need to create one manually via {@link TrainingMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainingMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingMetrics(TrainingMetrics)}.
         * 
         * @param trainingMetrics
         *        a consumer that will call methods on {@link TrainingMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingMetrics(TrainingMetrics)
         */
        default Builder trainingMetrics(Consumer<TrainingMetrics.Builder> trainingMetrics) {
            return trainingMetrics(TrainingMetrics.builder().applyMutation(trainingMetrics).build());
        }

        /**
         * <p>
         * The loss metric for each validator that you provided in the createjob request.
         * </p>
         * 
         * @param validationMetrics
         *        The loss metric for each validator that you provided in the createjob request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationMetrics(Collection<ValidatorMetric> validationMetrics);

        /**
         * <p>
         * The loss metric for each validator that you provided in the createjob request.
         * </p>
         * 
         * @param validationMetrics
         *        The loss metric for each validator that you provided in the createjob request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationMetrics(ValidatorMetric... validationMetrics);

        /**
         * <p>
         * The loss metric for each validator that you provided in the createjob request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.ValidatorMetric.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.bedrock.model.ValidatorMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.ValidatorMetric.Builder#build()} is called immediately
         * and its result is passed to {@link #validationMetrics(List<ValidatorMetric>)}.
         * 
         * @param validationMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.ValidatorMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationMetrics(java.util.Collection<ValidatorMetric>)
         */
        Builder validationMetrics(Consumer<ValidatorMetric.Builder>... validationMetrics);

        /**
         * <p>
         * VPC configuration for the custom model job.
         * </p>
         * 
         * @param vpcConfig
         *        VPC configuration for the custom model job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * VPC configuration for the custom model job.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The customization configuration for the model customization job.
         * </p>
         * 
         * @param customizationConfig
         *        The customization configuration for the model customization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizationConfig(CustomizationConfig customizationConfig);

        /**
         * <p>
         * The customization configuration for the model customization job.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomizationConfig.Builder} avoiding the
         * need to create one manually via {@link CustomizationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomizationConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #customizationConfig(CustomizationConfig)}.
         * 
         * @param customizationConfig
         *        a consumer that will call methods on {@link CustomizationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customizationConfig(CustomizationConfig)
         */
        default Builder customizationConfig(Consumer<CustomizationConfig.Builder> customizationConfig) {
            return customizationConfig(CustomizationConfig.builder().applyMutation(customizationConfig).build());
        }
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String jobArn;

        private String jobName;

        private String outputModelName;

        private String outputModelArn;

        private String clientRequestToken;

        private String roleArn;

        private String status;

        private String failureMessage;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private Instant endTime;

        private String baseModelArn;

        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();

        private TrainingDataConfig trainingDataConfig;

        private ValidationDataConfig validationDataConfig;

        private OutputDataConfig outputDataConfig;

        private String customizationType;

        private String outputModelKmsKeyArn;

        private TrainingMetrics trainingMetrics;

        private List<ValidatorMetric> validationMetrics = DefaultSdkAutoConstructList.getInstance();

        private VpcConfig vpcConfig;

        private CustomizationConfig customizationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelCustomizationJobResponse model) {
            super(model);
            jobArn(model.jobArn);
            jobName(model.jobName);
            outputModelName(model.outputModelName);
            outputModelArn(model.outputModelArn);
            clientRequestToken(model.clientRequestToken);
            roleArn(model.roleArn);
            status(model.status);
            failureMessage(model.failureMessage);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            endTime(model.endTime);
            baseModelArn(model.baseModelArn);
            hyperParameters(model.hyperParameters);
            trainingDataConfig(model.trainingDataConfig);
            validationDataConfig(model.validationDataConfig);
            outputDataConfig(model.outputDataConfig);
            customizationType(model.customizationType);
            outputModelKmsKeyArn(model.outputModelKmsKeyArn);
            trainingMetrics(model.trainingMetrics);
            validationMetrics(model.validationMetrics);
            vpcConfig(model.vpcConfig);
            customizationConfig(model.customizationConfig);
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getOutputModelName() {
            return outputModelName;
        }

        public final void setOutputModelName(String outputModelName) {
            this.outputModelName = outputModelName;
        }

        @Override
        public final Builder outputModelName(String outputModelName) {
            this.outputModelName = outputModelName;
            return this;
        }

        public final String getOutputModelArn() {
            return outputModelArn;
        }

        public final void setOutputModelArn(String outputModelArn) {
            this.outputModelArn = outputModelArn;
        }

        @Override
        public final Builder outputModelArn(String outputModelArn) {
            this.outputModelArn = outputModelArn;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelCustomizationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getBaseModelArn() {
            return baseModelArn;
        }

        public final void setBaseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
        }

        @Override
        public final Builder baseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
            return this;
        }

        public final Map<String, String> getHyperParameters() {
            if (hyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return hyperParameters;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = ModelCustomizationHyperParametersCopier.copy(hyperParameters);
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = ModelCustomizationHyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final TrainingDataConfig.Builder getTrainingDataConfig() {
            return trainingDataConfig != null ? trainingDataConfig.toBuilder() : null;
        }

        public final void setTrainingDataConfig(TrainingDataConfig.BuilderImpl trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig != null ? trainingDataConfig.build() : null;
        }

        @Override
        public final Builder trainingDataConfig(TrainingDataConfig trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig;
            return this;
        }

        public final ValidationDataConfig.Builder getValidationDataConfig() {
            return validationDataConfig != null ? validationDataConfig.toBuilder() : null;
        }

        public final void setValidationDataConfig(ValidationDataConfig.BuilderImpl validationDataConfig) {
            this.validationDataConfig = validationDataConfig != null ? validationDataConfig.build() : null;
        }

        @Override
        public final Builder validationDataConfig(ValidationDataConfig validationDataConfig) {
            this.validationDataConfig = validationDataConfig;
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final String getCustomizationType() {
            return customizationType;
        }

        public final void setCustomizationType(String customizationType) {
            this.customizationType = customizationType;
        }

        @Override
        public final Builder customizationType(String customizationType) {
            this.customizationType = customizationType;
            return this;
        }

        @Override
        public final Builder customizationType(CustomizationType customizationType) {
            this.customizationType(customizationType == null ? null : customizationType.toString());
            return this;
        }

        public final String getOutputModelKmsKeyArn() {
            return outputModelKmsKeyArn;
        }

        public final void setOutputModelKmsKeyArn(String outputModelKmsKeyArn) {
            this.outputModelKmsKeyArn = outputModelKmsKeyArn;
        }

        @Override
        public final Builder outputModelKmsKeyArn(String outputModelKmsKeyArn) {
            this.outputModelKmsKeyArn = outputModelKmsKeyArn;
            return this;
        }

        public final TrainingMetrics.Builder getTrainingMetrics() {
            return trainingMetrics != null ? trainingMetrics.toBuilder() : null;
        }

        public final void setTrainingMetrics(TrainingMetrics.BuilderImpl trainingMetrics) {
            this.trainingMetrics = trainingMetrics != null ? trainingMetrics.build() : null;
        }

        @Override
        public final Builder trainingMetrics(TrainingMetrics trainingMetrics) {
            this.trainingMetrics = trainingMetrics;
            return this;
        }

        public final List<ValidatorMetric.Builder> getValidationMetrics() {
            List<ValidatorMetric.Builder> result = ValidationMetricsCopier.copyToBuilder(this.validationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationMetrics(Collection<ValidatorMetric.BuilderImpl> validationMetrics) {
            this.validationMetrics = ValidationMetricsCopier.copyFromBuilder(validationMetrics);
        }

        @Override
        public final Builder validationMetrics(Collection<ValidatorMetric> validationMetrics) {
            this.validationMetrics = ValidationMetricsCopier.copy(validationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationMetrics(ValidatorMetric... validationMetrics) {
            validationMetrics(Arrays.asList(validationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationMetrics(Consumer<ValidatorMetric.Builder>... validationMetrics) {
            validationMetrics(Stream.of(validationMetrics).map(c -> ValidatorMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final CustomizationConfig.Builder getCustomizationConfig() {
            return customizationConfig != null ? customizationConfig.toBuilder() : null;
        }

        public final void setCustomizationConfig(CustomizationConfig.BuilderImpl customizationConfig) {
            this.customizationConfig = customizationConfig != null ? customizationConfig.build() : null;
        }

        @Override
        public final Builder customizationConfig(CustomizationConfig customizationConfig) {
            this.customizationConfig = customizationConfig;
            return this;
        }

        @Override
        public GetModelCustomizationJobResponse build() {
            return new GetModelCustomizationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
