/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetModelImportJobResponse extends BedrockResponse implements
        ToCopyableBuilder<GetModelImportJobResponse.Builder, GetModelImportJobResponse> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(GetModelImportJobResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(GetModelImportJobResponse::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> IMPORTED_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importedModelName").getter(getter(GetModelImportJobResponse::importedModelName))
            .setter(setter(Builder::importedModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelName").build()).build();

    private static final SdkField<String> IMPORTED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importedModelArn").getter(getter(GetModelImportJobResponse::importedModelArn))
            .setter(setter(Builder::importedModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetModelImportJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<ModelDataSource> MODEL_DATA_SOURCE_FIELD = SdkField
            .<ModelDataSource> builder(MarshallingType.SDK_POJO).memberName("modelDataSource")
            .getter(getter(GetModelImportJobResponse::modelDataSource)).setter(setter(Builder::modelDataSource))
            .constructor(ModelDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelDataSource").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetModelImportJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(GetModelImportJobResponse::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetModelImportJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(GetModelImportJobResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(GetModelImportJobResponse::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("vpcConfig").getter(getter(GetModelImportJobResponse::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<String> IMPORTED_MODEL_KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importedModelKmsKeyArn").getter(getter(GetModelImportJobResponse::importedModelKmsKeyArn))
            .setter(setter(Builder::importedModelKmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelKmsKeyArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_NAME_FIELD,
            IMPORTED_MODEL_NAME_FIELD, IMPORTED_MODEL_ARN_FIELD, ROLE_ARN_FIELD, MODEL_DATA_SOURCE_FIELD, STATUS_FIELD,
            FAILURE_MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, END_TIME_FIELD, VPC_CONFIG_FIELD,
            IMPORTED_MODEL_KMS_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobArn;

    private final String jobName;

    private final String importedModelName;

    private final String importedModelArn;

    private final String roleArn;

    private final ModelDataSource modelDataSource;

    private final String status;

    private final String failureMessage;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final Instant endTime;

    private final VpcConfig vpcConfig;

    private final String importedModelKmsKeyArn;

    private GetModelImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.importedModelName = builder.importedModelName;
        this.importedModelArn = builder.importedModelArn;
        this.roleArn = builder.roleArn;
        this.modelDataSource = builder.modelDataSource;
        this.status = builder.status;
        this.failureMessage = builder.failureMessage;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.endTime = builder.endTime;
        this.vpcConfig = builder.vpcConfig;
        this.importedModelKmsKeyArn = builder.importedModelKmsKeyArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the import job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the import job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The name of the import job.
     * </p>
     * 
     * @return The name of the import job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The name of the imported model.
     * </p>
     * 
     * @return The name of the imported model.
     */
    public final String importedModelName() {
        return importedModelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the imported model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the imported model.
     */
    public final String importedModelArn() {
        return importedModelArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role associated with this job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role associated with this job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The data source for the imported model.
     * </p>
     * 
     * @return The data source for the imported model.
     */
    public final ModelDataSource modelDataSource() {
        return modelDataSource;
    }

    /**
     * <p>
     * The status of the job. A successful job transitions from in-progress to completed when the imported model is
     * ready to use. If the job failed, the failure message contains information about why the job failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job. A successful job transitions from in-progress to completed when the imported model
     *         is ready to use. If the job failed, the failure message contains information about why the job failed.
     * @see ModelImportJobStatus
     */
    public final ModelImportJobStatus status() {
        return ModelImportJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the job. A successful job transitions from in-progress to completed when the imported model is
     * ready to use. If the job failed, the failure message contains information about why the job failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job. A successful job transitions from in-progress to completed when the imported model
     *         is ready to use. If the job failed, the failure message contains information about why the job failed.
     * @see ModelImportJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Information about why the import job failed.
     * </p>
     * 
     * @return Information about why the import job failed.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * The time the resource was created.
     * </p>
     * 
     * @return The time the resource was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Time the resource was last modified.
     * </p>
     * 
     * @return Time the resource was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Time that the resource transitioned to terminal state.
     * </p>
     * 
     * @return Time that the resource transitioned to terminal state.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The Virtual Private Cloud (VPC) configuration of the import model job.
     * </p>
     * 
     * @return The Virtual Private Cloud (VPC) configuration of the import model job.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The imported model is encrypted at rest using this key.
     * </p>
     * 
     * @return The imported model is encrypted at rest using this key.
     */
    public final String importedModelKmsKeyArn() {
        return importedModelKmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(importedModelName());
        hashCode = 31 * hashCode + Objects.hashCode(importedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(importedModelKmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelImportJobResponse)) {
            return false;
        }
        GetModelImportJobResponse other = (GetModelImportJobResponse) obj;
        return Objects.equals(jobArn(), other.jobArn()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(importedModelName(), other.importedModelName())
                && Objects.equals(importedModelArn(), other.importedModelArn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(modelDataSource(), other.modelDataSource())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(importedModelKmsKeyArn(), other.importedModelKmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetModelImportJobResponse").add("JobArn", jobArn()).add("JobName", jobName())
                .add("ImportedModelName", importedModelName()).add("ImportedModelArn", importedModelArn())
                .add("RoleArn", roleArn()).add("ModelDataSource", modelDataSource()).add("Status", statusAsString())
                .add("FailureMessage", failureMessage()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("EndTime", endTime()).add("VpcConfig", vpcConfig())
                .add("ImportedModelKmsKeyArn", importedModelKmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "importedModelName":
            return Optional.ofNullable(clazz.cast(importedModelName()));
        case "importedModelArn":
            return Optional.ofNullable(clazz.cast(importedModelArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "modelDataSource":
            return Optional.ofNullable(clazz.cast(modelDataSource()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "importedModelKmsKeyArn":
            return Optional.ofNullable(clazz.cast(importedModelKmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("importedModelName", IMPORTED_MODEL_NAME_FIELD);
        map.put("importedModelArn", IMPORTED_MODEL_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("modelDataSource", MODEL_DATA_SOURCE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        map.put("importedModelKmsKeyArn", IMPORTED_MODEL_KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetModelImportJobResponse, T> g) {
        return obj -> g.apply((GetModelImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetModelImportJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the import job.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The name of the import job.
         * </p>
         * 
         * @param jobName
         *        The name of the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The name of the imported model.
         * </p>
         * 
         * @param importedModelName
         *        The name of the imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedModelName(String importedModelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the imported model.
         * </p>
         * 
         * @param importedModelArn
         *        The Amazon Resource Name (ARN) of the imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedModelArn(String importedModelArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role associated with this job.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The data source for the imported model.
         * </p>
         * 
         * @param modelDataSource
         *        The data source for the imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDataSource(ModelDataSource modelDataSource);

        /**
         * <p>
         * The data source for the imported model.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelDataSource.Builder} avoiding the
         * need to create one manually via {@link ModelDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #modelDataSource(ModelDataSource)}.
         * 
         * @param modelDataSource
         *        a consumer that will call methods on {@link ModelDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDataSource(ModelDataSource)
         */
        default Builder modelDataSource(Consumer<ModelDataSource.Builder> modelDataSource) {
            return modelDataSource(ModelDataSource.builder().applyMutation(modelDataSource).build());
        }

        /**
         * <p>
         * The status of the job. A successful job transitions from in-progress to completed when the imported model is
         * ready to use. If the job failed, the failure message contains information about why the job failed.
         * </p>
         * 
         * @param status
         *        The status of the job. A successful job transitions from in-progress to completed when the imported
         *        model is ready to use. If the job failed, the failure message contains information about why the job
         *        failed.
         * @see ModelImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelImportJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the job. A successful job transitions from in-progress to completed when the imported model is
         * ready to use. If the job failed, the failure message contains information about why the job failed.
         * </p>
         * 
         * @param status
         *        The status of the job. A successful job transitions from in-progress to completed when the imported
         *        model is ready to use. If the job failed, the failure message contains information about why the job
         *        failed.
         * @see ModelImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelImportJobStatus
         */
        Builder status(ModelImportJobStatus status);

        /**
         * <p>
         * Information about why the import job failed.
         * </p>
         * 
         * @param failureMessage
         *        Information about why the import job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * The time the resource was created.
         * </p>
         * 
         * @param creationTime
         *        The time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Time the resource was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        Time the resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Time that the resource transitioned to terminal state.
         * </p>
         * 
         * @param endTime
         *        Time that the resource transitioned to terminal state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The Virtual Private Cloud (VPC) configuration of the import model job.
         * </p>
         * 
         * @param vpcConfig
         *        The Virtual Private Cloud (VPC) configuration of the import model job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * The Virtual Private Cloud (VPC) configuration of the import model job.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The imported model is encrypted at rest using this key.
         * </p>
         * 
         * @param importedModelKmsKeyArn
         *        The imported model is encrypted at rest using this key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedModelKmsKeyArn(String importedModelKmsKeyArn);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String jobArn;

        private String jobName;

        private String importedModelName;

        private String importedModelArn;

        private String roleArn;

        private ModelDataSource modelDataSource;

        private String status;

        private String failureMessage;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private Instant endTime;

        private VpcConfig vpcConfig;

        private String importedModelKmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelImportJobResponse model) {
            super(model);
            jobArn(model.jobArn);
            jobName(model.jobName);
            importedModelName(model.importedModelName);
            importedModelArn(model.importedModelArn);
            roleArn(model.roleArn);
            modelDataSource(model.modelDataSource);
            status(model.status);
            failureMessage(model.failureMessage);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            endTime(model.endTime);
            vpcConfig(model.vpcConfig);
            importedModelKmsKeyArn(model.importedModelKmsKeyArn);
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getImportedModelName() {
            return importedModelName;
        }

        public final void setImportedModelName(String importedModelName) {
            this.importedModelName = importedModelName;
        }

        @Override
        public final Builder importedModelName(String importedModelName) {
            this.importedModelName = importedModelName;
            return this;
        }

        public final String getImportedModelArn() {
            return importedModelArn;
        }

        public final void setImportedModelArn(String importedModelArn) {
            this.importedModelArn = importedModelArn;
        }

        @Override
        public final Builder importedModelArn(String importedModelArn) {
            this.importedModelArn = importedModelArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ModelDataSource.Builder getModelDataSource() {
            return modelDataSource != null ? modelDataSource.toBuilder() : null;
        }

        public final void setModelDataSource(ModelDataSource.BuilderImpl modelDataSource) {
            this.modelDataSource = modelDataSource != null ? modelDataSource.build() : null;
        }

        @Override
        public final Builder modelDataSource(ModelDataSource modelDataSource) {
            this.modelDataSource = modelDataSource;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelImportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getImportedModelKmsKeyArn() {
            return importedModelKmsKeyArn;
        }

        public final void setImportedModelKmsKeyArn(String importedModelKmsKeyArn) {
            this.importedModelKmsKeyArn = importedModelKmsKeyArn;
        }

        @Override
        public final Builder importedModelKmsKeyArn(String importedModelKmsKeyArn) {
            this.importedModelKmsKeyArn = importedModelKmsKeyArn;
            return this;
        }

        @Override
        public GetModelImportJobResponse build() {
            return new GetModelImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
