/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPromptRouterResponse extends BedrockResponse implements
        ToCopyableBuilder<GetPromptRouterResponse.Builder, GetPromptRouterResponse> {
    private static final SdkField<String> PROMPT_ROUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("promptRouterName").getter(getter(GetPromptRouterResponse::promptRouterName))
            .setter(setter(Builder::promptRouterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptRouterName").build()).build();

    private static final SdkField<RoutingCriteria> ROUTING_CRITERIA_FIELD = SdkField
            .<RoutingCriteria> builder(MarshallingType.SDK_POJO).memberName("routingCriteria")
            .getter(getter(GetPromptRouterResponse::routingCriteria)).setter(setter(Builder::routingCriteria))
            .constructor(RoutingCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingCriteria").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetPromptRouterResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetPromptRouterResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetPromptRouterResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> PROMPT_ROUTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("promptRouterArn").getter(getter(GetPromptRouterResponse::promptRouterArn))
            .setter(setter(Builder::promptRouterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptRouterArn").build()).build();

    private static final SdkField<List<PromptRouterTargetModel>> MODELS_FIELD = SdkField
            .<List<PromptRouterTargetModel>> builder(MarshallingType.LIST)
            .memberName("models")
            .getter(getter(GetPromptRouterResponse::models))
            .setter(setter(Builder::models))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PromptRouterTargetModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(PromptRouterTargetModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PromptRouterTargetModel> FALLBACK_MODEL_FIELD = SdkField
            .<PromptRouterTargetModel> builder(MarshallingType.SDK_POJO).memberName("fallbackModel")
            .getter(getter(GetPromptRouterResponse::fallbackModel)).setter(setter(Builder::fallbackModel))
            .constructor(PromptRouterTargetModel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fallbackModel").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetPromptRouterResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetPromptRouterResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_ROUTER_NAME_FIELD,
            ROUTING_CRITERIA_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, PROMPT_ROUTER_ARN_FIELD, MODELS_FIELD,
            FALLBACK_MODEL_FIELD, STATUS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String promptRouterName;

    private final RoutingCriteria routingCriteria;

    private final String description;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String promptRouterArn;

    private final List<PromptRouterTargetModel> models;

    private final PromptRouterTargetModel fallbackModel;

    private final String status;

    private final String type;

    private GetPromptRouterResponse(BuilderImpl builder) {
        super(builder);
        this.promptRouterName = builder.promptRouterName;
        this.routingCriteria = builder.routingCriteria;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.promptRouterArn = builder.promptRouterArn;
        this.models = builder.models;
        this.fallbackModel = builder.fallbackModel;
        this.status = builder.status;
        this.type = builder.type;
    }

    /**
     * <p>
     * The router's name.
     * </p>
     * 
     * @return The router's name.
     */
    public final String promptRouterName() {
        return promptRouterName;
    }

    /**
     * <p>
     * The router's routing criteria.
     * </p>
     * 
     * @return The router's routing criteria.
     */
    public final RoutingCriteria routingCriteria() {
        return routingCriteria;
    }

    /**
     * <p>
     * The router's description.
     * </p>
     * 
     * @return The router's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * When the router was created.
     * </p>
     * 
     * @return When the router was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * When the router was updated.
     * </p>
     * 
     * @return When the router was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The prompt router's ARN
     * </p>
     * 
     * @return The prompt router's ARN
     */
    public final String promptRouterArn() {
        return promptRouterArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Models property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasModels() {
        return models != null && !(models instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The router's models.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModels} method.
     * </p>
     * 
     * @return The router's models.
     */
    public final List<PromptRouterTargetModel> models() {
        return models;
    }

    /**
     * <p>
     * The router's fallback model.
     * </p>
     * 
     * @return The router's fallback model.
     */
    public final PromptRouterTargetModel fallbackModel() {
        return fallbackModel;
    }

    /**
     * <p>
     * The router's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PromptRouterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The router's status.
     * @see PromptRouterStatus
     */
    public final PromptRouterStatus status() {
        return PromptRouterStatus.fromValue(status);
    }

    /**
     * <p>
     * The router's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PromptRouterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The router's status.
     * @see PromptRouterStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The router's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PromptRouterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The router's type.
     * @see PromptRouterType
     */
    public final PromptRouterType type() {
        return PromptRouterType.fromValue(type);
    }

    /**
     * <p>
     * The router's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PromptRouterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The router's type.
     * @see PromptRouterType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(promptRouterName());
        hashCode = 31 * hashCode + Objects.hashCode(routingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(promptRouterArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasModels() ? models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fallbackModel());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPromptRouterResponse)) {
            return false;
        }
        GetPromptRouterResponse other = (GetPromptRouterResponse) obj;
        return Objects.equals(promptRouterName(), other.promptRouterName())
                && Objects.equals(routingCriteria(), other.routingCriteria())
                && Objects.equals(description(), other.description()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(promptRouterArn(), other.promptRouterArn())
                && hasModels() == other.hasModels() && Objects.equals(models(), other.models())
                && Objects.equals(fallbackModel(), other.fallbackModel())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPromptRouterResponse").add("PromptRouterName", promptRouterName())
                .add("RoutingCriteria", routingCriteria())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("PromptRouterArn", promptRouterArn())
                .add("Models", hasModels() ? models() : null).add("FallbackModel", fallbackModel())
                .add("Status", statusAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "promptRouterName":
            return Optional.ofNullable(clazz.cast(promptRouterName()));
        case "routingCriteria":
            return Optional.ofNullable(clazz.cast(routingCriteria()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "promptRouterArn":
            return Optional.ofNullable(clazz.cast(promptRouterArn()));
        case "models":
            return Optional.ofNullable(clazz.cast(models()));
        case "fallbackModel":
            return Optional.ofNullable(clazz.cast(fallbackModel()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("promptRouterName", PROMPT_ROUTER_NAME_FIELD);
        map.put("routingCriteria", ROUTING_CRITERIA_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("promptRouterArn", PROMPT_ROUTER_ARN_FIELD);
        map.put("models", MODELS_FIELD);
        map.put("fallbackModel", FALLBACK_MODEL_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPromptRouterResponse, T> g) {
        return obj -> g.apply((GetPromptRouterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPromptRouterResponse> {
        /**
         * <p>
         * The router's name.
         * </p>
         * 
         * @param promptRouterName
         *        The router's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptRouterName(String promptRouterName);

        /**
         * <p>
         * The router's routing criteria.
         * </p>
         * 
         * @param routingCriteria
         *        The router's routing criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingCriteria(RoutingCriteria routingCriteria);

        /**
         * <p>
         * The router's routing criteria.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutingCriteria.Builder} avoiding the
         * need to create one manually via {@link RoutingCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutingCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #routingCriteria(RoutingCriteria)}.
         * 
         * @param routingCriteria
         *        a consumer that will call methods on {@link RoutingCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingCriteria(RoutingCriteria)
         */
        default Builder routingCriteria(Consumer<RoutingCriteria.Builder> routingCriteria) {
            return routingCriteria(RoutingCriteria.builder().applyMutation(routingCriteria).build());
        }

        /**
         * <p>
         * The router's description.
         * </p>
         * 
         * @param description
         *        The router's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * When the router was created.
         * </p>
         * 
         * @param createdAt
         *        When the router was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * When the router was updated.
         * </p>
         * 
         * @param updatedAt
         *        When the router was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The prompt router's ARN
         * </p>
         * 
         * @param promptRouterArn
         *        The prompt router's ARN
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptRouterArn(String promptRouterArn);

        /**
         * <p>
         * The router's models.
         * </p>
         * 
         * @param models
         *        The router's models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Collection<PromptRouterTargetModel> models);

        /**
         * <p>
         * The router's models.
         * </p>
         * 
         * @param models
         *        The router's models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(PromptRouterTargetModel... models);

        /**
         * <p>
         * The router's models.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.PromptRouterTargetModel.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.PromptRouterTargetModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.PromptRouterTargetModel.Builder#build()} is called
         * immediately and its result is passed to {@link #models(List<PromptRouterTargetModel>)}.
         * 
         * @param models
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.PromptRouterTargetModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #models(java.util.Collection<PromptRouterTargetModel>)
         */
        Builder models(Consumer<PromptRouterTargetModel.Builder>... models);

        /**
         * <p>
         * The router's fallback model.
         * </p>
         * 
         * @param fallbackModel
         *        The router's fallback model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fallbackModel(PromptRouterTargetModel fallbackModel);

        /**
         * <p>
         * The router's fallback model.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptRouterTargetModel.Builder} avoiding
         * the need to create one manually via {@link PromptRouterTargetModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptRouterTargetModel.Builder#build()} is called immediately
         * and its result is passed to {@link #fallbackModel(PromptRouterTargetModel)}.
         * 
         * @param fallbackModel
         *        a consumer that will call methods on {@link PromptRouterTargetModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fallbackModel(PromptRouterTargetModel)
         */
        default Builder fallbackModel(Consumer<PromptRouterTargetModel.Builder> fallbackModel) {
            return fallbackModel(PromptRouterTargetModel.builder().applyMutation(fallbackModel).build());
        }

        /**
         * <p>
         * The router's status.
         * </p>
         * 
         * @param status
         *        The router's status.
         * @see PromptRouterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptRouterStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The router's status.
         * </p>
         * 
         * @param status
         *        The router's status.
         * @see PromptRouterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptRouterStatus
         */
        Builder status(PromptRouterStatus status);

        /**
         * <p>
         * The router's type.
         * </p>
         * 
         * @param type
         *        The router's type.
         * @see PromptRouterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptRouterType
         */
        Builder type(String type);

        /**
         * <p>
         * The router's type.
         * </p>
         * 
         * @param type
         *        The router's type.
         * @see PromptRouterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptRouterType
         */
        Builder type(PromptRouterType type);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String promptRouterName;

        private RoutingCriteria routingCriteria;

        private String description;

        private Instant createdAt;

        private Instant updatedAt;

        private String promptRouterArn;

        private List<PromptRouterTargetModel> models = DefaultSdkAutoConstructList.getInstance();

        private PromptRouterTargetModel fallbackModel;

        private String status;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPromptRouterResponse model) {
            super(model);
            promptRouterName(model.promptRouterName);
            routingCriteria(model.routingCriteria);
            description(model.description);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            promptRouterArn(model.promptRouterArn);
            models(model.models);
            fallbackModel(model.fallbackModel);
            status(model.status);
            type(model.type);
        }

        public final String getPromptRouterName() {
            return promptRouterName;
        }

        public final void setPromptRouterName(String promptRouterName) {
            this.promptRouterName = promptRouterName;
        }

        @Override
        public final Builder promptRouterName(String promptRouterName) {
            this.promptRouterName = promptRouterName;
            return this;
        }

        public final RoutingCriteria.Builder getRoutingCriteria() {
            return routingCriteria != null ? routingCriteria.toBuilder() : null;
        }

        public final void setRoutingCriteria(RoutingCriteria.BuilderImpl routingCriteria) {
            this.routingCriteria = routingCriteria != null ? routingCriteria.build() : null;
        }

        @Override
        public final Builder routingCriteria(RoutingCriteria routingCriteria) {
            this.routingCriteria = routingCriteria;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getPromptRouterArn() {
            return promptRouterArn;
        }

        public final void setPromptRouterArn(String promptRouterArn) {
            this.promptRouterArn = promptRouterArn;
        }

        @Override
        public final Builder promptRouterArn(String promptRouterArn) {
            this.promptRouterArn = promptRouterArn;
            return this;
        }

        public final List<PromptRouterTargetModel.Builder> getModels() {
            List<PromptRouterTargetModel.Builder> result = PromptRouterTargetModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<PromptRouterTargetModel.BuilderImpl> models) {
            this.models = PromptRouterTargetModelsCopier.copyFromBuilder(models);
        }

        @Override
        public final Builder models(Collection<PromptRouterTargetModel> models) {
            this.models = PromptRouterTargetModelsCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(PromptRouterTargetModel... models) {
            models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<PromptRouterTargetModel.Builder>... models) {
            models(Stream.of(models).map(c -> PromptRouterTargetModel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final PromptRouterTargetModel.Builder getFallbackModel() {
            return fallbackModel != null ? fallbackModel.toBuilder() : null;
        }

        public final void setFallbackModel(PromptRouterTargetModel.BuilderImpl fallbackModel) {
            this.fallbackModel = fallbackModel != null ? fallbackModel.build() : null;
        }

        @Override
        public final Builder fallbackModel(PromptRouterTargetModel fallbackModel) {
            this.fallbackModel = fallbackModel;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PromptRouterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PromptRouterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetPromptRouterResponse build() {
            return new GetPromptRouterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
