/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the location of the input to the batch inference job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelInvocationJobInputDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelInvocationJobInputDataConfig.Builder, ModelInvocationJobInputDataConfig> {
    private static final SdkField<ModelInvocationJobS3InputDataConfig> S3_INPUT_DATA_CONFIG_FIELD = SdkField
            .<ModelInvocationJobS3InputDataConfig> builder(MarshallingType.SDK_POJO).memberName("s3InputDataConfig")
            .getter(getter(ModelInvocationJobInputDataConfig::s3InputDataConfig)).setter(setter(Builder::s3InputDataConfig))
            .constructor(ModelInvocationJobS3InputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3InputDataConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_INPUT_DATA_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ModelInvocationJobS3InputDataConfig s3InputDataConfig;

    private final Type type;

    private ModelInvocationJobInputDataConfig(BuilderImpl builder) {
        this.s3InputDataConfig = builder.s3InputDataConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains the configuration of the S3 location of the input data.
     * </p>
     * 
     * @return Contains the configuration of the S3 location of the input data.
     */
    public final ModelInvocationJobS3InputDataConfig s3InputDataConfig() {
        return s3InputDataConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3InputDataConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelInvocationJobInputDataConfig)) {
            return false;
        }
        ModelInvocationJobInputDataConfig other = (ModelInvocationJobInputDataConfig) obj;
        return Objects.equals(s3InputDataConfig(), other.s3InputDataConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelInvocationJobInputDataConfig").add("S3InputDataConfig", s3InputDataConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3InputDataConfig":
            return Optional.ofNullable(clazz.cast(s3InputDataConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3InputDataConfig()} initialized to the given value.
     *
     * <p>
     * Contains the configuration of the S3 location of the input data.
     * </p>
     * 
     * @param s3InputDataConfig
     *        Contains the configuration of the S3 location of the input data.
     */
    public static ModelInvocationJobInputDataConfig fromS3InputDataConfig(ModelInvocationJobS3InputDataConfig s3InputDataConfig) {
        return builder().s3InputDataConfig(s3InputDataConfig).build();
    }

    /**
     * Create an instance of this class with {@link #s3InputDataConfig()} initialized to the given value.
     *
     * <p>
     * Contains the configuration of the S3 location of the input data.
     * </p>
     * 
     * @param s3InputDataConfig
     *        Contains the configuration of the S3 location of the input data.
     */
    public static ModelInvocationJobInputDataConfig fromS3InputDataConfig(
            Consumer<ModelInvocationJobS3InputDataConfig.Builder> s3InputDataConfig) {
        ModelInvocationJobS3InputDataConfig.Builder builder = ModelInvocationJobS3InputDataConfig.builder();
        s3InputDataConfig.accept(builder);
        return fromS3InputDataConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3InputDataConfig", S3_INPUT_DATA_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelInvocationJobInputDataConfig, T> g) {
        return obj -> g.apply((ModelInvocationJobInputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelInvocationJobInputDataConfig> {
        /**
         * <p>
         * Contains the configuration of the S3 location of the input data.
         * </p>
         * 
         * @param s3InputDataConfig
         *        Contains the configuration of the S3 location of the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3InputDataConfig(ModelInvocationJobS3InputDataConfig s3InputDataConfig);

        /**
         * <p>
         * Contains the configuration of the S3 location of the input data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ModelInvocationJobS3InputDataConfig.Builder} avoiding the need to create one manually via
         * {@link ModelInvocationJobS3InputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelInvocationJobS3InputDataConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #s3InputDataConfig(ModelInvocationJobS3InputDataConfig)}.
         * 
         * @param s3InputDataConfig
         *        a consumer that will call methods on {@link ModelInvocationJobS3InputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3InputDataConfig(ModelInvocationJobS3InputDataConfig)
         */
        default Builder s3InputDataConfig(Consumer<ModelInvocationJobS3InputDataConfig.Builder> s3InputDataConfig) {
            return s3InputDataConfig(ModelInvocationJobS3InputDataConfig.builder().applyMutation(s3InputDataConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ModelInvocationJobS3InputDataConfig s3InputDataConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ModelInvocationJobInputDataConfig model) {
            s3InputDataConfig(model.s3InputDataConfig);
        }

        public final ModelInvocationJobS3InputDataConfig.Builder getS3InputDataConfig() {
            return s3InputDataConfig != null ? s3InputDataConfig.toBuilder() : null;
        }

        public final void setS3InputDataConfig(ModelInvocationJobS3InputDataConfig.BuilderImpl s3InputDataConfig) {
            Object oldValue = this.s3InputDataConfig;
            this.s3InputDataConfig = s3InputDataConfig != null ? s3InputDataConfig.build() : null;
            handleUnionValueChange(Type.S3_INPUT_DATA_CONFIG, oldValue, this.s3InputDataConfig);
        }

        @Override
        public final Builder s3InputDataConfig(ModelInvocationJobS3InputDataConfig s3InputDataConfig) {
            Object oldValue = this.s3InputDataConfig;
            this.s3InputDataConfig = s3InputDataConfig;
            handleUnionValueChange(Type.S3_INPUT_DATA_CONFIG, oldValue, this.s3InputDataConfig);
            return this;
        }

        @Override
        public ModelInvocationJobInputDataConfig build() {
            return new ModelInvocationJobInputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ModelInvocationJobInputDataConfig#type()
     */
    public enum Type {
        S3_INPUT_DATA_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
