/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration details for retrieval of information and response generation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RAGConfig implements SdkPojo, Serializable, ToCopyableBuilder<RAGConfig.Builder, RAGConfig> {
    private static final SdkField<KnowledgeBaseConfig> KNOWLEDGE_BASE_CONFIG_FIELD = SdkField
            .<KnowledgeBaseConfig> builder(MarshallingType.SDK_POJO).memberName("knowledgeBaseConfig")
            .getter(getter(RAGConfig::knowledgeBaseConfig)).setter(setter(Builder::knowledgeBaseConfig))
            .constructor(KnowledgeBaseConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KnowledgeBaseConfig knowledgeBaseConfig;

    private final Type type;

    private RAGConfig(BuilderImpl builder) {
        this.knowledgeBaseConfig = builder.knowledgeBaseConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains configuration details for knowledge base retrieval and response generation.
     * </p>
     * 
     * @return Contains configuration details for knowledge base retrieval and response generation.
     */
    public final KnowledgeBaseConfig knowledgeBaseConfig() {
        return knowledgeBaseConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RAGConfig)) {
            return false;
        }
        RAGConfig other = (RAGConfig) obj;
        return Objects.equals(knowledgeBaseConfig(), other.knowledgeBaseConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RAGConfig").add("KnowledgeBaseConfig", knowledgeBaseConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseConfig":
            return Optional.ofNullable(clazz.cast(knowledgeBaseConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #knowledgeBaseConfig()} initialized to the given value.
     *
     * <p>
     * Contains configuration details for knowledge base retrieval and response generation.
     * </p>
     * 
     * @param knowledgeBaseConfig
     *        Contains configuration details for knowledge base retrieval and response generation.
     */
    public static RAGConfig fromKnowledgeBaseConfig(KnowledgeBaseConfig knowledgeBaseConfig) {
        return builder().knowledgeBaseConfig(knowledgeBaseConfig).build();
    }

    /**
     * Create an instance of this class with {@link #knowledgeBaseConfig()} initialized to the given value.
     *
     * <p>
     * Contains configuration details for knowledge base retrieval and response generation.
     * </p>
     * 
     * @param knowledgeBaseConfig
     *        Contains configuration details for knowledge base retrieval and response generation.
     */
    public static RAGConfig fromKnowledgeBaseConfig(Consumer<KnowledgeBaseConfig.Builder> knowledgeBaseConfig) {
        KnowledgeBaseConfig.Builder builder = KnowledgeBaseConfig.builder();
        knowledgeBaseConfig.accept(builder);
        return fromKnowledgeBaseConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseConfig", KNOWLEDGE_BASE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RAGConfig, T> g) {
        return obj -> g.apply((RAGConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RAGConfig> {
        /**
         * <p>
         * Contains configuration details for knowledge base retrieval and response generation.
         * </p>
         * 
         * @param knowledgeBaseConfig
         *        Contains configuration details for knowledge base retrieval and response generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseConfig(KnowledgeBaseConfig knowledgeBaseConfig);

        /**
         * <p>
         * Contains configuration details for knowledge base retrieval and response generation.
         * </p>
         * This is a convenience method that creates an instance of the {@link KnowledgeBaseConfig.Builder} avoiding the
         * need to create one manually via {@link KnowledgeBaseConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #knowledgeBaseConfig(KnowledgeBaseConfig)}.
         * 
         * @param knowledgeBaseConfig
         *        a consumer that will call methods on {@link KnowledgeBaseConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseConfig(KnowledgeBaseConfig)
         */
        default Builder knowledgeBaseConfig(Consumer<KnowledgeBaseConfig.Builder> knowledgeBaseConfig) {
            return knowledgeBaseConfig(KnowledgeBaseConfig.builder().applyMutation(knowledgeBaseConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KnowledgeBaseConfig knowledgeBaseConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RAGConfig model) {
            knowledgeBaseConfig(model.knowledgeBaseConfig);
        }

        public final KnowledgeBaseConfig.Builder getKnowledgeBaseConfig() {
            return knowledgeBaseConfig != null ? knowledgeBaseConfig.toBuilder() : null;
        }

        public final void setKnowledgeBaseConfig(KnowledgeBaseConfig.BuilderImpl knowledgeBaseConfig) {
            Object oldValue = this.knowledgeBaseConfig;
            this.knowledgeBaseConfig = knowledgeBaseConfig != null ? knowledgeBaseConfig.build() : null;
            handleUnionValueChange(Type.KNOWLEDGE_BASE_CONFIG, oldValue, this.knowledgeBaseConfig);
        }

        @Override
        public final Builder knowledgeBaseConfig(KnowledgeBaseConfig knowledgeBaseConfig) {
            Object oldValue = this.knowledgeBaseConfig;
            this.knowledgeBaseConfig = knowledgeBaseConfig;
            handleUnionValueChange(Type.KNOWLEDGE_BASE_CONFIG, oldValue, this.knowledgeBaseConfig);
            return this;
        }

        @Override
        public RAGConfig build() {
            return new RAGConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RAGConfig#type()
     */
    public enum Type {
        KNOWLEDGE_BASE_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
