/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelCopyJobRequest extends BedrockRequest implements
        ToCopyableBuilder<CreateModelCopyJobRequest.Builder, CreateModelCopyJobRequest> {
    private static final SdkField<String> SOURCE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceModelArn").getter(getter(CreateModelCopyJobRequest::sourceModelArn))
            .setter(setter(Builder::sourceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceModelArn").build()).build();

    private static final SdkField<String> TARGET_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetModelName").getter(getter(CreateModelCopyJobRequest::targetModelName))
            .setter(setter(Builder::targetModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetModelName").build()).build();

    private static final SdkField<String> MODEL_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelKmsKeyId").getter(getter(CreateModelCopyJobRequest::modelKmsKeyId))
            .setter(setter(Builder::modelKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelKmsKeyId").build()).build();

    private static final SdkField<List<Tag>> TARGET_MODEL_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("targetModelTags")
            .getter(getter(CreateModelCopyJobRequest::targetModelTags))
            .setter(setter(Builder::targetModelTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetModelTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateModelCopyJobRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_MODEL_ARN_FIELD,
            TARGET_MODEL_NAME_FIELD, MODEL_KMS_KEY_ID_FIELD, TARGET_MODEL_TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sourceModelArn;

    private final String targetModelName;

    private final String modelKmsKeyId;

    private final List<Tag> targetModelTags;

    private final String clientRequestToken;

    private CreateModelCopyJobRequest(BuilderImpl builder) {
        super(builder);
        this.sourceModelArn = builder.sourceModelArn;
        this.targetModelName = builder.targetModelName;
        this.modelKmsKeyId = builder.modelKmsKeyId;
        this.targetModelTags = builder.targetModelTags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model to be copied.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model to be copied.
     */
    public final String sourceModelArn() {
        return sourceModelArn;
    }

    /**
     * <p>
     * A name for the copied model.
     * </p>
     * 
     * @return A name for the copied model.
     */
    public final String targetModelName() {
        return targetModelName;
    }

    /**
     * <p>
     * The ARN of the KMS key that you use to encrypt the model copy.
     * </p>
     * 
     * @return The ARN of the KMS key that you use to encrypt the model copy.
     */
    public final String modelKmsKeyId() {
        return modelKmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetModelTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetModelTags() {
        return targetModelTags != null && !(targetModelTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to associate with the target model. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tag resources</a> in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetModelTags} method.
     * </p>
     * 
     * @return Tags to associate with the target model. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tag resources</a> in the <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     *         Guide</a>.
     */
    public final List<Tag> targetModelTags() {
        return targetModelTags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
     *         this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetModelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetModelTags() ? targetModelTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelCopyJobRequest)) {
            return false;
        }
        CreateModelCopyJobRequest other = (CreateModelCopyJobRequest) obj;
        return Objects.equals(sourceModelArn(), other.sourceModelArn())
                && Objects.equals(targetModelName(), other.targetModelName())
                && Objects.equals(modelKmsKeyId(), other.modelKmsKeyId()) && hasTargetModelTags() == other.hasTargetModelTags()
                && Objects.equals(targetModelTags(), other.targetModelTags())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateModelCopyJobRequest").add("SourceModelArn", sourceModelArn())
                .add("TargetModelName", targetModelName()).add("ModelKmsKeyId", modelKmsKeyId())
                .add("TargetModelTags", hasTargetModelTags() ? targetModelTags() : null)
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceModelArn":
            return Optional.ofNullable(clazz.cast(sourceModelArn()));
        case "targetModelName":
            return Optional.ofNullable(clazz.cast(targetModelName()));
        case "modelKmsKeyId":
            return Optional.ofNullable(clazz.cast(modelKmsKeyId()));
        case "targetModelTags":
            return Optional.ofNullable(clazz.cast(targetModelTags()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceModelArn", SOURCE_MODEL_ARN_FIELD);
        map.put("targetModelName", TARGET_MODEL_NAME_FIELD);
        map.put("modelKmsKeyId", MODEL_KMS_KEY_ID_FIELD);
        map.put("targetModelTags", TARGET_MODEL_TAGS_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateModelCopyJobRequest, T> g) {
        return obj -> g.apply((CreateModelCopyJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateModelCopyJobRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model to be copied.
         * </p>
         * 
         * @param sourceModelArn
         *        The Amazon Resource Name (ARN) of the model to be copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceModelArn(String sourceModelArn);

        /**
         * <p>
         * A name for the copied model.
         * </p>
         * 
         * @param targetModelName
         *        A name for the copied model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetModelName(String targetModelName);

        /**
         * <p>
         * The ARN of the KMS key that you use to encrypt the model copy.
         * </p>
         * 
         * @param modelKmsKeyId
         *        The ARN of the KMS key that you use to encrypt the model copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelKmsKeyId(String modelKmsKeyId);

        /**
         * <p>
         * Tags to associate with the target model. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tag resources</a> in the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
         * Guide</a>.
         * </p>
         * 
         * @param targetModelTags
         *        Tags to associate with the target model. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tag resources</a> in the <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetModelTags(Collection<Tag> targetModelTags);

        /**
         * <p>
         * Tags to associate with the target model. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tag resources</a> in the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
         * Guide</a>.
         * </p>
         * 
         * @param targetModelTags
         *        Tags to associate with the target model. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tag resources</a> in the <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetModelTags(Tag... targetModelTags);

        /**
         * <p>
         * Tags to associate with the target model. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tag resources</a> in the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
         * Guide</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.bedrock.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #targetModelTags(List<Tag>)}.
         * 
         * @param targetModelTags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetModelTags(java.util.Collection<Tag>)
         */
        Builder targetModelTags(Consumer<Tag.Builder>... targetModelTags);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String sourceModelArn;

        private String targetModelName;

        private String modelKmsKeyId;

        private List<Tag> targetModelTags = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelCopyJobRequest model) {
            super(model);
            sourceModelArn(model.sourceModelArn);
            targetModelName(model.targetModelName);
            modelKmsKeyId(model.modelKmsKeyId);
            targetModelTags(model.targetModelTags);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getSourceModelArn() {
            return sourceModelArn;
        }

        public final void setSourceModelArn(String sourceModelArn) {
            this.sourceModelArn = sourceModelArn;
        }

        @Override
        public final Builder sourceModelArn(String sourceModelArn) {
            this.sourceModelArn = sourceModelArn;
            return this;
        }

        public final String getTargetModelName() {
            return targetModelName;
        }

        public final void setTargetModelName(String targetModelName) {
            this.targetModelName = targetModelName;
        }

        @Override
        public final Builder targetModelName(String targetModelName) {
            this.targetModelName = targetModelName;
            return this;
        }

        public final String getModelKmsKeyId() {
            return modelKmsKeyId;
        }

        public final void setModelKmsKeyId(String modelKmsKeyId) {
            this.modelKmsKeyId = modelKmsKeyId;
        }

        @Override
        public final Builder modelKmsKeyId(String modelKmsKeyId) {
            this.modelKmsKeyId = modelKmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTargetModelTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.targetModelTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetModelTags(Collection<Tag.BuilderImpl> targetModelTags) {
            this.targetModelTags = TagListCopier.copyFromBuilder(targetModelTags);
        }

        @Override
        public final Builder targetModelTags(Collection<Tag> targetModelTags) {
            this.targetModelTags = TagListCopier.copy(targetModelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetModelTags(Tag... targetModelTags) {
            targetModelTags(Arrays.asList(targetModelTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetModelTags(Consumer<Tag.Builder>... targetModelTags) {
            targetModelTags(Stream.of(targetModelTags).map(c -> Tag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelCopyJobRequest build() {
            return new CreateModelCopyJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
